/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.profile.healthcare;

import com.verisign.domutil.DOMCursor;
import com.verisign.profile.InformationNotPresentException;
import com.verisign.profile.healthcare.HealthcareProfile;
import com.verisign.profile.healthcare.Issuer;

public class License {
    private Issuer issuer;
    private String number;
    private boolean hasSanctions;

    License(DOMCursor c, Issuer issuer) {
        if (!c.atElement("http://www.verisign.com/xml/schema/profile-healthcare-2002-01", "license")) {
            throw new InformationNotPresentException("expected license element but got " + c);
        }
        this.number = HealthcareProfile.getChildText(c, "number");
        if (this.number == null) {
            throw new InformationNotPresentException("missing license number under " + c);
        }
        this.hasSanctions = "true".equals(c.getAttribute("sanctions"));
        this.issuer = issuer;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public String getNumber() {
        return this.number;
    }

    public boolean hasSanctions() {
        return this.hasSanctions;
    }
}

