/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.profile.healthcare;

import com.verisign.domutil.DOMCursor;
import com.verisign.profile.InformationNotPresentException;
import com.verisign.profile.healthcare.License;
import java.util.ArrayList;
import java.util.List;

public class Issuer {
    public static final String STATE_LICENSE_BOARD = "LicenseBoard";
    public static final String US_DEA = "ZD";
    public static final String US_HHS = "HH";
    public static final String US_VA = "ZV";
    public static final String US_DD = "DD";
    public static final String US_ARMY = "ZA";
    public static final String US_NAVY = "ZN";
    public static final String US_AIRFORCE = "ZF";
    public static final String US_SS = "SS";
    List licenses;
    private String name;
    private String state;
    private boolean hasSanctions;

    Issuer(DOMCursor c) {
        if (!c.atElement("http://www.verisign.com/xml/schema/profile-healthcare-2002-01", "issuer")) {
            throw new InformationNotPresentException("expected issuer element but got " + c);
        }
        this.name = c.getAttribute("name");
        if (this.name == null || this.name.length() == 0) {
            throw new InformationNotPresentException("missing issuer/@name at " + c);
        }
        this.state = c.getAttribute("state");
        if (this.state != null && this.state.length() == 0) {
            this.state = null;
        }
        this.hasSanctions = "true".equals(c.getAttribute("sanctions"));
        this.licenses = new ArrayList();
        boolean moreLicenses = c.moveToChild(1);
        while (moreLicenses) {
            try {
                License lic = new License(c.cloneCursor(), this);
                this.licenses.add(lic);
            }
            catch (InformationNotPresentException informationNotPresentException) {
                // empty catch block
            }
            moreLicenses = c.moveToSibling(1);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getState() {
        return this.state;
    }

    public boolean hasSanctions() {
        return this.hasSanctions;
    }

    public License[] getLicenses() {
        License[] a = new License[this.licenses.size()];
        this.licenses.toArray(a);
        return a;
    }

    static {
        STATE_LICENSE_BOARD = STATE_LICENSE_BOARD;
        US_DEA = US_DEA;
        US_HHS = US_HHS;
        US_VA = US_VA;
        US_DD = US_DD;
        US_ARMY = US_ARMY;
        US_NAVY = US_NAVY;
        US_AIRFORCE = US_AIRFORCE;
        US_SS = US_SS;
    }
}

