/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.profile.healthcare;

import com.verisign.messaging.InsecureTransportException;
import com.verisign.messaging.XmlMessageException;
import com.verisign.messaging.XmlTransport;
import com.verisign.messaging.XmlTransportSecurity;
import com.verisign.profile.ProfileAttributeData;
import com.verisign.profile.ProfileAttributeQuery;
import com.verisign.profile.ProfileEntity;
import com.verisign.profile.ProfileNameAssertion;
import com.verisign.profile.ProfilePrincipal;
import com.verisign.profile.ProfileRequest;
import com.verisign.profile.ProfileResponse;
import com.verisign.profile.UnsuccessfulRequestException;
import com.verisign.profile.healthcare.BasicProfile;
import com.verisign.profile.healthcare.HealthcareProfile;
import com.verisign.profile.healthcare.PremiumProfile;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;

public class HealthcareProfileService {
    private X509Certificate rpCert;
    private byte[] rpCertEncoded;
    private XmlTransport transport;

    public HealthcareProfileService(XmlTransport transport) throws CertificateException {
        if (transport == null) {
            throw new NullPointerException("transport is null");
        }
        try {
            XmlTransportSecurity sec = (XmlTransportSecurity)((Object)transport);
            this.rpCert = sec.getSigningCertificate();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("transport class must implement XmlTransportSecurity");
        }
        if (this.rpCert == null) {
            throw new IllegalArgumentException("transport does not contain a signing certificate");
        }
        this.rpCertEncoded = this.rpCert.getEncoded();
        this.transport = transport;
    }

    public HealthcareProfile getProfile(X509Certificate subjectCert, String profileName) throws IOException, InsecureTransportException, GeneralSecurityException, UnsuccessfulRequestException, XmlMessageException {
        if (profileName.equals("BasicProfile")) {
            return this.getBasicProfile(subjectCert);
        }
        if (profileName.equals("PremiumProfile")) {
            return this.getPremiumProfile(subjectCert);
        }
        return new HealthcareProfile(this.getProfileMap(subjectCert, profileName), profileName);
    }

    public HealthcareProfile getProfile(String healthcareId, String profileName) throws IOException, InsecureTransportException, GeneralSecurityException, UnsuccessfulRequestException, XmlMessageException {
        if (profileName.equals("BasicProfile")) {
            return this.getBasicProfile(healthcareId);
        }
        if (profileName.equals("PremiumProfile")) {
            return this.getPremiumProfile(healthcareId);
        }
        return new HealthcareProfile(this.getProfileMap(healthcareId, profileName), profileName);
    }

    public BasicProfile getBasicProfile(X509Certificate subjectCert) throws IOException, InsecureTransportException, GeneralSecurityException, UnsuccessfulRequestException, XmlMessageException {
        return new BasicProfile(this.getProfileMap(subjectCert, "BasicProfile"), "BasicProfile");
    }

    public BasicProfile getBasicProfile(String healthcareId) throws IOException, InsecureTransportException, GeneralSecurityException, UnsuccessfulRequestException, XmlMessageException {
        return new BasicProfile(this.getProfileMap(healthcareId, "BasicProfile"), "BasicProfile");
    }

    public PremiumProfile getPremiumProfile(X509Certificate subjectCert) throws IOException, InsecureTransportException, GeneralSecurityException, UnsuccessfulRequestException, XmlMessageException {
        return new PremiumProfile(this.getProfileMap(subjectCert, "PremiumProfile"), "PremiumProfile");
    }

    public PremiumProfile getPremiumProfile(String healthcareId) throws IOException, InsecureTransportException, GeneralSecurityException, UnsuccessfulRequestException, XmlMessageException {
        return new PremiumProfile(this.getProfileMap(healthcareId, "PremiumProfile"), "PremiumProfile");
    }

    private Map getProfileMap(X509Certificate subjectCert, String profileName) throws IOException, InsecureTransportException, CertificateException, GeneralSecurityException, UnsuccessfulRequestException, XmlMessageException {
        if (subjectCert == null) {
            throw new NullPointerException("subjectCert is null");
        }
        return this.getProfileMap("subjectCert", subjectCert.getEncoded(), profileName);
    }

    private Map getProfileMap(String healthcareId, String profileName) throws IOException, InsecureTransportException, CertificateException, GeneralSecurityException, UnsuccessfulRequestException, XmlMessageException {
        if (healthcareId == null) {
            throw new NullPointerException("healthcareId is null");
        }
        return this.getProfileMap("healthCareID", healthcareId, profileName);
    }

    private Map getProfileMap(String entityKey, Object entityValue, String profileName) throws IOException, InsecureTransportException, CertificateException, GeneralSecurityException, UnsuccessfulRequestException, XmlMessageException {
        ProfileAttributeQuery query;
        if (profileName == null) {
            throw new NullPointerException("profileName is null");
        }
        ProfileNameAssertion na = this.makeNameAssertion(new ProfileEntity(entityKey, entityValue));
        ProfileRequest req = new ProfileRequest(na, query = new ProfileAttributeQuery(null, Collections.singleton(profileName)));
        ProfileResponse resp = req.sendRequest(this.transport);
        ProfileAttributeData attrData = (ProfileAttributeData)resp.getEntitlement().getAzData();
        Map attrs = attrData.getAttributes();
        if (attrs.get(profileName) == null) {
            throw new IllegalArgumentException("Attribute missing " + profileName);
        }
        return attrs;
    }

    private ProfileNameAssertion makeNameAssertion(ProfilePrincipal principal) {
        return new ProfileNameAssertion(principal, "http://ems.verisign.com/pems", this.rpCert);
    }
}

