/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.profile.healthcare;

import com.verisign.domutil.DOMCursor;
import com.verisign.profile.Profile;
import com.verisign.profile.ProfileAttribute;
import java.util.Map;
import org.w3c.dom.Element;

public class HealthcareProfile
extends Profile {
    public static final String PROFILE_BASIC = "BasicProfile";
    public static final String PROFILE_PREMIUM = "PremiumProfile";
    public static final String PROFILE_AFFILIATE = "AffiliateProfile";
    public static final String TYPE_STUDENT = "Student";
    public static final String TYPE_RESIDENT = "Resident";
    public static final String TYPE_PHYSICIAN = "Physician";
    public static final String TYPE_AFFILIATE = "Affiliate";
    public static final String NAMESPACE = "http://www.verisign.com/xml/schema/profile-healthcare-2002-01";
    private Element elem;
    private String profileName;
    private String healthcareId;

    protected HealthcareProfile(Map attrs, String profileName) {
        super(attrs);
        ProfileAttribute attr = (ProfileAttribute)attrs.get(profileName);
        if (attr == null) {
            throw new IllegalArgumentException("Missing profile attribute");
        }
        this.elem = attr.getValueElement();
        this.profileName = profileName;
        DOMCursor c = new DOMCursor(this.elem);
        this.healthcareId = HealthcareProfile.getChildText(c, "healthCareId");
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getHealthcareID() {
        return this.healthcareId;
    }

    public Element getXML() {
        return this.elem;
    }

    String getChildText(String elemName) {
        DOMCursor c = new DOMCursor(this.elem);
        return HealthcareProfile.getChildText(c, elemName);
    }

    static String getChildText(DOMCursor c, String elemName) {
        if (c.moveToChild(NAMESPACE, elemName)) {
            String text = c.getText();
            c.moveToParent();
            if (text.length() > 0) {
                return text;
            }
            return null;
        }
        return null;
    }

    static {
        PROFILE_BASIC = PROFILE_BASIC;
        PROFILE_PREMIUM = PROFILE_PREMIUM;
        PROFILE_AFFILIATE = PROFILE_AFFILIATE;
        TYPE_STUDENT = TYPE_STUDENT;
        TYPE_RESIDENT = TYPE_RESIDENT;
        TYPE_PHYSICIAN = TYPE_PHYSICIAN;
        TYPE_AFFILIATE = TYPE_AFFILIATE;
        NAMESPACE = NAMESPACE;
    }
}

