/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.profile.healthcare;

import com.verisign.datatypes.DateTime;
import com.verisign.domutil.DOMCursor;
import com.verisign.profile.InformationNotPresentException;
import com.verisign.profile.healthcare.HealthcareProfile;
import com.verisign.profile.healthcare.Issuer;
import com.verisign.profile.healthcare.License;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BasicProfile
extends HealthcareProfile {
    boolean hasAnySanctions;
    Map issuerMap = new HashMap();
    private List allLicenses = new ArrayList();
    private String subjectType;
    private String firstName;
    private String middleName;
    private String lastName;
    private int amaConfirmationLevel;
    private Date dateOfBirth;
    private String practiceName;
    private String upinNumber;

    protected BasicProfile(Map attrs, String profileName) {
        super(attrs, profileName);
        String text;
        DOMCursor c = new DOMCursor(this.getXML());
        this.subjectType = HealthcareProfile.getChildText(c, "type");
        this.upinNumber = HealthcareProfile.getChildText(c, "upinNumber");
        this.practiceName = HealthcareProfile.getChildText(c, "practiceName");
        if (c.moveToChild("http://www.verisign.com/xml/schema/profile-healthcare-2002-01", "name")) {
            this.firstName = HealthcareProfile.getChildText(c, "first");
            this.middleName = HealthcareProfile.getChildText(c, "middle");
            this.lastName = HealthcareProfile.getChildText(c, "last");
            c.moveToParent();
        }
        if ((text = this.getChildText("dateOfBirth")) != null) {
            try {
                this.dateOfBirth = DateTime.parseISODate(text);
            }
            catch (ParseException ignored) {
                // empty catch block
            }
        }
        if ((text = HealthcareProfile.getChildText(c, "amaConfirmation")) != null && text.length() > 0) {
            try {
                this.amaConfirmationLevel = Integer.parseInt(text);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        if (c.moveToChild("http://www.verisign.com/xml/schema/profile-healthcare-2002-01", "licenses")) {
            boolean moreIssuers = c.moveToChild(1);
            while (moreIssuers) {
                try {
                    Issuer issuer = new Issuer(c.cloneCursor());
                    this.issuerMap.put(this.makeIssuerKey(issuer.getName(), issuer.getState()), issuer);
                    if (issuer.hasSanctions()) {
                        this.hasAnySanctions = true;
                    }
                    this.allLicenses.addAll(issuer.licenses);
                }
                catch (InformationNotPresentException ignored) {
                    // empty catch block
                }
                moreIssuers = c.moveToSibling(1);
            }
        }
    }

    public String getSubjectType() {
        return this.subjectType;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public int getAmaConfirmationLevel() {
        return this.amaConfirmationLevel;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public String getPracticeName() {
        return this.practiceName;
    }

    public String getUpinNumber() {
        return this.upinNumber;
    }

    public License[] getLicenses() {
        License[] a = new License[this.allLicenses.size()];
        this.allLicenses.toArray(a);
        return a;
    }

    public Issuer[] getIssuers() {
        Collection issuers = this.issuerMap.values();
        Issuer[] a = new Issuer[issuers.size()];
        issuers.toArray(a);
        return a;
    }

    public Issuer getIssuer(String name) {
        return (Issuer)this.issuerMap.get(this.makeIssuerKey(name, null));
    }

    final String makeIssuerKey(String name, String state) {
        return state != null ? name + '.' + state : name;
    }
}

