/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.profile.business;

import com.verisign.messaging.InsecureTransportException;
import com.verisign.messaging.XmlMessageException;
import com.verisign.messaging.XmlTransport;
import com.verisign.messaging.XmlTransportSecurity;
import com.verisign.profile.ProfileAttribute;
import com.verisign.profile.ProfileAttributeData;
import com.verisign.profile.ProfileAttributeQuery;
import com.verisign.profile.ProfileDictionaryQuery;
import com.verisign.profile.ProfileEntity;
import com.verisign.profile.ProfileNameAssertion;
import com.verisign.profile.ProfilePrincipal;
import com.verisign.profile.ProfileRequest;
import com.verisign.profile.ProfileResponse;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class BusinessProfileService {
    private X509Certificate rpCert;
    private byte[] rpCertEncoded;
    private XmlTransport transport;
    private ProfileNameAssertion reflexiveNameAssertion;

    public BusinessProfileService(XmlTransport transport) throws CertificateException {
        if (transport == null) {
            throw new NullPointerException("transport is null");
        }
        try {
            XmlTransportSecurity sec = (XmlTransportSecurity)((Object)transport);
            this.rpCert = sec.getSigningCertificate();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("transport class must implement XmlTransportSecurity");
        }
        if (this.rpCert == null) {
            throw new IllegalArgumentException("transport does not contain a signing certificate");
        }
        this.rpCertEncoded = this.rpCert.getEncoded();
        this.transport = transport;
    }

    private ProfileNameAssertion makeNameAssertion(ProfilePrincipal principal) {
        return new ProfileNameAssertion(principal, "http://ems.verisign.com/tpms", this.rpCert);
    }

    public ProfileAttributeData getDictionary() throws IOException, XmlMessageException, InsecureTransportException, GeneralSecurityException {
        ProfileDictionaryQuery query = new ProfileDictionaryQuery(null);
        ProfileNameAssertion na = this.makeNameAssertion(new ProfileEntity("Requestor", this.rpCertEncoded));
        ProfileRequest req = new ProfileRequest(na, query);
        ProfileResponse resp = req.sendRequest(this.transport);
        return (ProfileAttributeData)resp.getEntitlement().getAzData();
    }

    public Map getProfile(String DUNSNumber, String countryCode, String[] attributes) throws IOException, XmlMessageException, InsecureTransportException, GeneralSecurityException {
        if (DUNSNumber == null) {
            throw new NullPointerException("DUNSNumber is null");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes is null");
        }
        if (attributes.length == 0) {
            throw new IllegalArgumentException("attributes is zero-length");
        }
        int i = 0;
        while (i < attributes.length) {
            if (attributes[i] == null) {
                throw new NullPointerException("attributes[" + i + "] is null");
            }
            ++i;
        }
        ProfileAttributeQuery query = new ProfileAttributeQuery(null, new HashSet<String>(Arrays.asList(attributes)));
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("DUNSNumber", DUNSNumber);
        if (countryCode != null) {
            m.put("countryCode", countryCode);
        }
        ProfileNameAssertion na = this.makeNameAssertion(new ProfileEntity(m));
        ProfileRequest req = new ProfileRequest(na, query);
        ProfileResponse resp = req.sendRequest(this.transport);
        ProfileAttributeData prof = (ProfileAttributeData)resp.getEntitlement().getAzData();
        m.clear();
        Iterator it = prof.getAttributes().values().iterator();
        while (it.hasNext()) {
            ProfileAttribute attr = (ProfileAttribute)it.next();
            m.put(attr.getName(), attr.getValue());
        }
        return Collections.unmodifiableMap(m);
    }
}

