/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.profile;

import com.verisign.messaging.AbstractResponse;
import com.verisign.profile.ProfileEntitlement;
import com.verisign.profile.ProfileRequest;
import com.verisign.resource.DOMOperations;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProfileResponse
extends AbstractResponse {
    private static final DOMOperations ops = DOMOperations.getInstance();
    String id;
    Date date;
    ProfileEntitlement ent;
    String result;
    String errmsg;
    Element signature;
    Certificate[] certChain;

    ProfileResponse(ProfileRequest req, Document doc) throws GeneralSecurityException {
        super(req, doc);
        String inResponseTo = null;
        Element root = doc.getDocumentElement();
        if (!ops.matchName(root, "http://ns.s2ml.org/s2ml", "AzResponse")) {
            throw new IllegalArgumentException("Response document element not S2ML:AzResponse");
        }
        Element elt = ops.firstElementChild(root);
        while (elt != null) {
            if (ops.matchName(elt, "http://ns.s2ml.org/s2ml", "ID")) {
                this.id = ops.stringValueOfNode(elt);
            } else if (ops.matchName(elt, "http://ns.s2ml.org/s2ml", "InResponseTo")) {
                inResponseTo = ops.stringValueOfNode(elt);
            } else if (ops.matchName(elt, "http://ns.s2ml.org/s2ml", "Date")) {
                this.date = ops.parseISODate(ops.stringValueOfNode(elt));
            } else if (ops.matchName(elt, "http://ns.s2ml.org/s2ml", "Entitlement")) {
                this.ent = new ProfileEntitlement(elt);
            } else if (ops.matchName(elt, "http://ns.s2ml.org/s2ml", "Answer")) {
                Element aelt = ops.firstElementChild(elt);
                while (aelt != null) {
                    if (ops.matchName(aelt, "http://ns.s2ml.org/s2ml", "Result")) {
                        this.result = ops.stringValueOfNode(aelt);
                    } else if (ops.matchName(aelt, "http://ns.s2ml.org/s2ml", "ErrorInfo")) {
                        this.errmsg = ops.stringValueOfNode(aelt);
                    }
                    aelt = ops.nextElementSibling(aelt);
                }
            } else if (ops.matchName(elt, "http://www.w3.org/2000/09/xmldsig#", "Signature")) {
                this.signature = elt;
            }
            elt = ops.nextElementSibling(elt);
        }
        if (inResponseTo == null) {
            throw new IllegalArgumentException("inResponseTo header not found");
        }
        if (!inResponseTo.equals(req.getID())) {
            throw new IllegalArgumentException("inResponseTo header does not match request ID");
        }
        if (this.id == null) {
            throw new IllegalArgumentException("ID not found");
        }
        if (this.date == null) {
            throw new IllegalArgumentException("Date not found");
        }
        if (this.result == null) {
            throw new IllegalArgumentException("Result not found");
        }
    }

    public boolean getStatus() {
        return "Success".equals(this.result);
    }

    public String getID() {
        return this.id;
    }

    public Date getDate() {
        return this.date;
    }

    public String getResult() {
        return this.result;
    }

    public String getErrorMessage() {
        return this.errmsg;
    }

    public ProfileEntitlement getEntitlement() {
        return this.ent;
    }
}

