/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.profile;

import com.verisign.messaging.InsecureTransportException;
import com.verisign.messaging.MessageProvider;
import com.verisign.messaging.XmlMessageException;
import com.verisign.messaging.XmlRequest;
import com.verisign.messaging.XmlResponse;
import com.verisign.messaging.XmlTransport;
import com.verisign.profile.ProfileNameAssertion;
import com.verisign.profile.ProfileProvider;
import com.verisign.profile.ProfileQuery;
import com.verisign.profile.ProfileResponse;
import com.verisign.profile.ProfileStamped;
import com.verisign.profile.UnsuccessfulRequestException;
import com.verisign.resource.DOMOperations;
import com.verisign.resource.ResourceFactory;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProfileRequest
extends ProfileStamped
implements XmlRequest {
    private static final DOMOperations ops = DOMOperations.getInstance();
    ProfileNameAssertion na;
    ProfileQuery q;
    private MessageProvider provider = ProfileProvider.getDefaultProvider();

    public ProfileRequest(ProfileNameAssertion na, ProfileQuery q) throws IOException, GeneralSecurityException {
        if (na == null) {
            throw new NullPointerException("na is null");
        }
        if (q == null) {
            throw new NullPointerException("q is null");
        }
        this.na = na;
        this.q = q;
    }

    Element appendXMLEncodedForm(Node node) throws GeneralSecurityException {
        Document doc = ops.document(node);
        Element azrq = ops.appendElementByExpandedName(node, "http://ns.s2ml.org/s2ml", "s2", "AzRequest");
        Element id = ops.appendElementByExpandedName(azrq, "http://ns.s2ml.org/s2ml", "s2", "ID");
        id.appendChild(doc.createTextNode(this.id));
        Element date = ops.appendElementByExpandedName(azrq, "http://ns.s2ml.org/s2ml", "s2", "Date");
        date.appendChild(doc.createTextNode(ops.formatISODate(this.date)));
        this.na.appendXMLEncodedForm(azrq);
        Element question = ops.appendElementByExpandedName(azrq, "http://ns.s2ml.org/s2ml", "s2", "Question");
        question.setAttribute("AzModel", "http://ems.verisign.com/2001/05/ems-s2ml#AzModel");
        this.q.appendXMLEncodedForm(question);
        return azrq;
    }

    public Document getXML() {
        Document doc = ResourceFactory.getXMLResource().createDocument();
        try {
            this.appendXMLEncodedForm(doc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException();
        }
        return doc;
    }

    public XmlResponse makeResponse(Document doc) throws XmlMessageException {
        ProfileResponse resp = null;
        try {
            resp = new ProfileResponse(this, doc);
            if (resp.getStatus()) {
                return resp;
            }
        }
        catch (Exception ex) {
            throw new XmlMessageException(ex, doc);
        }
        throw new UnsuccessfulRequestException(doc, resp);
    }

    public ProfileResponse sendRequest(XmlTransport transport) throws IOException, XmlMessageException, InsecureTransportException {
        return (ProfileResponse)transport.sendRequest(this);
    }

    public MessageProvider getProvider() {
        return this.provider;
    }

    public void setProvider(MessageProvider provider) {
        this.provider = provider;
    }
}

