/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.profile;

import com.verisign.messaging.InsecureTransportException;
import com.verisign.messaging.MessageProvider;
import com.verisign.messaging.XmlMessageException;
import com.verisign.messaging.XmlRequest;
import com.verisign.messaging.XmlTransport;
import com.verisign.messaging.XmlTransportSecurity;
import com.verisign.resource.ResourceFactory;
import com.verisign.xmlsig.util.XMLSigSchema;
import com.verisign.xpath.XPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import org.w3c.dom.Document;
import org.xmltrustcenter.verifier.AllPermissiveTrustVerifier;
import org.xmltrustcenter.verifier.TrustVerifier;
import org.xmltrustcenter.verifier.X509TrustVerifier;

public class ProfileProvider
extends MessageProvider {
    private static final String[] SCHEMA_FILES = new String[]{"pems_2002_03.xsd", "s2ml-2000-10.xsd"};
    private static Document[] schemaDocuments;
    private static MessageProvider defaultProvider;
    private static boolean secureTransportRequired;
    private TrustVerifier verifier = ProfileProvider.getDefaultProfileTrustVerifier();
    static /* synthetic */ Class class$com$verisign$profile$ProfileProvider;

    public static MessageProvider getDefaultProvider() throws IOException, KeyStoreException, GeneralSecurityException {
        if (defaultProvider == null) {
            defaultProvider = new ProfileProvider();
        }
        return defaultProvider;
    }

    public static void setDefaultProvider(MessageProvider provider) {
        defaultProvider = provider;
    }

    public void checkTransport(XmlTransport transport, XmlRequest request) throws XmlMessageException, InsecureTransportException {
        XmlTransportSecurity sec;
        try {
            sec = (XmlTransportSecurity)((Object)transport);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("transport class must implement XmlTransportSecurity");
        }
        if (sec.getSigningPrivateKey() == null) {
            throw new NullPointerException("transport class does not contain a signing private key");
        }
        if (secureTransportRequired && !sec.isTransportPrivate()) {
            throw new InsecureTransportException();
        }
    }

    public TrustVerifier getDefaultTrustVerifier() {
        return this.verifier;
    }

    public XPath getRequestSignatureLocation(Document request) {
        return MessageProvider.ROOT_ELEMENT_XPATH;
    }

    public XPath getResponseSignatureLocation(Document response) {
        return MessageProvider.LAST_CHILD_XPATH;
    }

    public Document[] getSchemaDocuments() throws XmlMessageException {
        if (schemaDocuments != null) {
            return schemaDocuments;
        }
        schemaDocuments = new Document[SCHEMA_FILES.length + 1];
        try {
            int i = 0;
            while (i < SCHEMA_FILES.length) {
                InputStream is = (class$com$verisign$profile$ProfileProvider == null ? ProfileProvider.class$("com.verisign.profile.ProfileProvider") : class$com$verisign$profile$ProfileProvider).getResourceAsStream(SCHEMA_FILES[i]);
                InputStreamReader reader = new InputStreamReader(is);
                ProfileProvider.schemaDocuments[i] = ResourceFactory.getXMLResource().parseXML(reader);
                reader.close();
                ++i;
            }
            ProfileProvider.schemaDocuments[ProfileProvider.SCHEMA_FILES.length] = XMLSigSchema.getSchemaDocument();
        }
        catch (IOException e) {
            throw new XmlMessageException("Error loading schema documents", e);
        }
        return schemaDocuments;
    }

    private static TrustVerifier getDefaultProfileTrustVerifier() throws IOException, KeyStoreException, GeneralSecurityException {
        if (Boolean.getBoolean("com.verisign.profile.skipTrustCheck")) {
            System.err.println("**************** WARNING ******************");
            System.err.println("EMS message signer trust checking disabled!");
            System.err.println("**************** WARNING ******************");
            return new AllPermissiveTrustVerifier();
        }
        Class cl = class$com$verisign$profile$ProfileProvider == null ? (class$com$verisign$profile$ProfileProvider = ProfileProvider.class$("com.verisign.profile.ProfileProvider")) : class$com$verisign$profile$ProfileProvider;
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream is = cl.getResourceAsStream("trustpoints.pilot");
        if (is == null) {
            is = cl.getResourceAsStream("trustpoints.prod");
        }
        if (is == null) {
            throw new IOException("Resource not found: com/verisign/profile/trustpoints.prod");
        }
        ks.load(is, null);
        return new X509TrustVerifier(ks);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        secureTransportRequired = true;
        try {
            secureTransportRequired = "true".equals(System.getProperty("com.verisign.profile.secureTransportRequired", "true"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

