/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.profile;

import com.verisign.datatypes.TimeInterval;
import com.verisign.datatypes.URIPrincipal;
import com.verisign.profile.ProfilePrincipal;
import com.verisign.profile.ProfileStamped;
import com.verisign.resource.DOMOperations;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProfileNameAssertion
extends ProfileStamped {
    private static final DOMOperations ops = DOMOperations.getInstance();
    private URIPrincipal issuer;
    private Set audiences;
    private ProfilePrincipal subject;
    private TimeInterval validityInterval;

    public ProfileNameAssertion(ProfilePrincipal subject, String audience, X509Certificate issuer) {
        this(new URIPrincipal("x509dn:" + URLEncoder.encode(issuer.getSubjectDN().getName())), Collections.singleton(new URIPrincipal(audience)), new TimeInterval(null, null), subject);
    }

    private ProfileNameAssertion(URIPrincipal issuer, Set audiences, TimeInterval validityInterval, ProfilePrincipal subject) {
        this.issuer = issuer;
        if (audiences != null) {
            this.audiences = new HashSet(audiences);
        }
        this.validityInterval = validityInterval;
        this.subject = subject;
    }

    public Principal getIssuer() {
        return this.issuer;
    }

    public Principal getSubject() {
        return this.subject;
    }

    public TimeInterval getValidityInterval() {
        return this.validityInterval;
    }

    Element appendXMLEncodedForm(Node node) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, InvalidKeySpecException, CertificateException {
        Document doc = ops.document(node);
        Element na = ops.appendElementByExpandedName(node, "http://ns.s2ml.org/s2ml", "s2", "NameAssertion");
        Element id = ops.appendElementByExpandedName(na, "http://ns.s2ml.org/s2ml", "s2", "ID");
        id.appendChild(doc.createTextNode(this.id));
        Element date = ops.appendElementByExpandedName(na, "http://ns.s2ml.org/s2ml", "s2", "Date");
        date.appendChild(doc.createTextNode(ops.formatISODate(this.date)));
        Element issuer = ops.appendElementByExpandedName(na, "http://ns.s2ml.org/s2ml", "s2", "Issuer");
        issuer.appendChild(doc.createTextNode(this.issuer.toString()));
        if (this.audiences != null) {
            Iterator it = this.audiences.iterator();
            StringBuffer sb = new StringBuffer();
            while (it.hasNext()) {
                URIPrincipal p = (URIPrincipal)it.next();
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(p.toString());
            }
            Element aud = ops.appendElementByExpandedName(na, "http://ns.s2ml.org/s2ml", "s2", "Audiences");
            aud.appendChild(doc.createTextNode(sb.toString()));
        }
        Element validityInterval = ops.appendElementByExpandedName(na, "http://ns.s2ml.org/s2ml", "s2", "ValidityInterval");
        if (this.validityInterval.getNotBefore() != Long.MIN_VALUE) {
            Element notBefore = ops.appendElementByExpandedName(validityInterval, "http://ns.s2ml.org/s2ml", "s2", "NotBefore");
            notBefore.appendChild(doc.createTextNode(ops.formatISODate(this.validityInterval.getNotBefore())));
        }
        if (this.validityInterval.getNotAfter() != Long.MAX_VALUE) {
            Element notAfter = ops.appendElementByExpandedName(validityInterval, "http://ns.s2ml.org/s2ml", "s2", "NotAfter");
            notAfter.appendChild(doc.createTextNode(ops.formatISODate(this.validityInterval.getNotAfter())));
        }
        Element authData = ops.appendElementByExpandedName(na, "http://ns.s2ml.org/s2ml", "s2", "AuthData");
        Element authType = ops.appendElementByExpandedName(authData, "http://ns.s2ml.org/s2ml", "s2", "AuthType");
        authType.appendChild(doc.createTextNode("AuthContent"));
        Element authContent = ops.appendElementByExpandedName(authData, "http://ns.s2ml.org/s2ml", "s2", "AuthContent");
        this.subject.appendXMLEncodedForm(authContent);
        return na;
    }
}

