/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.profile;

import com.verisign.digsig.encode.Base64;
import com.verisign.profile.ProfilePrincipal;
import com.verisign.resource.DOMOperations;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProfileEntity
extends ProfilePrincipal {
    private static final DOMOperations ops = DOMOperations.getInstance();
    private Map pairs = new HashMap();

    private ProfileEntity() {
    }

    public ProfileEntity(String key, Object value) {
        this();
        this.addPair(key, value);
    }

    public ProfileEntity(Map pairs) {
        this();
        if (pairs == null) {
            throw new IllegalArgumentException("pairs is null");
        }
        Iterator it = pairs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String key = (String)e.getKey();
            Object value = e.getValue();
            this.addPair(key, value);
        }
        if (this.pairs.isEmpty()) {
            throw new IllegalArgumentException("pairs is empty");
        }
    }

    private void addPair(String key, Object value) {
        String svalue;
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        if (value instanceof String) {
            svalue = (String)value;
        } else if (value instanceof byte[]) {
            svalue = Base64.encode((byte[])value, Integer.MAX_VALUE, "");
        } else {
            throw new ClassCastException("Unsupported value type: " + value.getClass().getName());
        }
        this.pairs.put(key, svalue);
    }

    public String getName() {
        return "[ProfileEntity: " + this.pairs.toString() + "]";
    }

    public int hashCode() {
        return this.pairs.hashCode() + 1;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof ProfileEntity && this.equals((ProfileEntity)obj);
    }

    public boolean equals(ProfileEntity obj) {
        return this.pairs.equals(obj.pairs);
    }

    Element appendXMLEncodedForm(Node node) {
        Document doc = ops.document(node);
        Element ent = ops.appendElementByExpandedName(node, "http://ems.verisign.com/2001/05/ems-s2ml#", "ems", "Entity");
        Iterator it = this.pairs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            Element qk = ops.appendElementByExpandedName(ent, "http://ems.verisign.com/2001/05/ems-s2ml#", "ems", "QueryKey");
            ops.setAttributeByExpandedName(qk, null, null, "name", key);
            qk.appendChild(doc.createTextNode(value));
        }
        return ent;
    }
}

