/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.profile;

import com.verisign.datatypes.TimeInterval;
import com.verisign.datatypes.URIPrincipal;
import com.verisign.profile.ProfileAzData;
import com.verisign.profile.ProfilePrincipal;
import com.verisign.profile.ProfileStamped;
import com.verisign.resource.DOMOperations;
import java.security.Principal;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class ProfileEntitlement
extends ProfileStamped {
    private static final DOMOperations ops = DOMOperations.getInstance();
    URIPrincipal issuer;
    ProfilePrincipal subject;
    Set audiences;
    Set dependencies;
    TimeInterval validityInterval;
    ProfileAzData azData;
    Element signature;

    ProfileEntitlement(Element ent) {
        super(null, null);
        Element elt = ops.firstElementChild(ent);
        while (elt != null) {
            StringTokenizer st;
            if (ops.matchName(elt, "http://ns.s2ml.org/s2ml", "ID")) {
                this.id = ops.stringValueOfNode(elt);
            } else if (ops.matchName(elt, "http://ns.s2ml.org/s2ml", "Date")) {
                this.date = ops.parseISODate(ops.stringValueOfNode(elt));
            } else if (ops.matchName(elt, "http://ns.s2ml.org/s2ml", "Issuer")) {
                this.issuer = new URIPrincipal(ops.stringValueOfNode(elt));
            } else if (ops.matchName(elt, "http://ns.s2ml.org/s2ml", "Audiences")) {
                st = new StringTokenizer(ops.stringValueOfNode(elt));
                this.audiences = new HashSet();
                while (st.hasMoreTokens()) {
                    this.audiences.add(st.nextToken());
                }
                this.audiences = Collections.unmodifiableSet(this.audiences);
            } else if (ops.matchName(elt, "http://ns.s2ml.org/s2ml", "DependsOn")) {
                st = new StringTokenizer(ops.stringValueOfNode(elt));
                this.dependencies = new HashSet();
                while (st.hasMoreTokens()) {
                    this.dependencies.add(st.nextToken());
                }
                this.dependencies = Collections.unmodifiableSet(this.dependencies);
            } else if (ops.matchName(elt, "http://ns.s2ml.org/s2ml", "ValidityInterval")) {
                Date notBefore = null;
                Date notAfter = null;
                Element aelt = ops.firstElementChild(elt);
                while (aelt != null) {
                    if (ops.matchName(aelt, "http://ns.s2ml.org/s2ml", "NotBefore")) {
                        notBefore = ops.parseISODate(ops.stringValueOfNode(aelt));
                    } else if (ops.matchName(aelt, "http://ns.s2ml.org/s2ml", "NotAfter")) {
                        notAfter = ops.parseISODate(ops.stringValueOfNode(aelt));
                    }
                    aelt = ops.nextElementSibling(aelt);
                }
                this.validityInterval = new TimeInterval(notBefore, notAfter);
            } else if (ops.matchName(elt, "http://ns.s2ml.org/s2ml", "AzData")) {
                this.azData = ProfileAzData.newInstance(ops.firstElementChild(elt));
            } else if (ops.matchName(elt, "http://www.w3.org/2000/09/xmldsig#", "Signature")) {
                this.signature = elt;
            }
            elt = ops.nextElementSibling(elt);
        }
    }

    public Principal getIssuer() {
        return this.issuer;
    }

    public Set getAudiences() {
        return this.audiences;
    }

    public TimeInterval getValidityInterval() {
        return this.validityInterval;
    }

    public Set getDependencies() {
        return this.dependencies;
    }

    public ProfileAzData getAzData() {
        return this.azData;
    }
}

