/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.profile;

import com.verisign.resource.DOMOperations;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProfileAttribute {
    private String name;
    private String description;
    private String type;
    private String value;
    private String error;
    private Element valueElement;
    private static final DOMOperations ops = DOMOperations.getInstance();

    ProfileAttribute(String name, String value) {
        this(name, null, null, value, null);
    }

    ProfileAttribute(String name, String description, String type, String value, String error) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        this.description = description;
        this.type = type;
        this.value = value;
        this.error = error;
    }

    ProfileAttribute(String name, String description, String type, Element valueElement, String error) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        this.description = description;
        this.type = type;
        this.valueElement = valueElement;
        this.error = error;
    }

    ProfileAttribute(Element att) {
        Element elt = ops.firstElementChild(att);
        while (elt != null) {
            if (ops.matchName(elt, "http://ems.verisign.com/2001/05/ems-s2ml#", "Name")) {
                this.name = ops.stringValueOfNode(elt);
            } else if (ops.matchName(elt, "http://ems.verisign.com/2001/05/ems-s2ml#", "Description")) {
                this.description = ops.stringValueOfNode(elt);
            } else if (ops.matchName(elt, "http://ems.verisign.com/2001/05/ems-s2ml#", "Type")) {
                this.type = ops.stringValueOfNode(elt);
            } else if (ops.matchName(elt, "http://ems.verisign.com/2001/05/ems-s2ml#", "Value")) {
                this.valueElement = ops.firstElementChild(elt);
                if (this.valueElement == null) {
                    this.value = ops.stringValueOfNode(elt);
                }
            } else if (ops.matchName(elt, "http://ems.verisign.com/2001/05/ems-s2ml#", "Error")) {
                this.error = ops.stringValueOfNode(elt);
            }
            elt = ops.nextElementSibling(elt);
        }
        if (this.name == null) {
            throw new IllegalArgumentException("EMS:Name is not present");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasValueElement() {
        return this.valueElement != null;
    }

    public String getValue() {
        return this.value;
    }

    public Element getValueElement() {
        return this.valueElement;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{Attribute name=");
        sb.append(this.name);
        if (this.description != null) {
            sb.append(" description=");
            sb.append(this.description);
        }
        if (this.type != null) {
            sb.append(" type=");
            sb.append(this.type);
        }
        if (this.value != null) {
            sb.append(" value=");
            sb.append(this.value);
        }
        sb.append("}");
        return sb.toString();
    }

    Element appendXMLEncodedForm(Node parent) {
        Document doc = ops.document(parent);
        String namespace = "http://ems.verisign.com/2001/05/ems-s2ml#";
        Element attr = ops.appendElementByExpandedName(parent, namespace, "ems", "Attribute");
        ops.appendElementByExpandedName(attr, namespace, "ems", "Name").appendChild(doc.createTextNode(this.name));
        if (this.description != null) {
            ops.appendElementByExpandedName(attr, namespace, "ems", "Description").appendChild(doc.createTextNode(this.description));
        }
        if (this.type != null) {
            ops.appendElementByExpandedName(attr, namespace, "ems", "Type").appendChild(doc.createTextNode(this.type));
        }
        if (this.value != null) {
            ops.appendElementByExpandedName(attr, namespace, "ems", "Value").appendChild(doc.createTextNode(this.value));
        }
        return attr;
    }
}

