/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.messaging.tools;

import com.verisign.domutil.DOMWriteCursor;
import com.verisign.messaging.SOAPMessage;
import com.verisign.messaging.ServiceFailureException;
import com.verisign.messaging.SimpleRequest;
import com.verisign.messaging.XmlResponse;
import com.verisign.messaging.XmlTransportNaked;
import com.verisign.resource.ResourceFactory;
import com.verisign.resource.XMLResource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.w3c.dom.Document;

public class SendXML {
    static byte[] rawData;
    static XMLResource xmlres;
    static String contentType;
    static /* synthetic */ Class class$com$verisign$messaging$tools$SendXML;

    public static void main(String[] argv) throws Exception {
        URL url = null;
        String soapAction = null;
        boolean addSoap = false;
        boolean raw = false;
        int i = 0;
        while (i < argv.length) {
            if ("-help".equals(argv[i]) || "-h".equals(argv[i])) {
                SendXML.usage();
            } else if ("-addsoap".equals(argv[i])) {
                addSoap = true;
            } else if ("-raw".equals(argv[i])) {
                raw = true;
            } else if ("-soapaction".equals(argv[i])) {
                if (++i == argv.length) {
                    SendXML.usage();
                }
                soapAction = argv[i];
                addSoap = true;
            } else if ("-type".equals(argv[i])) {
                if (++i == argv.length) {
                    SendXML.usage();
                }
                if ("NULL".equals(contentType = argv[i])) {
                    contentType = null;
                }
                addSoap = true;
            } else if (url == null) {
                url = new URL(argv[i]);
            } else {
                SendXML.usage();
            }
            ++i;
        }
        if (url == null) {
            SendXML.usage();
        }
        Document doc = null;
        if (raw) {
            int c;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((c = System.in.read()) >= 0) {
                baos.write(c);
            }
            rawData = baos.toByteArray();
            DOMWriteCursor c2 = new DOMWriteCursor();
            c2.addUnder(null, null, "NotUsed");
            doc = c2.getDocument();
        } else {
            doc = xmlres.parseXML(System.in, false);
            if (addSoap) {
                SOAPMessage msg = new SOAPMessage(doc);
                doc = msg.getDocument();
            }
        }
        Transport transport = new Transport(url);
        if (soapAction != null) {
            transport.setHTTPRequestHeader("SOAPAction", soapAction);
        }
        try {
            SimpleRequest request = new SimpleRequest(doc);
            XmlResponse response = transport.sendRequest(request);
            xmlres.publish(response.getXML(), (OutputStream)System.out);
        }
        catch (ServiceFailureException e) {
            System.out.println("HTTP error response");
            if (e.getDocument() != null) {
                xmlres.publish(e.getDocument(), (OutputStream)System.out);
            }
            System.out.println(new String(e.getData()));
        }
    }

    public static void usage() {
        System.err.println("usage: " + (class$com$verisign$messaging$tools$SendXML == null ? (class$com$verisign$messaging$tools$SendXML = SendXML.class$("com.verisign.messaging.tools.SendXML")) : class$com$verisign$messaging$tools$SendXML).getName() + " [options] URL < XML_FILE\n" + "   [-addsoap]           # add soap envelope\n" + "   [-soapaction ACTION] # add soap envelope and set action header\n" + "   [-type CONTENT_TYPE  # content-type header, NULL means null\n" + "   [-raw]               # don't parse, just send the file");
        System.exit(2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        xmlres = ResourceFactory.getXMLResource();
        contentType = "application/xml";
    }

    private static class Transport
    extends XmlTransportNaked {
        private Transport(URL url) {
            super(url);
        }

        protected void publishRequest(URLConnection conn, Document request) throws IOException {
            conn.setRequestProperty("Accept", "application/xml, text/xml");
            if (contentType != null) {
                conn.setRequestProperty("Content-Type", contentType);
            }
            if (rawData != null) {
                conn.setRequestProperty("Content-Length", String.valueOf(rawData.length));
                System.err.println("Sending: " + conn.getRequestProperty("Content-Type") + ' ' + rawData.length);
                conn.connect();
                OutputStream out = conn.getOutputStream();
                out.write(rawData);
                out.close();
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                xmlres.publish(request, (OutputStream)baos);
                conn.setRequestProperty("Content-Length", String.valueOf(baos.size()));
                System.err.println("Sending: " + conn.getRequestProperty("Content-Type") + ' ' + String.valueOf(baos.size()));
                conn.connect();
                OutputStream out = conn.getOutputStream();
                baos.writeTo(out);
                out.close();
            }
        }
    }
}

