/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.messaging.tools;

import com.verisign.dime.DIMEGenerator;
import com.verisign.dime.DIMEInputStream;
import com.verisign.dime.DIMEParser;
import com.verisign.dime.DIMERecord;
import com.verisign.dime.DIMERecordFormatType;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.messaging.ServiceFailureException;
import com.verisign.messaging.SimpleRequest;
import com.verisign.messaging.XmlResponse;
import com.verisign.messaging.XmlTransportNaked;
import com.verisign.resource.ResourceFactory;
import com.verisign.resource.XMLResource;
import com.verisign.util.Namespaces;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.w3c.dom.Document;

public class SendDIME {
    static final String SOAP_URI = Namespaces.SOAPENV.getUri();
    static final String DIME_CONTENT = "application/dime";
    static XMLResource xmlres;
    static final int DIME_VERSION = 2048;
    static final int MSG_BEGIN = 1024;
    static final int MSG_END = 512;
    static final int TYPE_MEDIA = 16;
    static final int TYPE_URI = 32;
    static final int PART_FIRST = 3104;
    static final int PART_MIDDLE = 2064;
    static final int PART_LAST = 2576;
    static final int PART_ONLY = 3616;
    static boolean OLD_CODE;
    static XMLResource xml;
    static byte[] dimeData;
    static ArrayList files;
    static ArrayList fileNames;
    static boolean dump;
    static boolean raw;
    static boolean loopback;
    static /* synthetic */ Class class$com$verisign$messaging$tools$SendXML;

    public static void usage() {
        System.err.println("usage: " + (class$com$verisign$messaging$tools$SendXML == null ? (class$com$verisign$messaging$tools$SendXML = SendDIME.class$("com.verisign.messaging.tools.SendXML")) : class$com$verisign$messaging$tools$SendXML).getName() + "\n" + "  URL [-soapaction ACTION] [-raw | ATTACHMENT_FILE...]\n" + "      [-dump] < XML_REQUEST [> XML_RESPONSE]");
        System.exit(2);
    }

    public static void main(String[] argv) throws Exception {
        Document doc;
        URL url = null;
        String soapAction = null;
        int i = 0;
        while (i < argv.length) {
            if ("-help".equals(argv[i]) || "-h".equals(argv[i])) {
                SendDIME.usage();
            } else if ("-raw".equals(argv[i])) {
                raw = true;
            } else if ("-dump".equals(argv[i])) {
                dump = true;
            } else if ("-loopback".equals(argv[i])) {
                loopback = true;
            } else if ("-oldcode".equals(argv[i])) {
                OLD_CODE = true;
            } else if ("-soapaction".equals(argv[i])) {
                if (++i == argv.length) {
                    SendDIME.usage();
                }
                soapAction = argv[i];
            } else if (!loopback && url == null) {
                url = new URL(argv[i]);
            } else if (!raw) {
                FileInputStream in = new FileInputStream(argv[i]);
                byte[] buf = new byte[in.available()];
                in.read(buf);
                files.add(buf);
                fileNames.add(argv[i]);
            } else {
                SendDIME.usage();
            }
            ++i;
        }
        if (!loopback && url == null) {
            SendDIME.usage();
        }
        if (raw) {
            int c;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((c = System.in.read()) >= 0) {
                baos.write(c);
            }
            dimeData = baos.toByteArray();
            DOMWriteCursor c2 = new DOMWriteCursor();
            c2.addUnder(null, null, "NotUsed");
            doc = c2.getDocument();
        } else {
            doc = xmlres.parseXML(System.in, false);
            SendDIME.publishDime(doc);
        }
        if (loopback) {
            System.err.println("Loopback");
            if (dump) {
                SendDIME.dump(true, dimeData);
            }
            files.clear();
            fileNames.clear();
            doc = SendDIME.parseDime();
            if (dump) {
                SendDIME.dump(false, dimeData);
            }
        } else {
            Transport transport = new Transport(url);
            if (soapAction != null) {
                transport.setHTTPRequestHeader("SOAPAction", soapAction);
            }
            try {
                SimpleRequest request = new SimpleRequest(doc);
                XmlResponse response = transport.sendRequest(request);
                doc = response.getXML();
            }
            catch (ServiceFailureException e) {
                System.out.println("HTTP error response");
                if (e.getDocument() != null) {
                    xmlres.publish(e.getDocument(), (OutputStream)System.out);
                } else if (e.getData() != null) {
                    System.out.println(new String(e.getData()));
                } else {
                    System.out.println(e);
                }
                return;
            }
        }
        SendDIME.writeDimeFiles();
        xmlres.publish(doc, (OutputStream)System.out);
    }

    static void publishDime(Document doc) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        xml.publish(doc, (OutputStream)baos);
        byte[] docBytes = baos.toByteArray();
        baos = new ByteArrayOutputStream();
        int fileCount = files.size();
        if (OLD_CODE) {
            DataOutputStream out = new DataOutputStream(baos);
            SendDIME.writeDimePart(out, docBytes, SOAP_URI, null, fileCount == 0 ? 3616 : 3104);
            int i = 0;
            while (i < fileCount) {
                byte[] fileData = (byte[])files.get(i);
                String fileName = (String)fileNames.get(i);
                SendDIME.writeDimePart(out, fileData, "application/binary", fileName, fileCount == i + 1 ? 2576 : 2064);
                ++i;
            }
        } else {
            DIMEGenerator gen = new DIMEGenerator(baos);
            gen.addRecord(new DIMERecord(docBytes, DIMERecordFormatType.URI, SOAP_URI, null, true, fileCount == 0, false));
            int i = 0;
            while (i < fileCount) {
                byte[] fileData = (byte[])files.get(i);
                String fileName = (String)fileNames.get(i);
                gen.addRecord(new DIMERecord(fileData, DIMERecordFormatType.MEDIA, "application/binary", fileName, false, fileCount == i + 1, false));
                ++i;
            }
        }
        dimeData = baos.toByteArray();
    }

    static void writeDimePart(DataOutputStream out, byte[] data, String type, String id, int flags) throws IOException {
        byte[] idBytes = id != null ? id.getBytes() : null;
        byte[] typeBytes = type != null ? type.getBytes() : null;
        out.writeShort(flags);
        out.writeShort(0);
        out.writeShort(idBytes != null ? idBytes.length : 0);
        out.writeShort(typeBytes != null ? typeBytes.length : 0);
        out.writeInt(data != null ? data.length : 0);
        if (idBytes != null) {
            out.write(idBytes);
            SendDIME.writePadding(out, idBytes.length);
        }
        if (typeBytes != null) {
            out.write(typeBytes);
            SendDIME.writePadding(out, typeBytes.length);
        }
        if (data != null) {
            out.write(data);
            SendDIME.writePadding(out, data.length);
        }
    }

    static void writeDimeFiles() throws IOException {
        int i = 0;
        while (i < files.size()) {
            byte[] fileData = (byte[])files.get(i);
            String fileName = (String)fileNames.get(i);
            String tmpFile = "tmp" + i;
            System.err.println("File received id=" + fileName + " size=" + fileData.length + " written to: " + tmpFile);
            FileOutputStream out = new FileOutputStream(tmpFile);
            out.write(fileData);
            out.close();
            ++i;
        }
    }

    static Document parseDime() throws IOException {
        DIMERecord rec;
        if (OLD_CODE) {
            return SendDIME.parseDimeOld();
        }
        Document doc = null;
        ByteArrayInputStream byteInput = new ByteArrayInputStream(dimeData);
        DIMEParser parser = new DIMEParser(byteInput);
        int i = 0;
        while ((rec = parser.nextRecord()) != null) {
            if (i == 0) {
                doc = xml.parseXML(parser.getDIMEInputStream(), false);
            } else {
                int len;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DIMEInputStream in = parser.getDIMEInputStream();
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf, 0, buf.length)) >= 0) {
                    baos.write(buf, 0, len);
                }
                files.add(baos.toByteArray());
                fileNames.add(rec.getId());
            }
            ++i;
        }
        if (doc == null) {
            DOMWriteCursor c = new DOMWriteCursor();
            c.addUnder(null, null, "NoPrimarySOAPDocumentFoundInDIMEMessage");
            doc = c.getDocument();
        }
        return doc;
    }

    static Document parseDimeOld() throws IOException {
        ByteArrayInputStream byteInput = new ByteArrayInputStream(dimeData);
        DataInputStream dataInput = new DataInputStream(byteInput);
        Document doc = null;
        int partOff = 0;
        int i = 0;
        while (dataInput.available() > 0) {
            dataInput.skip(2L);
            int optionsLen = dataInput.readUnsignedShort();
            int idLen = dataInput.readUnsignedShort();
            int typeLen = dataInput.readUnsignedShort();
            int idOff = 12 + optionsLen + SendDIME.padLength(optionsLen);
            String id = new String(dimeData, partOff + idOff, idLen);
            int typeOff = idOff + idLen + SendDIME.padLength(idLen);
            String type = new String(dimeData, partOff + typeOff, typeLen);
            int docOff = typeOff + typeLen + SendDIME.padLength(typeLen);
            int docLen = dataInput.readInt();
            if (i == 0 && (type.equals(SOAP_URI) || type.equals("text/xml") || type.equals("application/xml") || type.equals("application/soap+xml"))) {
                ByteArrayInputStream in = new ByteArrayInputStream(dimeData, partOff + docOff, docLen);
                doc = xml.parseXML(in, false);
            } else {
                byte[] buf = new byte[docLen];
                System.arraycopy(dimeData, partOff + docOff, buf, 0, docLen);
                files.add(buf);
                fileNames.add(id);
            }
            int total = docOff + docLen + SendDIME.padLength(docLen);
            dataInput.skip(total - 12);
            partOff += total;
            ++i;
        }
        if (doc == null) {
            DOMWriteCursor c = new DOMWriteCursor();
            c.addUnder(null, null, "NoPrimarySOAPDocumentFoundInDIMEMessage");
            doc = c.getDocument();
        }
        return doc;
    }

    private static int padLength(int len) {
        return (len &= 3) != 0 ? 4 - len : 0;
    }

    private static void writePadding(DataOutputStream out, int len) throws IOException {
        len = SendDIME.padLength(len);
        int i = 0;
        while (i < len) {
            out.writeByte(0);
            ++i;
        }
    }

    static void dump(boolean request, byte[] data) throws IOException {
        FileOutputStream out = new FileOutputStream("dump." + (request ? "request" : "response"));
        out.write(data);
        out.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DIME_CONTENT = DIME_CONTENT;
        xmlres = ResourceFactory.getXMLResource();
        DIME_VERSION = 2048;
        MSG_BEGIN = 1024;
        MSG_END = 512;
        TYPE_MEDIA = 16;
        TYPE_URI = 32;
        PART_FIRST = 3104;
        PART_MIDDLE = 2064;
        PART_LAST = 2576;
        PART_ONLY = 3616;
        OLD_CODE = false;
        xml = ResourceFactory.getXMLResource();
        files = new ArrayList();
        fileNames = new ArrayList();
    }

    private static class Transport
    extends XmlTransportNaked {
        private Transport(URL url) {
            super(url);
        }

        protected void publishRequest(URLConnection conn, Document request) throws IOException {
            conn.setRequestProperty("Accept", "application/xml, text/xml, application/dime");
            if (dimeData != null) {
                if (dump) {
                    SendDIME.dump(true, dimeData);
                }
                conn.setRequestProperty("Content-Type", SendDIME.DIME_CONTENT);
                conn.setRequestProperty("Content-Length", String.valueOf(dimeData.length));
                System.err.println("Sending: " + conn.getRequestProperty("Content-Type") + ' ' + dimeData.length);
                conn.connect();
                OutputStream out = conn.getOutputStream();
                out.write(dimeData);
                out.close();
            } else {
                conn.setRequestProperty("Content-Type", "text/xml");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                xml.publish(request, (OutputStream)baos);
                conn.setRequestProperty("Content-Length", String.valueOf(baos.size()));
                System.err.println("Sending: " + conn.getRequestProperty("Content-Type") + ' ' + String.valueOf(baos.size()));
                conn.connect();
                OutputStream out = conn.getOutputStream();
                if (dump) {
                    SendDIME.dump(true, baos.toByteArray());
                }
                baos.writeTo(out);
                out.close();
            }
        }

        protected Document parseResponse(URLConnection conn, InputStream in) throws IOException {
            files.clear();
            fileNames.clear();
            dimeData = null;
            String contentType = conn.getHeaderField("Content-Type");
            if (SendDIME.DIME_CONTENT.equals(contentType)) {
                dimeData = new byte[conn.getContentLength()];
                System.err.println("Received DIME: " + dimeData.length);
                int i = 0;
                while (i < dimeData.length) {
                    int len = in.read(dimeData, i, dimeData.length - i);
                    if (len < 0) {
                        throw new EOFException();
                    }
                    i += len;
                }
                if (dump) {
                    SendDIME.dump(false, dimeData);
                }
                return SendDIME.parseDime();
            }
            return xml.parseXML(in, false);
        }
    }
}

