/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.messaging;

import com.verisign.messaging.SOAPFault;
import com.verisign.messaging.SOAPMessage;
import com.verisign.messaging.XmlMessageException;
import com.verisign.messaging.XmlTransportNaked;
import java.io.OutputStream;
import java.net.URL;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlTransportSOAP
extends XmlTransportNaked {
    private List requestHeaders = new ArrayList();
    private SOAPMessage responseMsg;

    public XmlTransportSOAP(URL url) {
        super(url);
    }

    public XmlTransportSOAP(URL url, OutputStream debugOutput) {
        super(url, debugOutput);
    }

    public XmlTransportSOAP(URL url, PrivateKey signingPrivateKey, PublicKey signingPublicKey) {
        super(url, signingPrivateKey, signingPublicKey);
    }

    public XmlTransportSOAP(URL url, PrivateKey signingPrivateKey, X509Certificate signingCert) {
        super(url, signingPrivateKey, signingCert);
    }

    public XmlTransportSOAP(URL url, PrivateKey signingPrivateKey, X509Certificate[] signingCertChain) {
        super(url, signingPrivateKey, signingCertChain);
    }

    public void clearSOAPRequestHeaders() {
        this.requestHeaders.clear();
    }

    public void addSOAPRequestHeader(Element headerBlock) {
        this.requestHeaders.add(headerBlock);
    }

    public Element[] getSOAPRequestHeaders() {
        Element[] headers = new Element[this.requestHeaders.size()];
        return this.requestHeaders.toArray(headers);
    }

    public Element getSOAPResponseHeader(String namespaceURI, String localName) {
        return this.responseMsg != null ? this.responseMsg.getHeader(namespaceURI, localName) : null;
    }

    public Element[] getSOAPResponseHeaders() {
        return this.responseMsg != null ? this.responseMsg.getHeaders() : null;
    }

    public SOAPFault getSOAPResponseFault() {
        return this.responseMsg != null ? this.responseMsg.getFault() : null;
    }

    protected void clearContext() {
        super.clearContext();
        this.responseMsg = null;
    }

    protected Document addRequestEnvelope(Document inputDoc) throws XmlMessageException {
        SOAPMessage msg = new SOAPMessage(inputDoc);
        msg.setHeaders(this.getSOAPRequestHeaders());
        return msg.getDocument();
    }

    protected Document removeResponseEnvelope(Document wrappedOutputDoc) throws XmlMessageException {
        this.responseMsg = new SOAPMessage(wrappedOutputDoc);
        return this.responseMsg.extractBody();
    }
}

