/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.messaging;

import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.messaging.MessageSecurity;
import com.verisign.messaging.MessageValidity;
import com.verisign.messaging.SOAPFault;
import com.verisign.messaging.XmlMessageException;
import com.verisign.util.Namespaces;
import com.verisign.xmlenc.AlgorithmType;
import com.verisign.xmlenc.KeyResolver;
import com.verisign.xmlsig.KeyInfo;
import com.verisign.xmlsig.SigningKey;
import com.verisign.xmlsig.SigningKeyFactory;
import com.verisign.xmlsig.VerifyingKey;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xmltrustcenter.verifier.TrustVerifier;

public class SOAPMessage {
    public static final String VERSION_1_1 = Namespaces.SOAPENV.getUri();
    public static final String VERSION_1_2 = Namespaces.SOAPENV_1_2.getUri();
    private static final String SOAP_PREFIX = Namespaces.SOAPENV.getPrefix();
    private static final String SOAP_ENVELOPE = "Envelope";
    private static final String SOAP_HEADER = "Header";
    private static final String SOAP_BODY = "Body";
    private static final String SOAP_FAULT = "Fault";
    private DOMWriteCursor msg;
    private MessageSecurity security;
    private String soapVersion;

    public static boolean isSOAPMessage(Document doc) {
        return SOAPMessage.getSOAPVersion(new DOMCursor(doc)) != null;
    }

    public static String getSOAPVersion(Document doc) {
        return SOAPMessage.getSOAPVersion(new DOMCursor(doc));
    }

    public static String getSOAPVersion(DOMCursor c) {
        if (!c.isDocumentEmpty() && SOAP_ENVELOPE.equals(c.getLocalName())) {
            String uri = c.getNamespaceURI();
            return SOAPMessage.getSOAPVersion(uri);
        }
        return null;
    }

    public static String getSOAPVersion(String uri) {
        if (VERSION_1_1.equals(uri)) {
            return VERSION_1_1;
        }
        if (VERSION_1_2.equals(uri)) {
            return VERSION_1_2;
        }
        return null;
    }

    public SOAPMessage(Document doc) {
        this(doc, null, null);
    }

    public SOAPMessage(Document doc, String version) {
        this(doc, version, null);
    }

    public SOAPMessage(Document doc, MessageSecurity security) {
        this(doc, null, security);
    }

    public SOAPMessage(Document doc, String version, MessageSecurity security) {
        this.msg = new DOMWriteCursor(doc);
        this.security = security;
        this.soapVersion = SOAPMessage.getSOAPVersion(this.msg);
        if (this.soapVersion == null) {
            if (version == null || VERSION_1_1.equals(version)) {
                this.soapVersion = VERSION_1_1;
            } else if (VERSION_1_2.equals(version)) {
                this.soapVersion = VERSION_1_2;
            } else {
                throw new IllegalArgumentException("Unknown SOAP version [" + version + "], must be [" + VERSION_1_1 + "] or [" + VERSION_1_2 + ']');
            }
            Element payload = this.msg.getElement();
            if (payload != null) {
                this.msg.remove();
            }
            this.msg = this.msg.addUnder(this.soapVersion, SOAP_PREFIX, SOAP_ENVELOPE);
            this.msg = this.msg.addUnder(this.soapVersion, SOAP_PREFIX, SOAP_BODY);
            if (payload != null) {
                this.msg.getElement().appendChild(payload);
            }
        }
    }

    public Document getDocument() {
        return this.msg.getDocument();
    }

    public String getVersion() {
        return this.soapVersion;
    }

    public void setHeaders(Element[] headerBlocks) {
        this.msg.moveToTop();
        if (this.msg.moveToChild(1) && this.msg.atElement(this.soapVersion, SOAP_HEADER)) {
            this.msg.remove();
        }
        if (headerBlocks != null || headerBlocks.length > 0) {
            this.addAndMoveToSoapHeader();
            int i = 0;
            while (i < headerBlocks.length) {
                this.msg.copyUnder(new DOMCursor(headerBlocks[i]));
                ++i;
            }
        }
    }

    public void addHeader(Element headerBlock) {
        DOMCursor c = new DOMCursor(headerBlock);
        this.addAndMoveToSoapHeader();
        if (this.msg.moveToChild(1)) {
            this.msg.copyBefore(c);
        } else {
            this.msg.copyUnder(c);
        }
    }

    public Element[] getHeaders() {
        ArrayList<Element> headers = new ArrayList<Element>();
        this.msg.moveToTop();
        if (this.msg.moveToChild(1) && this.msg.atElement(this.soapVersion, SOAP_HEADER)) {
            boolean more = this.msg.moveToChild(1);
            while (more) {
                headers.add(this.msg.getElement());
                more = this.msg.moveToSibling(1);
            }
        }
        Element[] elems = new Element[headers.size()];
        return headers.toArray(elems);
    }

    public Element getHeader(String namespaceURI, String localName) {
        Element[] headers = this.getHeaders();
        int i = 0;
        while (i < headers.length) {
            DOMCursor c = new DOMCursor(headers[i]);
            if (c.atElement(namespaceURI, localName)) {
                return headers[i];
            }
            ++i;
        }
        return null;
    }

    public void setMustUnderstand(Element header, boolean mustUnderstand) {
        DOMWriteCursor c = new DOMWriteCursor(header);
        c.setAttribute(this.soapVersion, SOAP_PREFIX, "mustUnderstand", mustUnderstand ? this.mustUnderstandTrue() : null);
    }

    public boolean getMustUnderstand(Element header) {
        DOMCursor c = new DOMCursor(header);
        String val = c.getAttribute(this.soapVersion, "mustUnderstand");
        return val != null ? val.equals(this.mustUnderstandTrue()) : false;
    }

    public void setFault(SOAPFault fault) {
        this.moveToBody();
        if (this.msg.moveToChild(this.soapVersion, SOAP_FAULT)) {
            this.msg.remove();
            this.moveToBody();
        }
        if (fault != null) {
            fault.toXML(this.msg);
        }
    }

    public SOAPFault getFault() {
        this.moveToBody();
        if (this.msg.moveToChild(this.soapVersion, SOAP_FAULT)) {
            return new SOAPFault(this.msg.cloneCursor());
        }
        return null;
    }

    public void addBody(Element bodyBlock) {
        this.moveToBody();
        this.msg.copyUnder(new DOMCursor(bodyBlock));
    }

    public Element getBody() {
        this.moveToBody();
        boolean more = this.msg.moveToChild(1);
        while (more) {
            if (!this.msg.atElement(this.soapVersion, SOAP_FAULT)) {
                return this.msg.getElement();
            }
            more = this.msg.moveToSibling(1);
        }
        return null;
    }

    public Document extractBody() {
        Element body = this.getBody();
        if (body == null) {
            return null;
        }
        Document doc = new DOMWriteCursor().getDocument();
        doc.appendChild(doc.importNode(body, true));
        return doc;
    }

    public void sign(PrivateKey signingKey) throws GeneralSecurityException {
        this.sign(SigningKeyFactory.makeSigningKey(signingKey), null);
    }

    public void sign(PrivateKey signingKey, PublicKey verifyingKey) throws GeneralSecurityException {
        KeyInfo keyInfo = new KeyInfo();
        keyInfo.setKeyValue(verifyingKey);
        this.sign(SigningKeyFactory.makeSigningKey(signingKey), keyInfo);
    }

    public void sign(PrivateKey signingKey, X509Certificate verifyingCert) throws GeneralSecurityException {
        KeyInfo keyInfo = new KeyInfo();
        keyInfo.setCertificate(verifyingCert);
        this.sign(SigningKeyFactory.makeSigningKey(signingKey), keyInfo);
    }

    public void sign(PrivateKey signingKey, X509Certificate[] verifyingCerts) throws GeneralSecurityException {
        KeyInfo keyInfo = new KeyInfo();
        keyInfo.setCertificateChain(verifyingCerts);
        this.sign(SigningKeyFactory.makeSigningKey(signingKey), keyInfo);
    }

    public void sign(SigningKey signingKey) throws GeneralSecurityException {
        this.sign(signingKey, null);
    }

    public void sign(SigningKey signingKey, KeyInfo keyInfo) throws GeneralSecurityException {
        if (this.security == null) {
            this.throwNoSecurity();
        }
        this.security.sign(this.msg.getDocument(), signingKey, keyInfo);
    }

    public void encrypt(Key encryptionKey) throws GeneralSecurityException {
        this.encrypt(encryptionKey, null, null, null, null);
    }

    public void encrypt(Key encryptionKey, AlgorithmType encryptionAlgorithm) throws GeneralSecurityException {
        this.encrypt(encryptionKey, encryptionAlgorithm, null, null, null);
    }

    public void encrypt(Key encryptionKey, AlgorithmType encryptionAlgorithm, KeyInfo keyInfo) throws GeneralSecurityException {
        this.encrypt(encryptionKey, encryptionAlgorithm, null, null, keyInfo);
    }

    public void encrypt(Key dataEncryptionKey, AlgorithmType dataEncryptionAlgorithm, Key keyEncryptionKey, AlgorithmType keyEncryptionAlgorithm, KeyInfo keyInfo) throws GeneralSecurityException {
        if (this.security == null) {
            this.throwNoSecurity();
        }
        this.security.encrypt(this.msg.getDocument(), dataEncryptionKey, dataEncryptionAlgorithm, keyEncryptionKey, keyEncryptionAlgorithm, keyInfo);
    }

    public void signAndEncrypt(SigningKey signingKey, KeyInfo signingKeyInfo, Key dataEncryptionKey, AlgorithmType dataEncryptionAlgorithm, KeyInfo encryptingKeyInfo) throws GeneralSecurityException {
        if (this.security == null) {
            this.throwNoSecurity();
        }
        this.security.signAndEncrypt(this.msg.getDocument(), signingKey, signingKeyInfo, dataEncryptionKey, dataEncryptionAlgorithm, null, null, encryptingKeyInfo);
    }

    public void signAndEncrypt(SigningKey signingKey, KeyInfo signingKeyInfo, Key dataEncryptionKey, AlgorithmType dataEncryptionAlgorithm, Key keyEncryptionKey, AlgorithmType keyEncryptionAlgorithm, KeyInfo encryptingKeyInfo) throws GeneralSecurityException {
        if (this.security == null) {
            this.throwNoSecurity();
        }
        this.security.signAndEncrypt(this.msg.getDocument(), signingKey, signingKeyInfo, dataEncryptionKey, dataEncryptionAlgorithm, keyEncryptionKey, keyEncryptionAlgorithm, encryptingKeyInfo);
    }

    public MessageValidity[] verify(TrustVerifier trustVerifier) throws GeneralSecurityException {
        return this.verify(trustVerifier, null);
    }

    public MessageValidity[] verify(TrustVerifier trustVerifier, VerifyingKey verifyingKey) throws GeneralSecurityException {
        if (this.security == null) {
            this.throwNoSecurity();
        }
        return this.security.verify(this.msg.getDocument(), trustVerifier, verifyingKey, null);
    }

    public void decrypt(Key decryptionKey) throws GeneralSecurityException {
        if (this.security == null) {
            this.throwNoSecurity();
        }
        this.security.decrypt(this.msg.getDocument(), decryptionKey, null);
    }

    public void decrypt(KeyResolver keyResolver) throws GeneralSecurityException {
        if (this.security == null) {
            this.throwNoSecurity();
        }
        this.security.decrypt(this.msg.getDocument(), null, keyResolver);
    }

    public MessageValidity[] verifyAndDecrypt(TrustVerifier trustVerifier, VerifyingKey verifyingKey, Key decryptionKey, KeyResolver keyResolver) throws XmlMessageException, GeneralSecurityException {
        if (this.security == null) {
            this.throwNoSecurity();
        }
        return this.security.verifyAndDecrypt(this.msg.getDocument(), trustVerifier, verifyingKey, decryptionKey, keyResolver);
    }

    private void throwNoSecurity() {
        throw new IllegalStateException("No MessageSecurity was specified");
    }

    private void moveToBody() {
        this.msg.moveToTop();
        if (!this.msg.moveToChild(this.soapVersion, SOAP_BODY)) {
            throw new IllegalStateException("No SOAP Body element");
        }
    }

    private void addAndMoveToSoapHeader() {
        this.msg.moveToTop();
        if (this.msg.moveToChild(1)) {
            if (!this.msg.atElement(this.soapVersion, SOAP_HEADER)) {
                this.msg = this.msg.addBefore(this.soapVersion, SOAP_PREFIX, SOAP_HEADER);
            }
        } else {
            this.msg = this.msg.addUnder(this.soapVersion, SOAP_PREFIX, SOAP_HEADER);
        }
    }

    private String mustUnderstandTrue() {
        return this.soapVersion == VERSION_1_1 ? "1" : "true";
    }

    static {
        SOAP_ENVELOPE = SOAP_ENVELOPE;
        SOAP_HEADER = SOAP_HEADER;
        SOAP_BODY = SOAP_BODY;
        SOAP_FAULT = SOAP_FAULT;
    }
}

