/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.messaging;

import com.verisign.datatypes.QName;
import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.messaging.SOAPMessage;
import com.verisign.util.Namespaces;
import org.w3c.dom.Element;

public class SOAPFault {
    public static final QName CLIENT = new QName(Namespaces.SOAPENV.getUri(), Namespaces.SOAPENV.getPrefix(), "Client");
    public static final QName SERVER = new QName(Namespaces.SOAPENV.getUri(), Namespaces.SOAPENV.getPrefix(), "Server");
    public static final QName SENDER = new QName(Namespaces.SOAPENV_1_2.getUri(), Namespaces.SOAPENV_1_2.getPrefix(), "Sender");
    public static final QName RECEIVER = new QName(Namespaces.SOAPENV_1_2.getUri(), Namespaces.SOAPENV_1_2.getPrefix(), "Receiver");
    private QName code;
    private String string;
    private String actor;
    private Element detail;

    public SOAPFault(QName code, String string, String actor, Element detail) {
        DOMCursor c;
        if (detail != null && (c = new DOMCursor(detail)).atElement(SOAPMessage.VERSION_1_1, "detail")) {
            detail = c.moveToChild(1) ? c.getElement() : null;
        }
        this.code = this.normalizeFaultCode(code);
        this.string = string;
        this.actor = actor;
        this.detail = detail;
    }

    SOAPFault(DOMCursor c) {
        if (!"Fault".equals(c.getLocalName())) {
            throw new IllegalArgumentException("Not a SOAP Fault element");
        }
        String NS = c.getNamespaceURI();
        if (SOAPMessage.VERSION_1_1.equals(NS)) {
            if (!c.moveToChild(NS, "faultcode")) {
                throw new IllegalArgumentException("SOAP Fault has no faultcode");
            }
            this.code = this.normalizeFaultCode(c.getQNameInContext(c.getText().trim()));
            c.moveToParent();
            if (c.moveToChild(NS, "faultstring")) {
                this.string = c.getText().trim();
                c.moveToParent();
            }
            if (c.moveToChild(NS, "faultactor")) {
                this.actor = c.getText().trim();
                c.moveToParent();
            }
            if (c.moveToChild(NS, "detail")) {
                if (c.moveToChild(1)) {
                    this.detail = c.getElement();
                    c.moveToParent();
                }
                c.moveToParent();
            }
        } else if (SOAPMessage.VERSION_1_2.equals(NS)) {
            if (c.moveToChild(NS, "Code")) {
                if (c.moveToChild(NS, "Value")) {
                    this.code = this.normalizeFaultCode(c.getQNameInContext(c.getText().trim()));
                    c.moveToParent();
                }
                c.moveToParent();
            }
            if (this.code == null) {
                throw new IllegalArgumentException("SOAP Fault has no Code/Value");
            }
            if (c.moveToChild(NS, "Reason")) {
                if (c.moveToChild(NS, "Text")) {
                    this.string = c.getText().trim();
                    c.moveToParent();
                }
                c.moveToParent();
            }
            if (this.string == null) {
                throw new IllegalArgumentException("SOAP Fault has no Reason/Text");
            }
            if (c.moveToChild(NS, "Role")) {
                this.actor = c.getText().trim();
                c.moveToParent();
            }
            if (c.moveToChild(NS, "Detail")) {
                if (c.moveToChild(1)) {
                    this.detail = c.getElement();
                    c.moveToParent();
                }
                c.moveToParent();
            }
        } else {
            throw new IllegalArgumentException("SOAP Fault has unknown namespace: " + NS);
        }
    }

    private QName normalizeFaultCode(QName code) {
        if (SENDER.equals(code) || CLIENT.equals(code)) {
            return SENDER;
        }
        if (RECEIVER.equals(code) || SERVER.equals(code)) {
            return RECEIVER;
        }
        return code;
    }

    public void toXML(DOMWriteCursor c) {
        this.toXML(c, SOAPMessage.VERSION_1_1);
    }

    public void toXML(DOMWriteCursor c, String version) {
        String PREFIX = Namespaces.SOAPENV.getPrefix();
        String uri = c.getNamespaceURI();
        String NS = SOAPMessage.VERSION_1_1.equals(uri) || SOAPMessage.VERSION_1_2.equals(uri) ? uri : version;
        if (SOAPMessage.VERSION_1_1.equals(NS)) {
            c = c.addUnder(NS, PREFIX, "Fault");
            DOMWriteCursor c2 = c.addUnder(NS, PREFIX, "faultcode");
            QName code11 = this.code == SENDER ? CLIENT : (this.code == RECEIVER ? SERVER : this.code);
            c2.setText(code11.toString());
            c2.setNamespace(code11.getNamespacePrefix(), code11.getNamespaceURI());
            c2 = c.addUnder(NS, PREFIX, "faultstring");
            c2.setText(this.string);
            if (this.actor != null) {
                c2 = c.addUnder(NS, PREFIX, "faultactor");
                c2.setText(this.actor);
            }
            if (this.detail != null) {
                c2 = c.addUnder(NS, PREFIX, "detail");
                DOMCursor c3 = new DOMCursor(this.detail);
                do {
                    c2.copyUnder(c3);
                } while (c3.moveToSibling(1));
            }
        } else if (SOAPMessage.VERSION_1_2.equals(NS)) {
            c = c.addUnder(NS, PREFIX, "Fault");
            DOMWriteCursor c2 = c.addUnder(NS, PREFIX, "Code");
            c2 = c2.addUnder(NS, PREFIX, "Value");
            QName code11 = this.code == CLIENT ? SENDER : (this.code == SERVER ? RECEIVER : this.code);
            c2.setText(code11.toString());
            c2.setNamespace(code11.getNamespacePrefix(), code11.getNamespaceURI());
            c2 = c.addUnder(NS, PREFIX, "Reason");
            c2 = c2.addUnder(NS, PREFIX, "Text");
            c2.setText(this.string);
            c2.setAttribute(Namespaces.XML.getUri(), Namespaces.XML.getPrefix(), "lang", "en");
            if (this.actor != null) {
                c2 = c.addUnder(NS, PREFIX, "Role");
                c2.setText(this.actor);
            }
            if (this.detail != null) {
                c2 = c.addUnder(NS, PREFIX, "Detail");
                DOMCursor c3 = new DOMCursor(this.detail);
                do {
                    c2.copyUnder(c3);
                } while (c3.moveToSibling(1));
            }
        } else {
            throw new IllegalArgumentException("SOAP Fault has unknown namespace: " + NS);
        }
    }

    public QName getFaultCode() {
        return this.code;
    }

    public String getFaultString() {
        return this.string;
    }

    public String getFaultActor() {
        return this.actor;
    }

    public Element getFaultDetail() {
        return this.detail;
    }
}

