/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.messaging;

import com.verisign.domutil.DOMCursor;
import com.verisign.xmlsig.KeyInfo;
import com.verisign.xpath.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class MessageValidity {
    public static final String TRANSPORT = "transport";
    public static final String SIGNATURE = "signature";
    private Document doc;
    private String type;
    private KeyInfo keyInfo;
    private Exception reasonInvalid;
    private Element signatureElement;
    private XPath signatureXPath;
    private Element[] referencedElements;
    private XPath[] referencedXPaths;

    public MessageValidity(String type, KeyInfo keyInfo) {
        this(null, type, keyInfo, null, null, null);
    }

    public MessageValidity(Document doc, String type, KeyInfo keyInfo, Exception reasonInvalid) {
        Element[] elementArray;
        if (doc != null && doc.getDocumentElement() != null) {
            Element[] elementArray2 = new Element[1];
            elementArray = elementArray2;
            elementArray2[0] = doc.getDocumentElement();
        } else {
            elementArray = null;
        }
        this(doc, type, keyInfo, reasonInvalid, null, elementArray);
    }

    public MessageValidity(Document doc, String type, KeyInfo keyInfo, Exception reasonInvalid, Element signatureElement, Element[] referencedElements) {
        if (type != TRANSPORT && type != SIGNATURE) {
            throw new IllegalArgumentException("Unknown type: " + type);
        }
        this.doc = doc;
        this.type = type;
        this.keyInfo = keyInfo;
        this.reasonInvalid = reasonInvalid;
        this.signatureElement = signatureElement;
        this.referencedElements = referencedElements;
        if (signatureElement != null) {
            this.signatureXPath = new DOMCursor(signatureElement).createXPath();
        }
        if (referencedElements != null) {
            this.referencedXPaths = new XPath[referencedElements.length];
            int i = 0;
            while (i < referencedElements.length) {
                this.referencedXPaths[i] = new DOMCursor(referencedElements[i]).createXPath();
                ++i;
            }
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public String getType() {
        return this.type;
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public boolean isValid() {
        return this.reasonInvalid == null;
    }

    public boolean isValid(Element elem) {
        if (!this.isValid() || this.doc == null) {
            return false;
        }
        DOMCursor checkElem = new DOMCursor(elem);
        return this.isSigned(checkElem);
    }

    public boolean isValid(XPath xpath) {
        if (!this.isValid() || this.doc == null) {
            return false;
        }
        DOMCursor checkElem = new DOMCursor(this.doc);
        if (!checkElem.moveToXPath(xpath)) {
            return false;
        }
        return this.isSigned(checkElem);
    }

    private boolean isSigned(DOMCursor checkElem) {
        if (this.referencedElements == null) {
            return false;
        }
        int i = 0;
        while (i < this.referencedElements.length) {
            DOMCursor c = new DOMCursor(this.referencedElements[i]);
            if (c.contains(checkElem)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Exception getReasonInvalid() {
        return this.reasonInvalid;
    }

    public void setInvalid(Exception reasonInvalid) throws IllegalStateException {
        if (this.reasonInvalid != null) {
            throw new IllegalStateException("already invalid: " + this.reasonInvalid);
        }
        this.reasonInvalid = reasonInvalid;
    }

    public Element getSignatureElement() {
        return this.signatureElement;
    }

    public XPath getSignatureXPath() {
        return this.signatureXPath;
    }

    public Element[] getReferencedElements() {
        return this.referencedElements;
    }

    public XPath[] getReferencedXPaths() {
        return this.referencedXPaths;
    }

    static {
        TRANSPORT = TRANSPORT;
        SIGNATURE = SIGNATURE;
    }
}

