/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.messaging;

import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.messaging.MessageSecurity;
import com.verisign.messaging.MessageValidity;
import com.verisign.messaging.SOAPMessage;
import com.verisign.messaging.XmlMessageException;
import com.verisign.resource.DOMOperations;
import com.verisign.util.InternalRuntimeException;
import com.verisign.util.Namespaces;
import com.verisign.xmlenc.AlgorithmType;
import com.verisign.xmlenc.Decryptor;
import com.verisign.xmlenc.Encryptor;
import com.verisign.xmlenc.KeyResolver;
import com.verisign.xmlsig.KeyInfo;
import com.verisign.xmlsig.Signer;
import com.verisign.xmlsig.SigningKey;
import com.verisign.xmlsig.Verifier;
import com.verisign.xmlsig.VerifyingKey;
import com.verisign.xmlsig.VerifyingKeyFactory;
import com.verisign.xpath.XPath;
import com.verisign.xpath.XPathException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xmltrustcenter.verifier.TrustVerificationException;
import org.xmltrustcenter.verifier.TrustVerifier;

public class CustomMessageSecurity
implements MessageSecurity,
Cloneable {
    private static final String XMLSIG_URI = Namespaces.XMLSIG.getUri();
    private static final String XMLENC_URI = Namespaces.XMLENC.getUri();
    private static final String SOAP_ENVELOPE = "Envelope";
    private static final String SOAP_BODY = "Body";
    private static final String[] EMPTY_STRING_ARRAY;
    private String soapActor;
    private long validityMillis;
    private boolean signBeforeEncrypt = true;
    private boolean useExclusiveC14N = true;
    private boolean signInsertBefore;
    private XPath signingLocation;
    private XPath[] verifyingLocations;

    public MessageSecurity cloneMessageSecurity() {
        try {
            return (MessageSecurity)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    public String[] getSupportedNamespaces() {
        return EMPTY_STRING_ARRAY;
    }

    public String getMessageNamespace(Document message) {
        return null;
    }

    public void setPreferredNamespace(String namespace) {
        if (namespace != null) {
            throw new IllegalArgumentException("Namespace not supported: " + namespace);
        }
    }

    public String getPreferredNamespace() {
        return null;
    }

    public void setSOAPActor(String soapActor) {
        this.soapActor = soapActor;
    }

    public String getSOAPActor() {
        return this.soapActor;
    }

    public void setSignBeforeEncrypt(boolean signBeforeEncrypt) {
        if (!signBeforeEncrypt) {
            throw new IllegalArgumentException("only signBeforeEncrypt=true is currently supported");
        }
        this.signBeforeEncrypt = signBeforeEncrypt;
    }

    public boolean getSignBeforeEncrypt() {
        return this.signBeforeEncrypt;
    }

    public long getValidityInterval() {
        return this.validityMillis;
    }

    public void setValidityInterval(long validityMillis) {
        this.validityMillis = validityMillis;
    }

    public XPath getSigningLocation() {
        return this.signingLocation;
    }

    public void setSigningLocation(XPath signingLocation) {
        this.signingLocation = signingLocation;
    }

    public boolean getSigningLocationInsertBefore() {
        return this.signInsertBefore;
    }

    public void setSigningLocationInsertBefore(boolean signInsertBefore) {
        this.signInsertBefore = signInsertBefore;
    }

    public void setUseExclusiveCanonicalization(boolean useExclusiveC14N) {
        this.useExclusiveC14N = useExclusiveC14N;
    }

    public boolean getUseExclusiveCanonicalization() {
        return this.useExclusiveC14N;
    }

    public XPath[] getVerifyingLocations() {
        return this.verifyingLocations;
    }

    public void setVerifyingLocations(XPath[] verifyingLocations) {
        this.verifyingLocations = verifyingLocations;
    }

    public void sign(Document message, SigningKey signingKey, KeyInfo keyInfo) throws GeneralSecurityException, XmlMessageException {
        if (signingKey == null) {
            return;
        }
        DOMWriteCursor c = new DOMWriteCursor(message);
        boolean insertBefore = this.signInsertBefore;
        XPath sigLoc = this.signingLocation;
        if (sigLoc != null) {
            if (!c.moveToXPath(sigLoc)) {
                throw new XmlMessageException("Signing location not found: " + sigLoc);
            }
        } else {
            this.moveToBodyContent(c);
            insertBefore = false;
            sigLoc = c.createXPath();
        }
        String id = null;
        XPath refLoc = null;
        if (SOAPMessage.isSOAPMessage(message)) {
            this.moveToBodyContent(c);
            id = this.getBodyID(c);
            if (id == null) {
                throw new XmlMessageException("An id attribute must appear on the signed element when SOAP enveloping is used: " + c);
            }
        } else {
            id = this.getBodyID(c);
        }
        if (id != null) {
            refLoc = XPath.fromID(id);
        }
        Signer signer = new Signer(c.getDocument(), signingKey, keyInfo);
        if (this.useExclusiveC14N) {
            signer.useExclusiveCanonicalizer(Collections.EMPTY_LIST);
        }
        if (refLoc != null) {
            signer.addReference(refLoc);
        }
        try {
            signer.signInPlace(sigLoc, insertBefore);
        }
        catch (XPathException e) {
            throw new InternalRuntimeException(e);
        }
    }

    public void encrypt(Document message, Key dataEncryptionKey, AlgorithmType dataEncryptionAlgorithm, Key keyEncryptionKey, AlgorithmType keyEncryptionAlgorithm, KeyInfo keyInfo) throws GeneralSecurityException, XmlMessageException {
        if (dataEncryptionKey == null) {
            return;
        }
        DOMWriteCursor c = new DOMWriteCursor(message);
        boolean isSOAP = this.moveToBodyParent(c);
        XPath bodyLoc = c.createXPath();
        if (dataEncryptionAlgorithm == null) {
            dataEncryptionAlgorithm = AlgorithmType.TRIPLEDES;
        }
        if (keyEncryptionAlgorithm == null) {
            keyEncryptionAlgorithm = AlgorithmType.RSA1_5;
        }
        Encryptor encryptor = new Encryptor(c.getDocument(), dataEncryptionKey, dataEncryptionAlgorithm, keyEncryptionKey, keyEncryptionAlgorithm, keyInfo);
        try {
            if (isSOAP) {
                encryptor.setContentEncryption(true);
            }
            encryptor.encryptInPlace(bodyLoc);
        }
        catch (XPathException e) {
            throw new InternalRuntimeException(e);
        }
    }

    public void signAndEncrypt(Document message, SigningKey signingKey, KeyInfo signingKeyInfo, Key dataEncryptionKey, AlgorithmType dataEncryptionAlgorithm, Key keyEncryptionKey, AlgorithmType keyEncryptionAlgorithm, KeyInfo encryptingKeyInfo) throws GeneralSecurityException, XmlMessageException {
        if (this.signBeforeEncrypt) {
            this.sign(message, signingKey, signingKeyInfo);
            this.encrypt(message, dataEncryptionKey, dataEncryptionAlgorithm, keyEncryptionKey, keyEncryptionAlgorithm, encryptingKeyInfo);
        } else {
            this.encrypt(message, dataEncryptionKey, dataEncryptionAlgorithm, keyEncryptionKey, keyEncryptionAlgorithm, encryptingKeyInfo);
            this.sign(message, signingKey, signingKeyInfo);
        }
    }

    public MessageValidity[] verify(Document message, TrustVerifier trustVerifier, VerifyingKey verifyingKey, KeyResolver keyResolver) throws GeneralSecurityException, XmlMessageException {
        return this.doVerifyAndDecrypt(message, trustVerifier, verifyingKey, null, keyResolver, false);
    }

    public void decrypt(Document message, Key decryptionKey, KeyResolver keyResolver) throws GeneralSecurityException, XmlMessageException {
        try {
            this.doVerifyAndDecrypt(message, null, null, decryptionKey, keyResolver, true);
        }
        catch (TrustVerificationException e) {
            throw new InternalRuntimeException(e);
        }
    }

    public MessageValidity[] verifyAndDecrypt(Document message, TrustVerifier trustVerifier, VerifyingKey verifyingKey, Key decryptionKey, KeyResolver keyResolver) throws GeneralSecurityException, XmlMessageException {
        return this.doVerifyAndDecrypt(message, trustVerifier, verifyingKey, decryptionKey, keyResolver, true);
    }

    private MessageValidity[] doVerifyAndDecrypt(Document message, TrustVerifier trustVerifier, VerifyingKey verifyingKey, Key decryptionKey, KeyResolver keyResolver, boolean doDecrypt) throws GeneralSecurityException, XmlMessageException {
        DOMCursor c = new DOMCursor(message);
        this.moveToBodyContent(c);
        if (doDecrypt && c.atElement(XMLENC_URI, "EncryptedData")) {
            XPath xpath = c.createXPath();
            Key dkey = decryptionKey;
            try {
                Key key;
                Decryptor decryptor = new Decryptor(c.getDocument(), null, xpath);
                KeyInfo ki = decryptor.getKeyInfo();
                if (ki != null && keyResolver != null && (key = keyResolver.resolve(ki)) != null) {
                    dkey = key;
                }
                if (dkey == null) {
                    throw this.isInvalid(c, "no decryption key is available");
                }
                decryptor.setDecryptionKey(dkey);
                decryptor.decryptInPlace();
            }
            catch (Exception e) {
                throw this.cannotProcess(xpath, (Throwable)e);
            }
        }
        ArrayList<MessageValidity> validityList = new ArrayList<MessageValidity>();
        DOMCursor[] sigLocations = this.getSigLocations(message);
        int i = 0;
        while (i < sigLocations.length) {
            c = sigLocations[i];
            MessageValidity validity = null;
            try {
                Verifier sigVerifier = this.getVerifier(c);
                KeyInfo ki = this.verifierToKeyInfo(sigVerifier);
                VerifyingKey vkey = verifyingKey;
                if (ki != null) {
                    PublicKey key = ki.getKeyValue();
                    if (key == null && keyResolver != null) {
                        keyResolver.resolve(ki);
                        key = ki.getKeyValue();
                    }
                    if (key != null) {
                        vkey = VerifyingKeyFactory.makeVerifyingKey(key);
                    }
                }
                if (vkey == null) {
                    throw this.isInvalid(c, "no verifying key is available");
                }
                validity = new MessageValidity(message, "signature", ki, null, c.getElement(), sigVerifier.getReferencedElements());
                if (!sigVerifier.verify(vkey)) {
                    validity.setInvalid(new SignatureException("signature value does not verify"));
                } else if (trustVerifier != null && ki != null) {
                    ki.verifyTrust(trustVerifier);
                }
            }
            catch (Exception e) {
                if (validity != null) {
                    validity.setInvalid(e);
                }
                validity = new MessageValidity(message, "signature", null, e, c.getElement(), null);
            }
            validityList.add(validity);
            ++i;
        }
        MessageValidity[] v = new MessageValidity[validityList.size()];
        validityList.toArray(v);
        return v;
    }

    private Verifier getVerifier(DOMCursor c) throws XPathException, GeneralSecurityException {
        String uri;
        DOMCursor cc = c.cloneCursor();
        if (SOAPMessage.isSOAPMessage(cc.getDocument()) && cc.moveToChild(XMLSIG_URI, "SignedInfo") && cc.moveToChild(XMLSIG_URI, "Reference") && !cc.moveToSibling(XMLSIG_URI, "Reference") && ((uri = cc.getAttribute("URI")) == null || uri.length() == 0)) {
            SOAPMessage msg = new SOAPMessage(cc.getDocument());
            DOMCursor root = new DOMCursor(msg.getBody());
            root.moveToParent();
            XPath xpath = c.createXPath(root);
            xpath.setXPath("/" + xpath.getXPath());
            Document doc = msg.extractBody();
            return new Verifier(doc, xpath);
        }
        return new Verifier(c.getDocument(), c.createXPath());
    }

    private DOMCursor[] getSigLocations(Document message) throws XmlMessageException {
        boolean docRelative;
        DOMCursor c = new DOMCursor(message);
        boolean bl = docRelative = !this.moveToBodyParent(c);
        if (this.verifyingLocations != null && this.verifyingLocations.length > 0) {
            DOMCursor[] cursors;
            if (this.verifyingLocations.length == 1) {
                return c.evalToElements(this.verifyingLocations[0], docRelative);
            }
            ArrayList<DOMCursor> list = new ArrayList<DOMCursor>();
            int i = 0;
            while (i < this.verifyingLocations.length) {
                cursors = c.evalToElements(this.verifyingLocations[i], docRelative);
                int j = 0;
                while (j < cursors.length) {
                    list.add(cursors[j]);
                    ++j;
                }
                ++i;
            }
            cursors = new DOMCursor[list.size()];
            return cursors;
        }
        this.moveToBodyContent(c);
        if (c.moveToChild(XMLSIG_URI, "Signature")) {
            while (c.moveToSibling(XMLSIG_URI, "Signature")) {
            }
            return new DOMCursor[]{c};
        }
        return new DOMCursor[0];
    }

    private KeyInfo verifierToKeyInfo(Verifier verifier) throws GeneralSecurityException {
        try {
            KeyInfo keyInfo = new KeyInfo();
            X509Certificate[] chain = verifier.getCertificateChain();
            if (chain != null && chain.length > 0) {
                keyInfo.setCertificateChain(chain);
            } else {
                PublicKey key = verifier.getVerifyingKey();
                if (key != null) {
                    keyInfo.setKeyValue(key);
                } else {
                    return null;
                }
            }
            return keyInfo;
        }
        catch (XPathException e) {
            throw new InternalRuntimeException(e);
        }
    }

    private String getBodyID(DOMWriteCursor c) {
        DOMOperations ops = DOMOperations.getInstance();
        Element e = c.getElement();
        if (e == null) {
            return null;
        }
        NamedNodeMap nm = e.getAttributes();
        int i = 0;
        while (i < nm.getLength()) {
            Attr a = (Attr)nm.item(i);
            String name = ops.getLocalName(a);
            if ("id".equalsIgnoreCase(name)) {
                return a.getNodeValue();
            }
            ++i;
        }
        return null;
    }

    private XmlMessageException notSupported(DOMCursor c) {
        return this.isInvalid(c, "XML security element not supported");
    }

    private XmlMessageException isInvalid(DOMCursor c) {
        return this.isInvalid(c, "XML security element is invalid");
    }

    private XmlMessageException isInvalid(DOMCursor c, String msg) {
        return new XmlMessageException(msg + ' ' + c);
    }

    private XmlMessageException cannotProcess(DOMCursor c, Throwable e) {
        return this.cannotProcess(c.createXPath(), e);
    }

    private XmlMessageException cannotProcess(XPath xpath, Throwable e) {
        return new XmlMessageException("Error processing XML security element, see cause exception " + xpath.getXPath(), e);
    }

    private boolean moveToBodyParent(DOMCursor c) {
        c.moveToTop();
        String URI2 = SOAPMessage.getSOAPVersion(c);
        if (URI2 != null) {
            if (!c.moveToChild(URI2, SOAP_BODY)) {
                throw new IllegalStateException("No SOAP Body element");
            }
            return true;
        }
        return false;
    }

    private void moveToBodyContent(DOMCursor c) throws XmlMessageException {
        if (this.moveToBodyParent(c) && !c.moveToChild(1)) {
            throw new XmlMessageException("Missing body contents");
        }
    }

    static {
        SOAP_ENVELOPE = SOAP_ENVELOPE;
        SOAP_BODY = SOAP_BODY;
        EMPTY_STRING_ARRAY = new String[0];
    }
}

