/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.messaging;

import com.verisign.domutil.DOMCursor;
import com.verisign.messaging.InsecureTransportException;
import com.verisign.messaging.MessageProvider;
import com.verisign.messaging.MessageSecurity;
import com.verisign.messaging.MessageValidity;
import com.verisign.messaging.SOAPMessage;
import com.verisign.messaging.ServiceFailureException;
import com.verisign.messaging.XmlMessageException;
import com.verisign.messaging.XmlRequest;
import com.verisign.messaging.XmlResponse;
import com.verisign.messaging.XmlTransport;
import com.verisign.messaging.XmlTransportSecurity;
import com.verisign.resource.ResourceFactory;
import com.verisign.resource.XMLResource;
import com.verisign.schema.SchemaLoaderException;
import com.verisign.schema.SchemaValidator;
import com.verisign.xmlenc.AlgorithmType;
import com.verisign.xmlsig.KeyInfo;
import com.verisign.xmlsig.Signer;
import com.verisign.xmlsig.SigningKey;
import com.verisign.xmlsig.SigningKeyFactory;
import com.verisign.xmlsig.Verifier;
import com.verisign.xpath.XPath;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.xmltrustcenter.verifier.HttpsTrustAdapter;
import org.xmltrustcenter.verifier.TrustVerificationException;
import org.xmltrustcenter.verifier.TrustVerifier;
import org.xmltrustcenter.verifier.X509TrustVerifier;

public abstract class AbstractTransport
implements XmlTransport,
XmlTransportSecurity {
    static XMLResource xmlres = ResourceFactory.getXMLResource();
    private static int logCounter;
    private static boolean disableHostnameVerification;
    private static final MessageValidity[] EMPTY_VALIDITY;
    private URL url;
    private PrivateKey privKey;
    private PublicKey pubKey;
    private X509Certificate cert;
    private X509Certificate[] certChain;
    private PrintStream log;
    private TrustVerifier verifier;
    private boolean sslClientAuthentication;
    private boolean sslTrustVerification;
    private boolean requestValidation;
    private boolean responseValidation;
    private boolean doLogRawResponse;
    private boolean responseValidityExceptionsAllowed;
    private boolean serviceTiming;
    private long serviceBeginTime;
    private long serviceEndTime;
    private Map httpRequestHeaders;
    private String[] httpResponseHeaders;
    private SchemaValidator cachedValidator;
    private Document[] cachedSchemata;
    private AlgorithmType encryptionAlgorithm;
    private AlgorithmType keyEncryptionAlgorithm;
    private Key encryptingKey;
    private Key keyEncryptingKey;
    private Key decryptingKey;
    private KeyInfo encryptingKeyInfo;
    private MessageSecurity messageSecurity;
    private X509Certificate[] serverTrustPoints;
    private boolean alsoTrustSystemCerts;
    protected HttpsTrustAdapter httpsTrustAdapter;
    protected List responseValidity = new ArrayList();

    protected AbstractTransport(URL url) {
        this.url = url;
        this.httpRequestHeaders = new HashMap();
    }

    protected AbstractTransport(URL url, PrivateKey signingPrivateKey, PublicKey signingPublicKey) {
        this(url);
        this.privKey = signingPrivateKey;
        this.pubKey = signingPublicKey;
    }

    protected AbstractTransport(URL url, PrivateKey signingKey, X509Certificate signingCert) {
        this(url);
        this.privKey = signingKey;
        this.setSigningCertificate(signingCert);
    }

    protected AbstractTransport(URL url, PrivateKey signingKey, X509Certificate[] signingCertChain) {
        this(url);
        this.privKey = signingKey;
        this.setSigningCertificateChain(signingCertChain);
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public PrintStream getLogOutput() {
        return this.log;
    }

    public void setLogOutput(PrintStream logOutput) {
        this.log = logOutput;
    }

    public boolean getLogRawResponse() {
        return this.doLogRawResponse;
    }

    public void setLogRawResponse(boolean enabled) {
        this.doLogRawResponse = enabled;
    }

    public final void enableServiceTiming(boolean enabled) {
        this.serviceTiming = enabled;
    }

    public final long getServiceBeginTime() {
        return this.serviceBeginTime;
    }

    public final long getServiceEndTime() {
        return this.serviceEndTime;
    }

    public MessageSecurity getMessageSecurity() {
        return this.messageSecurity;
    }

    public void setMessageSecurity(MessageSecurity messageSecurity) {
        this.messageSecurity = messageSecurity;
    }

    public Key getEncryptingKey() {
        return this.encryptingKey;
    }

    public AlgorithmType getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptingKey(Key encryptingKey) {
        this.setEncryptingKey(encryptingKey, null);
    }

    public void setEncryptingKey(Key encryptingKey, AlgorithmType encryptionAlgorithm) {
        this.encryptingKey = encryptingKey;
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public Key getKeyEncryptingKey() {
        return this.keyEncryptingKey;
    }

    public AlgorithmType getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public void setKeyEncryptingKey(Key keyEncryptingKey) {
        this.setKeyEncryptingKey(keyEncryptingKey, null);
    }

    public void setKeyEncryptingKey(Key keyEncryptingKey, AlgorithmType keyEncryptionAlgorithm) {
        this.keyEncryptingKey = keyEncryptingKey;
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
    }

    public KeyInfo getEncryptingKeyInfo() {
        return this.encryptingKeyInfo;
    }

    public void setEncryptingKeyInfo(KeyInfo encryptingKeyInfo) {
        this.encryptingKeyInfo = encryptingKeyInfo;
    }

    public Key getDecryptingKey() {
        return this.decryptingKey;
    }

    public void setDecryptingKey(Key decryptingKey) {
        this.decryptingKey = decryptingKey;
    }

    public TrustVerifier getTrustVerifier() {
        return this.verifier;
    }

    public void setTrustVerifier(TrustVerifier verifier) {
        this.verifier = verifier;
        this.httpsTrustAdapter = null;
    }

    public PrivateKey getSigningPrivateKey() {
        return this.privKey;
    }

    public PublicKey getSigningPublicKey() {
        if (this.cert != null) {
            return this.cert.getPublicKey();
        }
        return this.pubKey;
    }

    public X509Certificate getSigningCertificate() {
        return this.cert;
    }

    public X509Certificate[] getSigningCertificateChain() {
        return this.certChain;
    }

    public void setSigningPrivateKey(PrivateKey signingPrivateKey) {
        this.privKey = signingPrivateKey;
        this.httpsTrustAdapter = null;
    }

    public void setSigningPublicKey(PublicKey signingPublicKey) {
        this.pubKey = signingPublicKey;
        this.cert = null;
        this.certChain = null;
        this.httpsTrustAdapter = null;
    }

    public void setSigningCertificate(X509Certificate signingCert) {
        X509Certificate[] x509CertificateArray;
        this.cert = signingCert;
        if (signingCert != null) {
            X509Certificate[] x509CertificateArray2 = new X509Certificate[1];
            x509CertificateArray = x509CertificateArray2;
            x509CertificateArray2[0] = signingCert;
        } else {
            x509CertificateArray = null;
        }
        this.certChain = x509CertificateArray;
        this.pubKey = null;
        this.httpsTrustAdapter = null;
    }

    public void setSigningCertificateChain(X509Certificate[] signingCertChain) {
        if (signingCertChain != null && signingCertChain.length > 0) {
            this.cert = signingCertChain[0];
            this.certChain = signingCertChain;
        } else {
            this.cert = null;
            this.certChain = null;
        }
        this.pubKey = null;
        this.httpsTrustAdapter = null;
    }

    public void setServerTrustPoints(X509Certificate[] serverTrustPoints, boolean alsoTrustSystemCerts) {
        this.serverTrustPoints = serverTrustPoints;
        this.alsoTrustSystemCerts = alsoTrustSystemCerts;
        this.httpsTrustAdapter = null;
    }

    public boolean getSSLTrustVerification() {
        return this.sslTrustVerification;
    }

    public void setSSLTrustVerification(boolean enabled) {
        this.sslTrustVerification = enabled;
    }

    public boolean getSSLClientAuthentication() {
        return this.sslClientAuthentication;
    }

    public void setSSLClientAuthentication(boolean enabled) {
        this.sslClientAuthentication = enabled;
    }

    public boolean getRequestSchemaValidation() {
        return this.requestValidation;
    }

    public void setRequestSchemaValidation(boolean enabled) {
        this.requestValidation = enabled;
    }

    public boolean getResponseSchemaValidation() {
        return this.responseValidation;
    }

    public void setResponseSchemaValidation(boolean enabled) {
        this.responseValidation = enabled;
    }

    public void clearHTTPRequestHeaders() {
        this.httpRequestHeaders.clear();
    }

    public void setHTTPRequestHeader(String name, String value) {
        this.httpRequestHeaders.put(name.toLowerCase(), value);
    }

    public Iterator getHTTPRequestHeaders() {
        return this.httpRequestHeaders.entrySet().iterator();
    }

    public String getHTTPResponseHeader(String name) {
        if (this.httpResponseHeaders != null) {
            int i = 0;
            while (i < this.httpResponseHeaders.length) {
                if (name.equalsIgnoreCase(this.httpResponseHeaders[i])) {
                    return this.httpResponseHeaders[i + 1];
                }
                i += 2;
            }
        }
        return null;
    }

    public String[] getHTTPResponseHeaders() {
        return this.httpResponseHeaders;
    }

    public MessageValidity[] getResponseValidity() {
        MessageValidity[] v = new MessageValidity[this.responseValidity.size()];
        this.responseValidity.toArray(v);
        return v;
    }

    public boolean getResponseValidityExceptionsAllowed() {
        return this.responseValidityExceptionsAllowed;
    }

    public void setResponseValidityExceptionsAllowed(boolean allowed) {
        this.responseValidityExceptionsAllowed = allowed;
    }

    public XmlResponse send(XmlRequest request) throws InsecureTransportException, IOException, Exception {
        return this.sendRequest(request);
    }

    public XmlResponse sendRequest(XmlRequest request) throws InsecureTransportException, IOException, XmlMessageException {
        XPath verifyLoc;
        Document[] schemaDocs;
        boolean clientAuth;
        MessageProvider provider = request.getProvider();
        PrivateKey signKey = this.getSigningPrivateKey();
        PublicKey signPublic = this.getSigningPublicKey();
        X509Certificate[] signCertChain = this.getSigningCertificateChain();
        MessageSecurity security = this.getMessageSecurity();
        this.responseValidity.clear();
        this.clearContext();
        TrustVerifier trustVerifier = this.getTrustVerifier();
        if (trustVerifier == null && (trustVerifier = provider.getDefaultTrustVerifier()) == null) {
            throw new IllegalStateException("TrustVerifier not available");
        }
        boolean bl = clientAuth = this.getSSLClientAuthentication() && signKey != null && signCertChain != null;
        if (clientAuth || this.serverTrustPoints != null) {
            if (this.httpsTrustAdapter == null) {
                try {
                    PrivateKey clientKey = null;
                    X509Certificate[] clientCerts = null;
                    X509TrustVerifier verifier = null;
                    int verifierMode = 0;
                    if (clientAuth) {
                        clientKey = signKey;
                        clientCerts = signCertChain;
                    }
                    if (this.serverTrustPoints != null) {
                        verifier = new X509TrustVerifier(Arrays.asList(this.serverTrustPoints));
                        verifierMode = this.alsoTrustSystemCerts ? 0 : 2;
                    }
                    this.httpsTrustAdapter = new HttpsTrustAdapter((TrustVerifier)verifier, verifierMode, clientKey, clientCerts);
                }
                catch (GeneralSecurityException e) {
                    throw new XmlMessageException(e);
                }
            }
        } else {
            this.httpsTrustAdapter = null;
        }
        provider.checkTransport(this, request);
        Document requestDoc = request.getXML();
        if (security == null) {
            XPath signLoc = provider.getRequestSignatureLocation(requestDoc);
            if (signKey != null && signLoc != null && !this.getSSLClientAuthentication()) {
                requestDoc = this.signRequestBody(requestDoc, signKey, signPublic, signCertChain, signLoc, provider.getRequestSignatureInsertBefore(requestDoc));
            }
        }
        if ((schemaDocs = provider.getSchemaDocuments()) != null && this.getRequestSchemaValidation()) {
            this.schemaValidateRequest(requestDoc, schemaDocs);
        }
        requestDoc = this.addRequestEnvelope(requestDoc);
        if (security != null) {
            requestDoc = this.signAndEncryptRequest(requestDoc, security);
        } else {
            Key encKey = this.getEncryptingKey();
            AlgorithmType encAlg = this.getEncryptionAlgorithm();
            if (encKey != null) {
                Key keyEncKey = this.getKeyEncryptingKey();
                KeyInfo keyInfo = this.getEncryptingKeyInfo();
                if (keyEncKey != null || keyInfo != null) {
                    AlgorithmType keyEncAlg = this.getKeyEncryptionAlgorithm();
                    requestDoc = this.encryptRequestBody(requestDoc, encKey, encAlg, keyEncKey, keyEncAlg, keyInfo);
                } else {
                    requestDoc = this.encryptRequestBody(requestDoc, encKey, encAlg);
                }
            }
            if (signKey != null && !this.getSSLClientAuthentication()) {
                requestDoc = this.signRequestEnvelope(requestDoc, signKey, signPublic, signCertChain);
            }
        }
        PrintStream log = this.getLogOutput();
        if (log != null && !this.getLogRawResponse()) {
            this.logRequest(requestDoc, log);
        }
        Document responseDoc = this.call(requestDoc);
        if (log != null) {
            this.logResponse(responseDoc, log);
        }
        if (security != null) {
            responseDoc = this.verifyAndDecryptResponse(responseDoc, security, trustVerifier);
        } else {
            this.verifyResponseEnvelope(responseDoc, trustVerifier);
            Key decKey = this.getDecryptingKey();
            if (decKey != null) {
                responseDoc = this.decryptResponseBody(responseDoc, decKey);
            }
        }
        responseDoc = this.removeResponseEnvelope(responseDoc);
        if (schemaDocs != null && this.getResponseSchemaValidation()) {
            this.schemaValidateResponse(responseDoc, schemaDocs);
        }
        if (security == null && (verifyLoc = provider.getResponseSignatureLocation(responseDoc)) != null) {
            this.verifyResponseBody(responseDoc, trustVerifier, verifyLoc);
        }
        return request.makeResponse(responseDoc);
    }

    protected void clearContext() {
        this.httpResponseHeaders = null;
    }

    protected Document signRequestBody(Document request, PrivateKey signingPrivateKey, PublicKey signingPublicKey, X509Certificate[] signingCerts, XPath signatureLocation, boolean insertBefore) throws XmlMessageException {
        try {
            Signer signer = signingCerts != null ? new Signer(request, signingPrivateKey, signingCerts) : (signingPublicKey != null ? new Signer(request, signingPrivateKey, signingPublicKey) : new Signer(request, signingPrivateKey));
            return signer.sign(signatureLocation, insertBefore);
        }
        catch (Exception e) {
            throw new XmlMessageException();
        }
    }

    protected void verifyResponseBody(Document response, TrustVerifier trustVerifier, XPath signatureLocation) throws XmlMessageException {
        try {
            DOMCursor c = new DOMCursor(response);
            if (!c.moveToXPath(signatureLocation)) {
                if (!this.getSSLTrustVerification() && !this.getResponseValidityExceptionsAllowed()) {
                    trustVerifier.verifyTrust();
                }
                return;
            }
            Verifier sigVerifier = new Verifier(response, signatureLocation);
            PublicKey key = sigVerifier.getVerifyingKey();
            X509Certificate[] chain = sigVerifier.getCertificateChain();
            KeyInfo keyInfo = new KeyInfo();
            if (chain != null && chain.length > 0) {
                keyInfo.setCertificateChain(chain);
            } else if (key != null) {
                keyInfo.setKeyValue(key);
            }
            MessageValidity validity = new MessageValidity(response, "signature", keyInfo, null, c.getElement(), sigVerifier.getReferencedElements());
            this.responseValidity.add(validity);
            if (key == null) {
                SignatureException e = new SignatureException("missing public key in signature");
                validity.setInvalid(e);
                if (this.getResponseValidityExceptionsAllowed()) {
                    return;
                }
                throw e;
            }
            if (!sigVerifier.verify(key)) {
                SignatureException e = new SignatureException("signature value does not verify");
                validity.setInvalid(e);
                if (this.getResponseValidityExceptionsAllowed()) {
                    return;
                }
                throw e;
            }
            try {
                keyInfo.verifyTrust(trustVerifier);
            }
            catch (TrustVerificationException e) {
                validity.setInvalid(e);
                if (this.getResponseValidityExceptionsAllowed()) {
                    return;
                }
                throw e;
            }
        }
        catch (Exception e) {
            throw new XmlMessageException(e, response);
        }
    }

    protected void schemaValidateRequest(Document request, Document[] schemaDocs) throws XmlMessageException {
        this.schemaValidate(request, schemaDocs);
    }

    protected void schemaValidateResponse(Document response, Document[] schemaDocs) throws XmlMessageException {
        this.schemaValidate(response, schemaDocs);
    }

    private void schemaValidate(Document instance, Document[] schemata) throws XmlMessageException {
        try {
            String err;
            if (this.cachedSchemata != schemata) {
                this.cachedValidator = new SchemaValidator(schemata);
                this.cachedSchemata = schemata;
            }
            if ((err = this.cachedValidator.validate(instance)) != null) {
                throw new XmlMessageException(err);
            }
        }
        catch (SchemaLoaderException e) {
            throw new XmlMessageException(e.toString());
        }
    }

    protected Document addRequestEnvelope(Document request) throws XmlMessageException {
        return request;
    }

    protected Document removeResponseEnvelope(Document response) throws XmlMessageException {
        return response;
    }

    protected Document signRequestEnvelope(Document request, PrivateKey signingPrivateKey, PublicKey signingPublicKey, X509Certificate[] signingCerts) throws XmlMessageException {
        return request;
    }

    protected void verifyResponseEnvelope(Document response, TrustVerifier verifier) throws XmlMessageException {
    }

    protected Document encryptRequestBody(Document request, Key encryptingKey, AlgorithmType encryptionAlgorithm) throws XmlMessageException {
        return request;
    }

    protected Document encryptRequestBody(Document request, Key encryptingKey, AlgorithmType encryptionAlgorithm, Key keyEncryptingKey, AlgorithmType keyEncryptionAlgorithm, KeyInfo keyInfo) throws XmlMessageException {
        return request;
    }

    protected Document decryptResponseBody(Document response, Key decryptingKey) throws XmlMessageException {
        return response;
    }

    private Document signAndEncryptRequest(Document request, MessageSecurity security) throws XmlMessageException {
        PrivateKey signPrivKey = this.getSigningPrivateKey();
        Key encKey = this.getEncryptingKey();
        if (signPrivKey == null && encKey == null) {
            return request;
        }
        try {
            SigningKey signingKey = null;
            KeyInfo signingKeyInfo = null;
            if (signPrivKey != null) {
                signingKey = SigningKeyFactory.makeSigningKey(signPrivKey);
                signingKeyInfo = new KeyInfo();
                X509Certificate[] signCertChain = this.getSigningCertificateChain();
                if (signCertChain != null) {
                    signingKeyInfo.setCertificateChain(signCertChain);
                } else {
                    PublicKey signPublic = this.getSigningPublicKey();
                    if (signPublic != null) {
                        signingKeyInfo.setKeyValue(signPublic);
                    }
                }
            }
            AlgorithmType encAlg = null;
            KeyInfo encKeyInfo = null;
            Key keyEncKey = null;
            AlgorithmType keyEncAlg = null;
            if (encKey != null) {
                encAlg = this.getEncryptionAlgorithm();
                encKeyInfo = this.getEncryptingKeyInfo();
                keyEncKey = this.getKeyEncryptingKey();
                keyEncAlg = this.getKeyEncryptionAlgorithm();
            }
            SOAPMessage msg = new SOAPMessage(request, security);
            msg.signAndEncrypt(signingKey, signingKeyInfo, encKey, encAlg, keyEncKey, keyEncAlg, encKeyInfo);
            return msg.getDocument();
        }
        catch (GeneralSecurityException e) {
            throw new XmlMessageException("Could not sign/encrypt request body", e, request);
        }
    }

    private Document verifyAndDecryptResponse(Document response, MessageSecurity security, TrustVerifier trustVerifier) throws XmlMessageException {
        Key decKey = this.getDecryptingKey();
        if (trustVerifier == null && decKey == null) {
            return response;
        }
        try {
            SOAPMessage msg = new SOAPMessage(response, security);
            msg.verifyAndDecrypt(trustVerifier, null, decKey, null);
            return msg.getDocument();
        }
        catch (GeneralSecurityException e) {
            throw new XmlMessageException("Could not verify/decrypt response body", e, response);
        }
    }

    protected void logRequest(Document request, PrintStream log) {
        try {
            log.println("Request message #" + ++logCounter);
            log.println("------------------------------------------------");
            xmlres.publish(request, (OutputStream)log, 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void logResponse(Document response, PrintStream log) {
        try {
            log.println("Reply message #" + logCounter);
            log.println("------------------------------------------------");
            xmlres.publish(response, (OutputStream)log, 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Document call(Document request) throws IOException {
        X509Certificate[] certs;
        HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
        if ("https".equals(this.url.getProtocol())) {
            if (disableHostnameVerification) {
                HttpsTrustAdapter.disableHostnameVerification(conn);
            }
            if (this.httpsTrustAdapter != null) {
                try {
                    this.httpsTrustAdapter.bindToConnection(conn);
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e.toString());
                }
            }
        }
        conn.setRequestMethod("POST");
        conn.setDoInput(true);
        conn.setDoOutput(true);
        Iterator i = this.getHTTPRequestHeaders();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
        }
        this.beforeConnect(conn);
        this.publishRequest(conn, request);
        if (this.serviceTiming) {
            this.serviceBeginTime = System.currentTimeMillis();
        }
        IOException ioException = null;
        InputStream in = null;
        try {
            in = conn.getInputStream();
        }
        catch (IOException e) {
            ioException = e;
            in = conn.getErrorStream();
        }
        if (this.serviceTiming) {
            this.serviceEndTime = System.currentTimeMillis();
        }
        byte[] data = null;
        if (ioException != null || this.getLogRawResponse()) {
            if (in != null) {
                data = this.readInputBytes(in, conn.getContentLength());
                if (this.getLogRawResponse()) {
                    this.logRawResponse(data);
                }
            }
            if (ioException != null) {
                Document doc = null;
                if (data != null) {
                    try {
                        doc = xmlres.parseXML(new ByteArrayInputStream(data), false);
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                throw new ServiceFailureException(ioException, doc, data, conn);
            }
            in = new ByteArrayInputStream(data);
        }
        try {
            certs = HttpsTrustAdapter.getServerCertificates(conn);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
        Document response = null;
        try {
            response = this.parseResponse(conn, in);
        }
        catch (IOException e) {
            throw new ServiceFailureException(e, null, data, conn);
        }
        int headerCount = 0;
        while (conn.getHeaderFieldKey(headerCount + 1) != null) {
            ++headerCount;
        }
        this.httpResponseHeaders = new String[headerCount * 2];
        int i2 = 0;
        while (i2 < headerCount) {
            this.httpResponseHeaders[i2 * 2] = conn.getHeaderFieldKey(i2 + 1);
            this.httpResponseHeaders[i2 * 2 + 1] = conn.getHeaderField(i2 + 1);
            ++i2;
        }
        this.afterConnect(conn);
        if (certs != null) {
            KeyInfo keyInfo = new KeyInfo();
            keyInfo.setCertificateChain(certs);
            MessageValidity validity = new MessageValidity(response, "transport", keyInfo, null);
            this.responseValidity.add(validity);
            TrustVerifier trustVerifier = this.getTrustVerifier();
            if (trustVerifier != null && this.getSSLTrustVerification()) {
                try {
                    keyInfo.verifyTrust(trustVerifier);
                }
                catch (TrustVerificationException e) {
                    validity.setInvalid(e);
                    if (this.getResponseValidityExceptionsAllowed()) {
                        return response;
                    }
                    throw new IOException(e.toString());
                }
            }
        }
        return response;
    }

    protected void publishRequest(URLConnection conn, Document request) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        xmlres.publish(request, (OutputStream)baos);
        conn.setRequestProperty("Content-Length", String.valueOf(baos.size()));
        conn.setRequestProperty("Content-Type", "text/xml");
        conn.setRequestProperty("Accept", "application/xml, text/xml");
        conn.connect();
        OutputStream out = conn.getOutputStream();
        baos.writeTo(out);
        out.close();
    }

    protected Document parseResponse(URLConnection conn, InputStream in) throws IOException {
        return xmlres.parseXML(in, false);
    }

    private byte[] readInputBytes(InputStream in, int totalLen) throws IOException {
        byte[] data;
        if (totalLen >= 0) {
            data = new byte[totalLen];
            int offset = 0;
            while (offset < totalLen) {
                int len = in.read(data, offset, totalLen - offset);
                offset += len;
            }
        } else {
            int c;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((c = in.read()) >= 0) {
                out.write(c);
            }
            data = out.toByteArray();
        }
        return data;
    }

    protected void logRawResponse(byte[] data) throws IOException {
        PrintStream log = this.getLogOutput();
        log.println("Raw response message #" + logCounter);
        log.println("------------------------------------------------");
        log.println(new String(data));
    }

    protected void beforeConnect(URLConnection connection) throws IOException {
    }

    protected void afterConnect(URLConnection connection) throws IOException {
    }

    public boolean isTransportPrivate() {
        return this.getUrl() != null && "https".equals(this.getUrl().getProtocol()) || this.getEncryptingKey() != null && this.getEncryptionAlgorithm() != null && this.getDecryptingKey() != null;
    }

    static {
        try {
            disableHostnameVerification = "false".equals(System.getProperty("com.verisign.messaging.hostnameVerification"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        EMPTY_VALIDITY = new MessageValidity[0];
    }
}

