/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.domutil;

import com.verisign.domutil.DOMCursor;
import com.verisign.xpath.XPath;
import java.util.Collections;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMWriteCursor
extends DOMCursor {
    public DOMWriteCursor() {
        this(DOMCursor.xml.createDocument());
    }

    public DOMWriteCursor(Document document) {
        super(document);
    }

    public DOMWriteCursor(Element element) {
        super(element);
    }

    public DOMWriteCursor(Node node) throws IllegalArgumentException {
        super(node);
    }

    private DOMWriteCursor(DOMWriteCursor other, Element element) {
        super(other, element);
    }

    public DOMWriteCursor cloneWriteCursor() {
        return new DOMWriteCursor(this, this.element);
    }

    public final void setAttribute(String localName, String value) throws IllegalStateException {
        if (this.element == null) {
            this.throwDocEmpty();
        }
        if (value != null) {
            this.ops.setAttributeNS(this.element, null, localName, value);
        } else {
            this.ops.removeAttributeNS(this.element, null, localName);
        }
    }

    public final void setAttribute(String namespaceURI, String desiredPrefix, String localName, String value) throws IllegalStateException {
        if (namespaceURI == null != (desiredPrefix == null)) {
            throw new NullPointerException("namespaceURI and desiredPrefix must both be null or non-null");
        }
        if (this.element == null) {
            this.throwDocEmpty();
        }
        if (value != null) {
            this.ops.setAttributeByExpandedName(this.element, namespaceURI, desiredPrefix, localName, value);
        } else {
            this.ops.removeAttributeNS(this.element, namespaceURI, localName);
        }
    }

    public final void setXPathAttribute(String localName, XPath xpath) throws IllegalStateException {
        this.setXPathAttribute(null, null, localName, xpath);
    }

    public final void setXPathAttribute(String namespaceURI, String desiredPrefix, String localName, XPath xpath) throws IllegalStateException {
        if (this.element == null) {
            this.throwDocEmpty();
        }
        String val = null;
        if (xpath != null) {
            this.setNamespaces(xpath.getNamespaceMap());
            val = xpath.getXPath();
            if (val == null) {
                val = "";
            }
        }
        this.setAttribute(namespaceURI, desiredPrefix, localName, val);
    }

    public final void setText(String text) throws IllegalStateException {
        if (this.element == null) {
            this.throwDocEmpty();
        }
        this.ops.removeAllChildren(this.element);
        if (text != null && text.length() > 0) {
            this.element.appendChild(this.document.createTextNode(text));
        }
    }

    public final void setXPathText(XPath xpath) throws IllegalStateException {
        if (this.element == null) {
            this.throwDocEmpty();
        }
        String val = null;
        if (xpath != null) {
            this.setNamespaces(xpath.getNamespaceMap());
            val = xpath.getXPath();
        }
        this.setText(val);
    }

    public void setNamespace(String prefix, String URI2) {
        this.setNamespaces(Collections.singletonMap(prefix, URI2));
    }

    public void setNamespaces(Map namespaces) {
        if (this.element == null) {
            this.throwDocEmpty();
        }
        this.ops.transferNamespaces(this.element, namespaces);
    }

    public final DOMWriteCursor addUnder(String namespaceURI, String desiredPrefix, String localName) {
        Node parent = this.element;
        if (parent == null) {
            parent = this.document;
        }
        Element e = this.ops.appendElementByExpandedName(parent, namespaceURI, desiredPrefix, localName);
        if (this.element == null) {
            this.element = e;
        }
        return new DOMWriteCursor(this, e);
    }

    public final DOMWriteCursor addBefore(String namespaceURI, String desiredPrefix, String localName) throws IllegalStateException {
        if (this.element == null) {
            this.throwDocEmpty();
        }
        if (this.element == this.document.getDocumentElement()) {
            throw new IllegalStateException("cannot add before top element");
        }
        Node parent = this.element.getParentNode();
        Element e = this.ops.appendElementByExpandedName(parent, namespaceURI, desiredPrefix, localName);
        parent.removeChild(e);
        parent.insertBefore(e, this.element);
        return new DOMWriteCursor(this, e);
    }

    public final DOMWriteCursor copyUnder(DOMCursor copyFrom) {
        Node parent;
        if (copyFrom.element == null) {
            this.throwDocEmpty();
        }
        if ((parent = this.element) == null) {
            parent = this.document;
        }
        Element e = this.ops.graft(parent, copyFrom.element);
        if (this.element == null) {
            this.element = e;
        }
        return new DOMWriteCursor(this, e);
    }

    public final DOMWriteCursor copyBefore(DOMCursor copyFrom) throws IllegalStateException {
        if (this.element == null || copyFrom.element == null) {
            this.throwDocEmpty();
        }
        if (this.element == this.document.getDocumentElement()) {
            throw new IllegalStateException("cannot add before top element");
        }
        Node parent = this.element.getParentNode();
        Element e = this.ops.graft(parent, copyFrom.element);
        parent.removeChild(e);
        parent.insertBefore(e, this.element);
        return new DOMWriteCursor(this, e);
    }

    public final void copyOver(DOMCursor copyFrom) throws IllegalStateException {
        if (this.element == null || copyFrom.element == null) {
            this.throwDocEmpty();
        }
        if (this.element == this.document.getDocumentElement()) {
            this.remove();
            this.copyUnder(copyFrom);
        } else {
            DOMWriteCursor wc = this.copyBefore(copyFrom);
            this.remove();
            this.element = wc.element;
        }
    }

    public final void moveUnder(DOMCursor moveFrom) throws IllegalStateException, IllegalArgumentException {
        Element e;
        if (this.document != moveFrom.document) {
            throw new IllegalArgumentException("cannot move between documents--use copy instead");
        }
        if (this.element == null) {
            this.throwDocEmpty();
        }
        if ((e = moveFrom.element) == this.document.getDocumentElement()) {
            throw new IllegalArgumentException("cannot move the top element");
        }
        this.ops.transplant(this.element, e);
    }

    public final void moveBefore(DOMCursor moveFrom) throws IllegalStateException, IllegalArgumentException {
        Element docElem;
        if (this.document != moveFrom.document) {
            throw new IllegalArgumentException("cannot move between documents--use copy instead");
        }
        if (this.element == null) {
            this.throwDocEmpty();
        }
        if (this.element == (docElem = this.document.getDocumentElement())) {
            throw new IllegalStateException("cannot add before top element");
        }
        Element e = moveFrom.element;
        if (e == docElem) {
            throw new IllegalArgumentException("cannot move the top element");
        }
        Node parent = this.element.getParentNode();
        this.ops.transplant(parent, e);
        parent.removeChild(e);
        parent.insertBefore(e, this.element);
    }

    public final void remove() throws IllegalStateException {
        if (this.element == null) {
            this.throwDocEmpty();
        }
        Node parent = this.element.getParentNode();
        Element newElem = null;
        if (parent.getNodeType() == 1 && (newElem = this.ops.nextElementSibling(this.element)) == null && (newElem = this.ops.previousElementSibling(this.element)) == null) {
            newElem = (Element)parent;
        }
        parent.removeChild(this.element);
        this.element = newElem;
    }

    public final void clear() throws IllegalStateException {
        if (this.element == null) {
            this.throwDocEmpty();
        }
        this.ops.removeAllChildren(this.element);
    }
}

