/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.dime;

public final class DIMERecordFormatType {
    public static final byte UNCHANGED_VALUE = 0;
    public static final DIMERecordFormatType UNCHANGED;
    public static final byte MEDIA_VALUE = 1;
    public static final DIMERecordFormatType MEDIA;
    public static final byte URI_VALUE = 2;
    public static final DIMERecordFormatType URI;
    public static final byte UNKNOWN_VALUE = 3;
    public static final DIMERecordFormatType UNKNOWN;
    public static final byte NONE_VALUE = 4;
    public static final DIMERecordFormatType NONE;
    public static final byte RESERVED_VALUE = 5;
    public static final DIMERecordFormatType RESERVED;
    private static String[] _types;
    private byte _val;

    protected DIMERecordFormatType(byte val) {
        if (val < 0 || val > 5) {
            throw new RuntimeException(val + " : Illegal type. Not supported in DIME Version 1.0");
        }
        this._val = val;
    }

    public final byte getTypeValue() {
        return this._val;
    }

    public final String getType() {
        return _types[this._val];
    }

    public final boolean equals(DIMERecordFormatType t) {
        return this._val == t.getTypeValue();
    }

    static {
        UNCHANGED_VALUE = 0;
        UNCHANGED = new DIMERecordFormatType(0);
        MEDIA_VALUE = 1;
        MEDIA = new DIMERecordFormatType(1);
        URI_VALUE = (byte)2;
        URI = new DIMERecordFormatType(2);
        UNKNOWN_VALUE = (byte)3;
        UNKNOWN = new DIMERecordFormatType(3);
        NONE_VALUE = (byte)4;
        NONE = new DIMERecordFormatType(4);
        RESERVED_VALUE = (byte)5;
        RESERVED = new DIMERecordFormatType(5);
        _types = new String[]{"UNCHANGED", "MEDIA", "URI", "UNKNOWN", "NONE", "RESERVED"};
    }
}

