/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.dime;

import com.verisign.dime.DIMEGenerator;
import com.verisign.dime.DIMERecordFormatType;

public class DIMERecord {
    public static final short VERSION = 1;
    public static final int MAX_DATA_LEN = Integer.MAX_VALUE;
    public static final int MAX_TYPE_ID_LEN = 65535;
    private int _payloadLength;
    private byte[] _payload;
    private String _id;
    private String _type;
    private DIMERecordFormatType _drft;
    private boolean _messageBegin;
    private boolean _messageEnd;
    private boolean _messageChunked;

    public DIMERecord(byte[] payload, DIMERecordFormatType drft, String type, String id) {
        this(payload, drft, type, id, true, true, false);
    }

    public DIMERecord(byte[] payload, DIMERecordFormatType drft, String type, String id, boolean begin, boolean end, boolean chunked) {
        this._payload = payload;
        this._drft = drft;
        this._type = type;
        this._id = id;
        this._messageBegin = begin;
        this._messageEnd = end;
        this._messageChunked = chunked;
        int n = this._payloadLength = payload != null ? payload.length : 0;
        if (this._messageBegin && drft.getTypeValue() == 0) {
            throw new IllegalArgumentException("First DIMERecord cannot be of type 'UNCHANED'");
        }
        if (drft.getTypeValue() == 5) {
            throw new IllegalArgumentException("DIMERecord of format type 'RESERVED' not supported in this version!");
        }
        if (this._messageBegin && this._messageChunked && this._messageEnd) {
            throw new IllegalArgumentException("The First record of DimeMessage cannot be Chunked as well as its Last Record!");
        }
    }

    protected byte[] getPayload() {
        return this._payload;
    }

    protected void setPayloadLength(int pl) {
        this._payloadLength = pl;
    }

    public int getPayloadLength() {
        if (this._messageChunked) {
            return -1;
        }
        return this._payloadLength;
    }

    public String getId() {
        return this._id;
    }

    public String getType() {
        return this._type;
    }

    public DIMERecordFormatType getFormatType() {
        return this._drft;
    }

    public boolean isChunked() {
        return this._messageChunked;
    }

    public boolean isFirst() {
        return this._messageBegin;
    }

    public boolean isEnd() {
        return this._messageEnd;
    }

    protected void _debug() {
        System.out.println();
        System.out.println(this.getClass().getName() + ":_debug():DIME Record Header - Begin");
        System.out.println("VERSION\t\t: 1");
        System.out.println("MB\t\t\t: " + this.isFirst());
        System.out.println("ME\t\t\t: " + this.isEnd());
        System.out.println("CF\t\t\t: " + this.isChunked());
        System.out.println("FormatType\t: " + this._drft.getTypeValue());
        System.out.println("ID\t\t\t: " + this.getId());
        System.out.println("TYPE\t\t: " + this.getType());
        System.out.println("DATA LENGTH:" + this._payloadLength);
        System.out.println(this.getClass().getName() + ":_debug():DIME Record Header - End");
        System.out.println();
    }

    public static int calcLength(int payloadLen, String type, String id) {
        int len = 12;
        if (id != null) {
            len += id.length() + DIMEGenerator.toPad(id.length());
        }
        if (type != null) {
            len += type.length() + DIMEGenerator.toPad(type.length());
        }
        if (payloadLen > 0) {
            len += payloadLen + DIMEGenerator.toPad(payloadLen);
        }
        return len;
    }

    public static int calcPadding(int payloadLen) {
        return DIMEGenerator.toPad(payloadLen);
    }

    static {
        VERSION = 1;
        MAX_DATA_LEN = Integer.MAX_VALUE;
        MAX_TYPE_ID_LEN = 65535;
    }
}

