/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.dime;

import com.verisign.dime.DIMEGenerator;
import com.verisign.dime.DIMEInputStream;
import com.verisign.dime.DIMERecord;
import com.verisign.dime.DIMERecordFormatType;
import java.io.IOException;
import java.io.InputStream;

public class DIMEParser {
    public static final short VERSION = 1;
    private static byte[] _pads;
    private static boolean _debug;
    private InputStream _is;
    private DIMEInputStream _dis;
    private DIMERecord _prevRecord;
    private boolean _lastRecordConsumed;

    public DIMEParser(InputStream is) {
        this._is = is;
        this._dis = new DIMEInputStream(is);
        this._prevRecord = null;
        this._lastRecordConsumed = false;
    }

    public DIMEInputStream getDIMEInputStream() throws IllegalStateException {
        if (this._dis == null) {
            this._dis = new DIMEInputStream(this._is);
        }
        if (this._prevRecord == null) {
            throw new IllegalStateException("nextRecord() method must be called at least once before accessing this method");
        }
        return this._dis;
    }

    public DIMERecord nextRecord() throws IOException {
        boolean mb = false;
        boolean me = false;
        boolean chunked = false;
        if (this._lastRecordConsumed) {
            return null;
        }
        byte[] header = new byte[12];
        int nbytes = this._is.read(header);
        if (nbytes < 0) {
            return null;
        }
        chunked = (header[0] & DIMEGenerator.CF_FLAG) == DIMEGenerator.CF_FLAG;
        me = (header[0] & DIMEGenerator.ME_FLAG) == DIMEGenerator.ME_FLAG;
        mb = (header[0] & DIMEGenerator.MB_FLAG) == DIMEGenerator.MB_FLAG;
        int version = header[0] >> 3 & 0x3F;
        int type = (short)(header[1] >> 4) & 0x1F;
        int resv = (short)(header[1] >> 0) & 0;
        int optslen = header[2] << 8 & 0xFF00 | header[3] & 0xFF;
        int idlen = header[4] << 8 & 0xFF00 | header[5] & 0xFF;
        int typelen = header[6] << 8 & 0xFF00 | header[7] & 0xFF;
        long datalen = (long)header[8] << 24 & 0xFF000000L | (long)header[9] << 16 & 0xFF0000L | (long)header[10] << 8 & 0xFF00L | (long)header[11] & 0xFFL;
        int npad = 0;
        byte[] id = null;
        if (idlen != 0) {
            id = new byte[idlen];
            this._is.read(id);
            npad = DIMEGenerator.toPad(idlen);
            if (npad != 0) {
                this._is.read(_pads, 0, npad);
            }
        }
        byte[] typeData = null;
        if (typelen != 0) {
            typeData = new byte[typelen];
            this._is.read(typeData);
            npad = DIMEGenerator.toPad(typelen);
            if (npad != 0) {
                this._is.read(_pads, 0, npad);
            }
        }
        this._prevRecord = type == 0 ? new DIMERecord(null, DIMERecordFormatType.UNCHANGED, typeData != null ? new String(typeData, "UTF-8") : null, id != null ? new String(id, "UTF-8") : null, mb, me, chunked) : (type == 1 ? new DIMERecord(null, DIMERecordFormatType.MEDIA, typeData != null ? new String(typeData, "UTF-8") : null, id != null ? new String(id, "UTF-8") : null, mb, me, chunked) : (type == 2 ? new DIMERecord(null, DIMERecordFormatType.URI, typeData != null ? new String(typeData, "UTF-8") : null, id != null ? new String(id, "UTF-8") : null, mb, me, chunked) : (type == 3 ? new DIMERecord(null, DIMERecordFormatType.UNKNOWN, typeData != null ? new String(typeData, "UTF-8") : null, id != null ? new String(id, "UTF-8") : null, mb, me, chunked) : (type == 4 ? new DIMERecord(null, DIMERecordFormatType.NONE, typeData != null ? new String(typeData, "UTF-8") : null, id != null ? new String(id, "UTF-8") : null, mb, me, chunked) : new DIMERecord(null, DIMERecordFormatType.RESERVED, typeData != null ? new String(typeData, "UTF-8") : null, id != null ? new String(id, "UTF-8") : null, mb, me, chunked)))));
        this._prevRecord.setPayloadLength((int)datalen);
        this._dis._setCurrentPayloadLength((int)datalen);
        this._dis._setCurrentRecordChunked(chunked);
        this._dis._setCurrentRecordEnd(me);
        if (_debug) {
            System.out.println(this.getClass().getName() + ":nextRecord(): Record Begin...");
            this._prevRecord._debug();
            System.out.println(this.getClass().getName() + ":nextRecord(): Record End...");
        }
        if (me) {
            this._lastRecordConsumed = true;
        }
        return this._prevRecord;
    }

    static {
        VERSION = 1;
        _pads = new byte[4];
        String p = System.getProperty("dime.debug");
        _debug = p != null && p.equalsIgnoreCase("true");
    }
}

