/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.dime;

import com.verisign.dime.DIMEGenerator;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class DIMEInputStream
extends FilterInputStream {
    static byte[] _pads = new byte[4];
    static boolean _debug;
    InputStream _is;
    private int _currentPayloadLen;
    private int _currentChunkedPayloadLen;
    private int _bytesRead;
    private int _bytesNotRead;
    boolean _chunked;
    boolean _msgEnd;

    protected DIMEInputStream(InputStream is) {
        super(is);
        this._is = is;
        this._currentPayloadLen = 0;
        this._bytesNotRead = 0;
        this._bytesRead = 0;
        this._chunked = false;
        this._msgEnd = false;
    }

    public boolean isEnd() {
        return this._msgEnd;
    }

    void _setCurrentPayloadLength(int len) {
        this._currentPayloadLen = len;
        this._currentChunkedPayloadLen = len;
        this._bytesRead = 0;
    }

    void _setCurrentRecordChunked(boolean flag) {
        this._chunked = flag;
    }

    void _setCurrentRecordEnd(boolean flag) {
        this._msgEnd = flag;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int nread = this.read(b, 0, 1);
        if (nread < 0) {
            return -1;
        }
        return b[0];
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this._read(b, off, len);
    }

    public int available() {
        return 0;
    }

    public long skip(long l) {
        return 0L;
    }

    public void mark() {
    }

    public void reset() throws IOException {
    }

    public boolean markSupported() {
        return false;
    }

    public void close() throws IOException {
        if (_debug) {
            System.out.println(this.getClass().getName() + ": close() IGNORE CLOSING STREAM!");
        }
    }

    private synchronized int _read(byte[] buf, int off, int len) throws IOException {
        int nread;
        if (len > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length greather than 2147483647");
        }
        if (len < 0) {
            throw new IllegalArgumentException("Length cannot be negative");
        }
        if (off < 0) {
            throw new IllegalArgumentException("Offset cannot be negative");
        }
        if (buf == null) {
            throw new NullPointerException("byte array cannot be null");
        }
        if (buf.length < off + len) {
            throw new IllegalArgumentException("Offset + Length is greater than the size of the buffer");
        }
        if (len == 0 || this._currentPayloadLen == 0) {
            return -1;
        }
        int maxCanRead = len > this._currentPayloadLen && this._bytesNotRead == 0 ? this._currentPayloadLen : (len <= this._currentPayloadLen && this._bytesNotRead == 0 ? len : (this._bytesNotRead >= len ? len : this._bytesNotRead));
        if (this._bytesRead >= this._currentPayloadLen) {
            if (this._msgEnd) {
                return -1;
            }
            if (this._chunked) {
                this.readHeader();
                maxCanRead = len <= this._currentPayloadLen ? len : this._currentPayloadLen;
            } else {
                return -1;
            }
        }
        if ((nread = this._is.read(buf, off, maxCanRead)) < 0) {
            return -1;
        }
        if (nread > 0) {
            this._bytesRead += nread;
        }
        this._bytesNotRead = this._bytesRead < this._currentPayloadLen ? this._currentPayloadLen - this._bytesRead : 0;
        if (this._bytesRead >= this._currentPayloadLen) {
            int npad = this._chunked ? DIMEGenerator.toPad(this._currentChunkedPayloadLen) : DIMEGenerator.toPad(this._currentPayloadLen);
            if (npad != 0) {
                this._is.read(_pads, 0, npad);
            }
            if (_debug) {
                System.out.println(this.getClass().getName() + ":_read():end-of-payload:pads read=" + npad);
            }
        }
        if (_debug) {
            System.out.println(this.getClass().getName() + ":_read():BEGIN ---------");
            System.out.println(this.getClass().getName() + ":_read():nread=" + nread);
            System.out.println(this.getClass().getName() + ":_read():bytesRead=" + this._bytesRead);
            System.out.println(this.getClass().getName() + ":_read():bytesNotRead=" + this._bytesNotRead);
            System.out.println(this.getClass().getName() + ":_read():maxCanRead= " + maxCanRead);
            System.out.println(this.getClass().getName() + ":_read():currentPayloadLen= " + this._currentPayloadLen);
            System.out.println(this.getClass().getName() + ":_read():currentChunkedPayloadLen= " + this._currentChunkedPayloadLen);
            System.out.println(this.getClass().getName() + ":_read():END ---------");
        }
        return nread;
    }

    void readHeader() throws IOException {
        byte[] header = new byte[12];
        this._is.read(header);
        this._chunked = (header[0] & DIMEGenerator.CF_FLAG) == DIMEGenerator.CF_FLAG;
        this._msgEnd = (header[0] & DIMEGenerator.ME_FLAG) == DIMEGenerator.ME_FLAG;
        boolean mb = (header[0] & DIMEGenerator.MB_FLAG) == DIMEGenerator.MB_FLAG;
        int version = header[0] >> 3 & 0x3F;
        if (_debug) {
            System.out.println(this.getClass().getName() + ":_readHeader():BEGIN ---------");
            System.out.println(this.getClass().getName() + ":readHeader():VERSION\t= " + version);
            System.out.println(this.getClass().getName() + ":readHeader():CF\t\t= " + this._chunked);
            System.out.println(this.getClass().getName() + ":readHeader():MB\t\t= " + mb);
            System.out.println(this.getClass().getName() + ":readHeader():ME\t\t= " + this._msgEnd);
        }
        int type = (short)(header[1] >> 4) & 0x1F;
        int resv = (short)(header[1] >> 0) & 0;
        if (_debug) {
            System.out.println(this.getClass().getName() + ":readHeader():TYPE_T\t\t= " + type);
            System.out.println(this.getClass().getName() + ":readHeader():RESERVE\t= " + resv);
        }
        int optslen = header[2] << 8 & 0xFF00 | header[3] & 0xFF;
        int idlen = header[4] << 8 & 0xFF00 | header[5] & 0xFF;
        int typelen = header[6] << 8 & 0xFF00 | header[7] & 0xFF;
        long datalen = (long)header[8] << 24 & 0xFF000000L | (long)header[9] << 16 & 0xFF0000L | (long)header[10] << 8 & 0xFF00L | (long)header[11] & 0xFFL;
        if (_debug) {
            System.out.println(this.getClass().getName() + ":readHeader():OPTIONS_LENGTH\t= " + optslen);
            System.out.println(this.getClass().getName() + ":readHeader():ID_LENGTH\t\t= " + idlen);
            System.out.println(this.getClass().getName() + ":readHeader():TYPE_LENGTH\t\t= " + typelen);
            System.out.println(this.getClass().getName() + ":readHeader():DATA_LENGTH\t\t= " + datalen);
        }
        this._currentPayloadLen += (int)datalen;
        this._currentChunkedPayloadLen = (int)datalen;
        int npad = 0;
        byte[] id = null;
        if (idlen != 0) {
            id = new byte[idlen];
            this._is.read(id);
            npad = DIMEGenerator.toPad(idlen);
            if (npad != 0) {
                this._is.read(_pads, 0, npad);
            }
        }
        if (_debug) {
            System.out.println(this.getClass().getName() + ":readHeader():ID\t\t= " + id);
            System.out.println(this.getClass().getName() + ":readHeader():PADS\t= " + npad);
        }
        byte[] typeData = null;
        if (typelen != 0) {
            typeData = new byte[typelen];
            this._is.read(typeData);
            npad = DIMEGenerator.toPad(typelen);
            if (npad != 0) {
                this._is.read(_pads, 0, npad);
            }
        }
        if (_debug) {
            System.out.println(this.getClass().getName() + ":readHeader():TYPE\t= " + typeData);
            System.out.println(this.getClass().getName() + ":readHeader():PADS\t= " + npad);
            System.out.println(this.getClass().getName() + ":_readHeader():END ---------");
        }
    }

    static {
        String p = System.getProperty("dime.debug");
        _debug = p != null && p.equalsIgnoreCase("true");
    }
}

