/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.dime;

import com.verisign.dime.DIMERecord;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

public class DIMEGenerator {
    private static byte[] _pads;
    private static boolean _debug;
    public static final short VERSION = 1;
    static byte CF_FLAG;
    static byte MB_FLAG;
    static byte ME_FLAG;
    static byte SET_UNCHANGED_TYPE;
    static byte SET_MEDIA_TYPE;
    static byte SET_URI_TYPE;
    static byte SET_UNKNOWN_TYPE;
    static byte SET_NONE_TYPE;
    static byte SET_RESERV_TYPE;
    static byte SET_RESERV;
    static byte SET_VERSION;
    private OutputStream _os;
    private Set _inserted;

    public DIMEGenerator(OutputStream os) {
        this._os = os;
        this._inserted = new HashSet();
    }

    public boolean addRecord(DIMERecord dr) throws IOException {
        if (!this.isValidForInsertion(dr)) {
            return false;
        }
        try {
            if (_debug) {
                System.out.println(this.getClass().getName() + ":addRecord():Record wrote....");
                dr._debug();
            }
            this.encode(dr);
            this._os.flush();
        }
        catch (IOException ioe) {
            try {
                this._inserted.remove(dr.getId());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw ioe;
        }
        return true;
    }

    private byte[] getHeader(DIMERecord dr) {
        byte[] header = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte t = dr.getFormatType().getTypeValue();
        header[0] = (byte)(header[0] | SET_VERSION);
        if (dr.isFirst()) {
            header[0] = (byte)(header[0] | MB_FLAG);
        }
        if (dr.isChunked()) {
            header[0] = (byte)(header[0] | CF_FLAG);
        }
        if (dr.isEnd()) {
            header[0] = (byte)(header[0] | ME_FLAG);
        }
        if (t == 0) {
            if (dr.isEnd() && dr.isChunked() || !dr.isFirst() && dr.isChunked()) {
                header[1] = (byte)(header[1] | SET_UNCHANGED_TYPE);
            }
        } else {
            header[1] = t == 1 ? (byte)(header[1] | SET_MEDIA_TYPE) : (t == 2 ? (byte)(header[1] | SET_URI_TYPE) : (t == 3 ? (byte)(header[1] | SET_UNKNOWN_TYPE) : (t == 4 ? (byte)(header[1] | SET_NONE_TYPE) : (byte)(header[1] | SET_RESERV_TYPE))));
        }
        header[1] = (byte)(header[1] | SET_RESERV);
        header[2] = (byte)(header[2] | 0);
        header[3] = (byte)(header[3] | 0);
        return header;
    }

    static int toPad(int len) {
        int n = len % 4;
        return n == 0 ? 0 : 4 - n;
    }

    private boolean isValidForInsertion(DIMERecord dr) {
        if (!true) {
            return false;
        }
        if (dr.getId() == null) {
            return true;
        }
        if (dr.isFirst() && this._inserted.contains(dr.getId())) {
            return false;
        }
        if (dr.isFirst() && !this._inserted.contains(dr.getId())) {
            this._inserted.add(dr.getId());
        }
        return true;
    }

    private void encode(DIMERecord dr) throws IOException {
        byte[] payload;
        byte[] type;
        byte[] id;
        byte[] header = this.getHeader(dr);
        String val = null;
        int npad = 0;
        if (dr.getFormatType().getTypeValue() == 4 || dr.getFormatType().getTypeValue() == 0 || dr.isChunked() && !dr.isFirst()) {
            id = null;
            type = null;
            payload = dr.getPayload();
        } else {
            val = dr.getId();
            id = val != null ? val.getBytes("UTF-8") : null;
            val = dr.getType();
            type = val != null ? val.getBytes("UTF-8") : null;
            payload = dr.getPayload();
        }
        if (id != null) {
            header[4] = (byte)(id.length >>> 8 & 0xFF);
            header[5] = (byte)(id.length & 0xFF);
        }
        if (type != null) {
            header[6] = (byte)(type.length >>> 8 & 0xFF);
            header[7] = (byte)(type.length & 0xFF);
        }
        if (payload != null) {
            header[8] = (byte)(payload.length >>> 24 & 0xFF);
            header[9] = (byte)(payload.length >>> 16 & 0xFF);
            header[10] = (byte)(payload.length >>> 8 & 0xFF);
            header[11] = (byte)(payload.length & 0xFF);
        }
        this._os.write(header);
        if (id != null) {
            if (id.length > 65535) {
                throw new IOException("Size of id (number of bytes )exceeds maximum size 65535");
            }
            this._os.write(id);
            npad = DIMEGenerator.toPad(id.length);
            if (npad != 0) {
                this._os.write(_pads, 0, npad);
            }
        }
        if (type != null) {
            if (type.length > 65535) {
                throw new IOException("Size of type (number of bytes )exceeds maximum size 65535");
            }
            this._os.write(type);
            npad = DIMEGenerator.toPad(type.length);
            if (npad != 0) {
                this._os.write(_pads, 0, npad);
            }
        }
        if (payload != null) {
            if (payload.length > Integer.MAX_VALUE) {
                throw new IOException("Size of type (number of bytes )exceeds maximum size 2147483647");
            }
            this._os.write(payload);
            npad = DIMEGenerator.toPad(payload.length);
            if (npad != 0) {
                this._os.write(_pads, 0, npad);
            }
        }
    }

    static {
        VERSION = 1;
        CF_FLAG = 1;
        MB_FLAG = (byte)2;
        ME_FLAG = (byte)4;
        SET_UNCHANGED_TYPE = 0;
        SET_MEDIA_TYPE = (byte)16;
        SET_URI_TYPE = (byte)32;
        SET_UNKNOWN_TYPE = (byte)48;
        SET_NONE_TYPE = (byte)64;
        SET_RESERV_TYPE = (byte)64;
        SET_RESERV = 0;
        SET_VERSION = (byte)8;
        _pads = new byte[]{0, 0, 0, 0};
        String p = System.getProperty("dime.debug");
        _debug = p != null && p.equalsIgnoreCase("true");
    }
}

