/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.digsig.util;

import com.nanobiz.xpath.XPathAPI;
import com.verisign.digsig.encode.EncodingHelper;
import com.verisign.digsig.util.DOMHelper;
import com.verisign.resource.ResourceFactory;
import com.verisign.resource.XMLResource;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Helper {
    private static boolean DEBUG = false;

    public static void dump(String title, Element e) {
        System.err.println(">---" + title + "--------------------------");
        System.err.println("Element=[" + e + "]");
        XMLResource xml = ResourceFactory.getXMLResource();
        try {
            xml.publish((Node)e, (OutputStream)System.err, 1);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        System.err.println("<-----------------------------");
    }

    public static void dump(String title, Node n) {
        System.err.println(">---" + title + "--------------------------");
        System.err.println("Node=[" + n + "]");
        System.err.println(title);
        XMLResource xml = ResourceFactory.getXMLResource();
        try {
            xml.publish(n, (OutputStream)System.err, 1);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        System.err.println("<-----------------------------");
    }

    public static void dump(String title, byte[] b) {
        System.err.println(">---" + title + "--------------------------");
        try {
            System.err.println(EncodingHelper.encode(b, 1));
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.err.println("<-----------------------------");
    }

    public static Node findNode(Node startNode, String elementName) {
        if (DEBUG) {
            System.err.println(">>fn-----------------------------");
            Helper.dump("Search for " + elementName, (Element)startNode);
        }
        DOMHelper ops = DOMHelper.getInstance();
        Document doc = ResourceFactory.getXMLResource().createDocument();
        Element xPathScope = doc.createElementNS(null, "foo");
        ops.setNamespace(xPathScope, "dsig", "http://www.w3.org/2000/09/xmldsig#");
        Node n = XPathAPI.evaluateToNode(".//dsig:" + elementName, startNode, xPathScope);
        if (DEBUG) {
            System.err.println("Result: " + n);
            System.err.println("<<-----------------------------");
        }
        return n;
    }

    public static NodeList findNodeList(Node startNode, String elementName) {
        if (DEBUG) {
            System.err.println(">>fnl-----------------------------");
            Helper.dump("Search for " + elementName, (Element)startNode);
        }
        DOMHelper ops = DOMHelper.getInstance();
        Document doc = ResourceFactory.getXMLResource().createDocument();
        Element xPathScope = doc.createElementNS(null, "foo");
        ops.setNamespace(xPathScope, "dsig", "http://www.w3.org/2000/09/xmldsig#");
        NodeList nl = (NodeList)XPathAPI.evaluate(".//dsig:" + elementName, startNode, xPathScope);
        if (DEBUG) {
            System.err.println("Result: " + nl);
            System.err.println("<<-----------------------------");
        }
        return nl;
    }
}

