/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.digsig.ops;

import com.nanobiz.xpath.BindingContext;
import com.nanobiz.xpath.BoundExpression;
import com.nanobiz.xpath.Context;
import com.nanobiz.xpath.Expression;
import com.nanobiz.xpath.Function;
import com.nanobiz.xpath.InScopeNamespacesBindingContext;
import com.nanobiz.xpath.XPathException;
import com.nanobiz.xpath.XPathFactoryImpl;
import com.nanobiz.xpath.util.NodeSet;
import com.verisign.digsig.ops.InvalidAlgorithmException;
import com.verisign.digsig.ops.XAlgorithm;
import com.verisign.digsig.ops.XTransform;
import com.verisign.digsig.util.DOMHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathTransform
extends XTransform {
    private static DOMHelper ops = DOMHelper.getInstance();
    public static final String NAME = "XPath";
    public static final String NAMESPACE_URI = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    public static final String[] COMPAT_NAMESPACE_URIs;
    private static final String[] DEFAULT_NAMESPACES;
    private String xPathFilter;
    private Expression xPathExpr;
    private String[] namespaces = DEFAULT_NAMESPACES;

    XPathTransform() {
    }

    public XPathTransform(Element elem) throws InvalidAlgorithmException {
        this.bindElement(elem);
    }

    public XPathTransform(String filterExpr) throws XPathException {
        this(filterExpr, DEFAULT_NAMESPACES);
    }

    public XPathTransform(String filterExpr, String[] namespaces) throws XPathException {
        this.namespaces = namespaces == null ? DEFAULT_NAMESPACES : namespaces;
        this.setFilter(filterExpr);
    }

    public XAlgorithm getInstance() {
        return new XPathTransform();
    }

    public String getName() {
        return NAME;
    }

    public String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    public String[] getCompatibleNamespaceURIs() {
        return COMPAT_NAMESPACE_URIs;
    }

    public void bindElement(Element elem) throws InvalidAlgorithmException {
        Element node = ops.firstElementChild(elem);
        if (node == null || node.getNodeType() != 1 || !node.getLocalName().equals(NAME)) {
            throw new InvalidAlgorithmException("Missing XPath element for " + this.getNamespaceURI());
        }
        try {
            this.setFilter(node.getFirstChild().getNodeValue());
        }
        catch (XPathException e) {
            throw new InvalidAlgorithmException("xpath invalid: " + node.getNodeValue() + ' ' + e.getMessage());
        }
    }

    public Element makeElement(Document doc) {
        Element tfm = ops.createElem(doc, "Transform");
        ops.appendAttr(tfm, "Algorithm", this.getNamespaceURI());
        Element xp = ops.appendElem(tfm, NAME);
        xp.appendChild(doc.createTextNode(this.xPathFilter));
        int i = 0;
        while (i < this.namespaces.length) {
            ops.setNamespace(xp, this.namespaces[0], this.namespaces[1]);
            i += 2;
        }
        return tfm;
    }

    private void setFilter(String xPathFilter) throws XPathException {
        this.xPathFilter = xPathFilter;
        if (xPathFilter == null) {
            throw new Error();
        }
        XPathFactoryImpl xPathFactory = new XPathFactoryImpl();
        this.xPathExpr = xPathFactory.getExpression("(//. | //@* | //namespace::*)[" + xPathFilter + ']');
    }

    public Node transform(Node node) {
        NodeSet resultSet;
        MyContext ctx = new MyContext(node, this.namespaces);
        if (node.getNodeType() == 11) {
            resultSet = new NodeSet();
            Element inputNode = ops.firstElementChild(node);
            while (inputNode != null) {
                NodeSet set = XPathTransform.evalXPath(ctx, this.xPathExpr, node);
                resultSet.addAll(set);
                inputNode = ops.nextElementSibling(inputNode);
            }
        } else {
            resultSet = XPathTransform.evalXPath(ctx, this.xPathExpr, node);
        }
        Document doc = node.getOwnerDocument();
        Node o = XPathTransform.nodeSetToNode(doc, resultSet);
        return o;
    }

    public static Node evalXPointer(Element parent, String fragment) throws NoSuchElementException {
        return XPathTransform.evalXPointer(parent, fragment, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Node evalXPointer(Element parent, String fragment, String[] namespaces) throws NoSuchElementException {
        fragment = fragment.trim();
        Document doc = parent.getOwnerDocument();
        Node result = null;
        if (fragment.length() == 0) {
            Element elem = doc.getDocumentElement();
            result = XPathTransform.removeComments(elem);
        } else if (fragment.charAt(0) == '#' && fragment.length() > 1) {
            if (fragment.startsWith("#xpointer")) {
                Expression ex;
                String expr = fragment.substring(9);
                try {
                    XPathFactoryImpl xPathFactory = new XPathFactoryImpl();
                    ex = xPathFactory.getExpression(expr);
                }
                catch (XPathException e) {
                    throw new NoSuchElementException("invalid xpath: " + fragment);
                }
                if (namespaces == null) {
                    namespaces = DEFAULT_NAMESPACES;
                }
                MyContext ctx = new MyContext(parent, namespaces);
                result = XPathTransform.nodeSetToNode(doc, XPathTransform.evalXPath(ctx, ex, parent));
            } else {
                Node foo;
                Element root = parent;
                while ((foo = root.getParentNode()) != null) {
                    void expr;
                    if (expr.getNodeType() != 1) break;
                    root = expr;
                }
                if ((result = XPathTransform.locateElementById(root, fragment.substring(1))) == null) {
                    throw new NoSuchElementException("Id not found: " + fragment);
                }
            }
        } else {
            throw new NoSuchElementException("Invalid reference URL: " + fragment);
        }
        return result;
    }

    public static Node evalXPointer2(Element parent, String fragment) throws NoSuchElementException {
        fragment = fragment.trim();
        Element result = null;
        result = XPathTransform.locateElementById(parent, fragment.substring(1));
        if (result == null) {
            throw new NoSuchElementException("Id not found: " + fragment);
        }
        return result;
    }

    private static NodeSet evalXPath(BindingContext ctx, Expression ex, Node contextNode) throws NoSuchElementException {
        BoundExpression bx = ex.bind(ctx);
        Object val = bx.evaluate(contextNode, 1, 1);
        if (val instanceof NodeSet) {
            return (NodeSet)val;
        }
        if (!(val instanceof NodeList)) {
            throw new NoSuchElementException("xpath expression did not evaluate to a node list:" + val);
        }
        return new NodeSet((NodeList)val);
    }

    private static Node nodeSetToNode(Document doc, NodeSet set) {
        int size = set.size();
        if (size == 1) {
            return (Node)set.first();
        }
        Node[] nodes = new Node[size];
        set.toArray(nodes);
        int i = 0;
        while (i < size) {
            Node node = nodes[i];
            if (set.contains(node)) {
                XPathTransform.trimNodeSet(node, set);
            }
            ++i;
        }
        size = set.size();
        if (size == 1) {
            return (Node)set.first();
        }
        DocumentFragment frag = doc.createDocumentFragment();
        Iterator elements = set.iterator();
        while (elements.hasNext()) {
            Node node = (Node)elements.next();
            short type = node.getNodeType();
            if (type == 2 || type == 9) continue;
            frag.appendChild(node);
        }
        return frag;
    }

    private static void trimNodeSet(Node parent, NodeSet set) {
        short type = parent.getNodeType();
        Node child = null;
        Attr attr = null;
        if (type == 2) {
            return;
        }
        if (type == 1) {
            Element elt = (Element)parent;
            NamedNodeMap nm = elt.getAttributes();
            ArrayList<Attr> yanklist = new ArrayList<Attr>();
            int i = 0;
            while (i < nm.getLength()) {
                attr = (Attr)nm.item(i);
                if (set.contains(attr)) {
                    set.remove(attr);
                } else {
                    yanklist.add(attr);
                }
                ++i;
            }
            Iterator it = yanklist.iterator();
            while (it.hasNext()) {
                attr = (Attr)it.next();
                elt.removeAttributeNode(attr);
            }
        }
        child = parent.getFirstChild();
        while (child != null) {
            Node next = child.getNextSibling();
            if (set.contains(child)) {
                set.remove(child);
                XPathTransform.trimNodeSet(child, set);
            } else {
                parent.removeChild(child);
            }
            child = next;
        }
    }

    private static Node removeComments(Node node) {
        return node;
    }

    private static final Element locateElementById(Element context, String id) {
        if (context.getAttribute("Id").equals(id)) {
            return context;
        }
        NodeList nl = context.getChildNodes();
        Element chk = null;
        int i = 0;
        while (i < nl.getLength()) {
            Node scan = nl.item(i);
            if (scan.getNodeType() == 1 && (chk = XPathTransform.locateElementById((Element)scan, id)) != null) {
                return chk;
            }
            ++i;
        }
        return null;
    }

    static /* synthetic */ Element access$000(Element x0, String x1) {
        return XPathTransform.locateElementById(x0, x1);
    }

    static {
        NAME = NAME;
        NAMESPACE_URI = NAMESPACE_URI;
        COMPAT_NAMESPACE_URIs = new String[0];
        DEFAULT_NAMESPACES = new String[]{"xkms", "http://www.xkms.org/schema/xkms-2001-01-20", "dsig", "http://www.w3.org/2000/09/xmldsig#", "xs", "http://www.w3.org/2000/10/XMLSchema", "xsi", "http://www.w3.org/2000/10/XMLSchema-instance"};
    }

    private static class MyContext
    extends InScopeNamespacesBindingContext {
        Node here;
        Map namespaces;
        private static Function idFunction = new Function(){

            public Object evaluate(Context context, List args) {
                String id = (String)args.get(0);
                Node node = context.getNode();
                Document doc = node.getOwnerDocument();
                if (doc == null) {
                    doc = (Document)node;
                }
                Element elem = XPathTransform.access$000(doc.getDocumentElement(), id);
                NodeSet set = new NodeSet();
                set.add(elem);
                return set;
            }
        };
        private Function hereFunction = new Function(this){
            private final /* synthetic */ MyContext this$0;
            {
                this.this$0 = this$0;
            }

            public Object evaluate(Context context, List args) {
                NodeSet set = new NodeSet();
                set.add(this.this$0.here);
                return set;
            }
        };

        MyContext(Node here, String[] namespaces) {
            super(new XPathFactoryImpl().getDefaultBindingContext(), here);
            this.here = here;
            this.namespaces = new HashMap();
            int i = 0;
            while (i < namespaces.length) {
                this.namespaces.put(namespaces[i], namespaces[i + 1]);
                i += 2;
            }
        }

        public String getNamespaceURI(String prefix) {
            String uri = (String)this.namespaces.get(prefix);
            if (uri != null) {
                return uri;
            }
            return super.getNamespaceURI(prefix);
        }

        public Function getFunction(String namespaceURI, String localName) {
            if (namespaceURI == null && localName.equals("id")) {
                return idFunction;
            }
            if (namespaceURI == null && localName.equals("here")) {
                return this.hereFunction;
            }
            return super.getFunction(namespaceURI, localName);
        }
    }
}

