/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.digsig.ops;

import com.nanobiz.xpath.XPathException;
import com.verisign.digsig.ops.InvalidAlgorithmException;
import com.verisign.digsig.ops.XAlgorithm;
import com.verisign.digsig.ops.XTransform;
import com.verisign.digsig.util.DOMHelper;
import com.verisign.resource.DOMOperations;
import com.verisign.xmlsig.util.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XEnvelopedTransform
extends XTransform {
    private static boolean DEBUG = false;
    private static DOMHelper ops = DOMHelper.getInstance();
    private static DOMOperations domOps = new DOMOperations();
    public static final String NAME = "Enveloped";
    public static final String NAMESPACE_URI = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    public static final String[] COMPAT_NAMESPACE_URIs;
    private Element bindElement;

    public XAlgorithm getInstance() {
        try {
            return new XEnvelopedTransform();
        }
        catch (XPathException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getName() {
        return NAME;
    }

    public String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    public String[] getCompatibleNamespaceURIs() {
        return COMPAT_NAMESPACE_URIs;
    }

    public Element makeElement(Document doc) {
        Element tfm = ops.createElem(doc, "Transform");
        ops.appendAttr(tfm, "Algorithm", this.getNamespaceURI());
        return tfm;
    }

    public void bindElement(Element elem) throws InvalidAlgorithmException {
        if (DEBUG) {
            System.err.println("Binding element to: " + elem);
        }
        this.bindElement = elem;
        if (DEBUG) {
            Node node = elem;
            while (node != null) {
                System.err.println("Parent: " + node);
                node = node.getParentNode();
            }
        }
    }

    private boolean isSig(Node node) {
        return node.getNodeType() == 1 && "Signature".equals(domOps.getLocalName(node)) && "http://www.w3.org/2000/09/xmldsig#".equals(domOps.getNamespaceURI(node));
    }

    public Node transform(Node node) {
        if (DEBUG) {
            if (this.bindElement == null) {
                System.err.println("Has NO bound element");
            } else {
                System.err.println("Has a bound element");
            }
            Helper.showHere();
            System.err.println("Transform " + node);
        }
        this.process(node);
        return node;
    }

    private void process(Node node) {
        if (this.isSig(node)) {
            if (DEBUG) {
                System.err.println("removing " + node);
            }
            node.getParentNode().removeChild(node);
        }
        Node child = node.getFirstChild();
        while (child != null) {
            this.process(child);
            child = child.getNextSibling();
        }
    }

    static {
        NAME = NAME;
        NAMESPACE_URI = NAMESPACE_URI;
        COMPAT_NAMESPACE_URIs = new String[0];
    }
}

