/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.digsig.ops;

import com.nanobiz.xpath.XPathAPI;
import com.verisign.definitions.DigSigDefinitions;
import com.verisign.digsig.encode.EncodingHelper;
import com.verisign.digsig.keys.XKeyInfo;
import com.verisign.digsig.ops.IdRequiredException;
import com.verisign.digsig.ops.InvalidAlgorithmException;
import com.verisign.digsig.ops.XAlgorithm;
import com.verisign.digsig.ops.XCanonicalize;
import com.verisign.digsig.ops.XDigest;
import com.verisign.digsig.ops.XPathTransform;
import com.verisign.digsig.ops.XTransform;
import com.verisign.resource.DOMOperations;
import com.verisign.resource.ResourceFactory;
import com.verisign.resource.XMLResource;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DigVerifier
implements DigSigDefinitions {
    DOMOperations ops = DOMOperations.getInstance();
    static final boolean DEBUG_SIGNED_DATA_DUMP = false;
    static final boolean DEBUG = false;
    public static final String NAMESPACE_URI = "http://www.w3.org/2000/09/xmldsig@rsa-sha1";
    public static final String[] COMPAT_NAMESPACE_URIs;
    private Vector signatures = new Vector();
    private Document doc;

    public DigVerifier(Document doc) throws NoSuchAlgorithmException, InvalidAlgorithmException {
        this.doc = doc;
        Element xPathScope = doc.createElementNS(null, "x");
        this.ops.setNamespace(xPathScope, "dsig", "http://www.w3.org/2000/09/xmldsig#");
        NodeList nl = (NodeList)XPathAPI.evaluate(".//dsig:Signature", doc, xPathScope);
        int i = 0;
        while (i < nl.getLength()) {
            this.signatures.addElement(new SigData((Element)nl.item(i)));
            ++i;
        }
    }

    public DigVerifier(Document doc, Node n) throws NoSuchAlgorithmException, InvalidAlgorithmException {
        this.doc = doc;
        this.signatures.addElement(new SigData((Element)n));
    }

    public int getNumberOfSignatures() {
        return this.signatures.size();
    }

    public boolean verifySignature(int idx, XKeyInfo xki) throws IdRequiredException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidKeySpecException {
        SigData dt = (SigData)this.signatures.elementAt(idx);
        if (dt.verified) {
            return dt.passed;
        }
        if (xki == null) {
            throw new InvalidKeyException("NULL Key");
        }
        if (dt.signedInfo.canAlgorithm == null) {
            dt.signedInfo.canAlgorithm = XCanonicalize.getXCanonicalize("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        }
        if (dt.signedInfo.canAlgorithm == null) {
            throw new NoSuchAlgorithmException("Canonicalize algorithm not specified");
        }
        byte[] canon = dt.signedInfo.canAlgorithm.getCanonicalForm(dt.signedInfo.signedInfo);
        if (!xki.getKeyValue().verifySignature(canon, dt.sigValue)) {
            dt.passed = false;
            dt.verified = true;
            return dt.passed;
        }
        dt.passed = true;
        dt.verified = true;
        return dt.passed;
    }

    public boolean verifySignature(int idx) throws IdRequiredException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidKeySpecException {
        SigData dt = (SigData)this.signatures.elementAt(idx);
        if (dt.verified) {
            return dt.passed;
        }
        return this.verifySignature(idx, dt.xkinfo);
    }

    public boolean verifySignatureAndReferences(int idx, XKeyInfo xki) throws IdRequiredException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidKeySpecException {
        return this.verifySignature(idx, xki) && this.verifySignatureReferences(idx);
    }

    public boolean verifySignatureAndReferences(int idx) throws IdRequiredException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidKeySpecException {
        SigData dt = (SigData)this.signatures.elementAt(idx);
        return this.verifySignatureAndReferences(idx, dt.xkinfo);
    }

    public boolean verifySignatureReferences(int idx) throws IdRequiredException, NoSuchAlgorithmException {
        SigData dt = (SigData)this.signatures.elementAt(idx);
        int i = 0;
        while (i < dt.signedInfo.getReferenceCount()) {
            if (!dt.signedInfo.getReference(i).verifyDigest()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Element getSignatureElement(int idx) {
        SigData dt = (SigData)this.signatures.elementAt(idx);
        return dt.signature;
    }

    public XKeyInfo getKeyInfo(int idx) {
        SigData dt = (SigData)this.signatures.elementAt(idx);
        return dt.xkinfo;
    }

    static void dump(String label, Node refNode, byte[] canon, byte[] digest) {
        try {
            XMLResource xml = ResourceFactory.getXMLResource();
            FileOutputStream fos = new FileOutputStream("/tmp/digsig." + label);
            PrintStream out = new PrintStream(fos, true);
            out.println("---- " + label);
            xml.publish(refNode, (OutputStream)out, 1);
            out.println("-- canon raw");
            out.println(new String(canon));
            out.println("-- canon");
            out.println(EncodingHelper.encode(canon, 1));
            out.println("-- digest");
            out.println(EncodingHelper.encode(digest, 1));
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    static {
        DEBUG_SIGNED_DATA_DUMP = false;
        DEBUG = false;
        NAMESPACE_URI = NAMESPACE_URI;
        COMPAT_NAMESPACE_URIs = new String[]{"http://www.w3.org/TR/2000/WD-xmldsig-core-20000601/"};
    }

    class SigData {
        boolean verified = false;
        boolean passed = false;
        Element signature;
        SigInfo signedInfo;
        Element object;
        byte[] sigValue;
        XKeyInfo xkinfo;

        SigData(Element sig) throws NoSuchAlgorithmException, InvalidAlgorithmException {
            this.signature = sig;
            NodeList nl = sig.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node scan = nl.item(i);
                if (scan.getNodeType() == 1) {
                    String tag = DigVerifier.this.ops.getLocalName(scan);
                    if (tag.equals("SignedInfo")) {
                        this.signedInfo = new SigInfo((Element)scan);
                    } else if (tag.equals("SignatureValue")) {
                        Element sigVEl = (Element)scan;
                        Text txt = (Text)sigVEl.getFirstChild();
                        this.sigValue = EncodingHelper.decode(txt.getNodeValue(), 1);
                    } else if (tag.equals(XKeyInfo.TAG_KEYINFO)) {
                        this.xkinfo = new XKeyInfo((Element)scan);
                    } else if (tag.equals("Object")) {
                        this.object = (Element)scan;
                    }
                }
                ++i;
            }
        }
    }

    class SigInfo {
        Element signedInfo;
        String sigmethod;
        String canmethod;
        XCanonicalize canAlgorithm = null;
        Vector references = new Vector();

        SigInfo(Element sigInfo) throws NoSuchAlgorithmException, InvalidAlgorithmException {
            this.signedInfo = sigInfo;
            NodeList nl = sigInfo.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node scan = nl.item(i);
                if (scan.getNodeType() == 1) {
                    String tag = DigVerifier.this.ops.getLocalName(scan);
                    if (tag.equals("Reference")) {
                        this.references.addElement(new SigRef((Element)scan));
                    } else if (tag.equals("SignatureMethod")) {
                        this.sigmethod = ((Element)scan).getAttribute("Algorithm");
                    } else if (tag.equals("CanonicalizationMethod")) {
                        this.canmethod = ((Element)scan).getAttribute("Algorithm");
                        this.canAlgorithm = XCanonicalize.getXCanonicalize(this.canmethod);
                    }
                }
                ++i;
            }
        }

        int getReferenceCount() {
            return this.references.size();
        }

        SigRef getReference(int idx) {
            return (SigRef)this.references.elementAt(idx);
        }
    }

    class SigRef {
        Element reference;
        byte[] digest;
        XDigest xdigest;
        XCanonicalize xcanon;
        List transforms;

        SigRef(Element sigref) throws NoSuchAlgorithmException, InvalidAlgorithmException {
            this.reference = sigref;
            NodeList nl = this.reference.getChildNodes();
            Node digestEl = null;
            int i = 0;
            while (i < nl.getLength()) {
                Node scan = nl.item(i);
                if (scan.getNodeType() == 1) {
                    String tag = DigVerifier.this.ops.getLocalName(scan);
                    if (tag.equals("Transforms")) {
                        Element xPathScope = DigVerifier.this.doc.createElementNS(null, "x");
                        DigVerifier.this.ops.setNamespace(xPathScope, "dsig", "http://www.w3.org/2000/09/xmldsig#");
                        NodeList nl2 = (NodeList)XPathAPI.evaluate(".//dsig:Transform", scan, xPathScope);
                        int n = 0;
                        while (n < nl2.getLength()) {
                            Element tform = (Element)nl2.item(n);
                            String salg = tform.getAttribute("Algorithm");
                            XAlgorithm alg = XAlgorithm.getXAlgorithm(salg);
                            if (alg instanceof XCanonicalize) {
                                if (this.xcanon != null) {
                                    // empty if block
                                }
                                this.xcanon = (XCanonicalize)alg;
                            } else if (alg instanceof XTransform) {
                                XTransform transform = (XTransform)alg;
                                transform.bindElement(tform);
                                if (this.transforms == null) {
                                    this.transforms = new ArrayList();
                                }
                                this.transforms.add(transform);
                            } else {
                                throw new InvalidAlgorithmException("Not canonicalize or transform: " + salg);
                            }
                            ++n;
                        }
                    } else if (tag.equals("DigestMethod")) {
                        String attr = ((Element)scan).getAttribute("Algorithm");
                        this.xdigest = XDigest.getXDigest(attr);
                    } else if (tag.equals("DigestValue")) {
                        digestEl = (Element)scan;
                    }
                }
                ++i;
            }
            if (digestEl != null) {
                Text txt = (Text)digestEl.getFirstChild();
                this.digest = EncodingHelper.decode(txt.getNodeValue(), 1);
            }
        }

        boolean verifyDigest() throws IdRequiredException, NoSuchAlgorithmException {
            Node refNode;
            if (this.xcanon == null) {
                this.xcanon = XCanonicalize.getXCanonicalize("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
                if (this.xcanon == null) {
                    throw new NoSuchAlgorithmException("Canonicalize algorithm not specified");
                }
            }
            if (this.xdigest == null) {
                throw new NoSuchAlgorithmException("Digest algorithm not specified");
            }
            String id = this.reference.getAttribute("URI");
            if (id == null) {
                throw new IdRequiredException("URI attribute required for referencing elements for signature");
            }
            Document workDoc = ResourceFactory.getXMLResource().createDocument();
            Node workElem = workDoc.importNode(DigVerifier.this.doc.getDocumentElement(), true);
            workDoc.appendChild(workElem);
            try {
                refNode = XPathTransform.evalXPointer(workDoc.getDocumentElement(), id);
            }
            catch (Exception e) {
                throw new IdRequiredException(e.getMessage());
            }
            if (this.transforms != null) {
                int i = 0;
                while (i < this.transforms.size()) {
                    XTransform transform = (XTransform)this.transforms.get(i);
                    refNode = transform.transform(refNode);
                    ++i;
                }
            }
            byte[] canon = this.xcanon.getCanonicalForm(refNode);
            byte[] chkdigest = this.xdigest.getDigest(canon);
            return EncodingHelper.equalBlobs(chkdigest, this.digest);
        }
    }
}

