/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.digsig.ops;

import com.nanobiz.xpath.XPathAPI;
import com.verisign.definitions.DigSigDefinitions;
import com.verisign.digsig.elements.KeyInfo;
import com.verisign.digsig.elements.Reference;
import com.verisign.digsig.elements.Signature;
import com.verisign.digsig.elements.SignedInfo;
import com.verisign.digsig.keys.XKeyInfo;
import com.verisign.digsig.ops.IdRequiredException;
import com.verisign.digsig.ops.XTransform;
import com.verisign.digsig.util.DOMHelper;
import com.verisign.resource.ResourceFactory;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DigSigner
implements DigSigDefinitions {
    private static DOMHelper ops = DOMHelper.getInstance();
    static final boolean DEBUG = false;
    public static final String[] COMPAT_NAMESPACE_URIs;
    private Document doc;
    private Element element;
    private Signature signature;
    Node verifyingKey = null;
    private Vector objects;

    public DigSigner(Element element) {
        this.doc = element.getOwnerDocument();
        this.element = element;
        this.construct();
    }

    public DigSigner(Document doc) {
        this.objects = new Vector();
        this.doc = doc;
        this.element = null;
        this.construct();
    }

    private void construct() {
        this.objects = new Vector();
        this.signature = this.element != null && Signature.canHandle(this.element) ? Signature.fromDOM(this.element) : new Signature();
    }

    public Element getElement() {
        return this.signature.toDOM().getDocumentElement();
    }

    public Element getSignedInfoElement() {
        return this.signature.getSignedInfo().toDOM().getDocumentElement();
    }

    public void sign() throws SignatureException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        Node parent;
        Node where = null;
        where = this.element == null ? this.doc.getDocumentElement() : ("Signature".equals(ops.getLocalName(this.element)) ? ((parent = this.element.getParentNode()) == null ? this.doc.getDocumentElement() : parent) : this.element);
        this.signature.addObjects(this.objects);
        SignedInfo signedInfo = this.signature.getSignedInfo();
        byte[] canon = signedInfo.getCanonicalForm(where);
        XKeyInfo signingKey = this.signature.getSigningKey();
        if (signingKey == null) {
            throw new InvalidKeyException("No signing key set");
        }
        byte[] bsig = signingKey.getKeyValue().signData(canon);
        this.signature.setSignatureValue(bsig);
        Element e = this.getElement();
        Node n = ResourceFactory.getXMLResource().cloneWithOwner(this.doc, e, true);
        if (this.element == null) {
            this.doc.appendChild(n);
            return;
        }
        if ("Signature".equals(ops.getLocalName(this.element))) {
            Node parent2 = this.element.getParentNode();
            if (parent2 == null) {
                this.doc.getDocumentElement().appendChild(n);
            } else {
                parent2.removeChild(this.element);
                parent2.appendChild(n);
            }
        } else {
            this.element.appendChild(n);
        }
    }

    public void setDigestAlgorithm(String uri) throws NoSuchAlgorithmException {
        SignedInfo signedInfo = this.signature.getSignedInfo();
        signedInfo.setDigestAlgorithm(uri);
    }

    public void setSigningKey(XKeyInfo xkinfo) {
        this.signature.setSigningKey(xkinfo);
    }

    public void setSigningKey(Element sigKey) {
        this.signature.setSigningKey(sigKey);
    }

    public void setVerifyingKey(Element verKey) {
        Element xPathScope = this.doc.createElementNS(null, "x");
        ops.setNamespace(xPathScope, "dsig", "http://www.w3.org/2000/09/xmldsig#");
        Node n = XPathAPI.evaluateToNode(".//dsig:KeyValue", verKey, xPathScope);
        if (n == null) {
            throw new IllegalArgumentException(verKey.toString());
        }
        KeyInfo keyInfo = this.signature.getKeyInfo();
        keyInfo.setVerifyingKey(n);
    }

    private Reference addReferenceReturnRef(String id) throws NoSuchAlgorithmException, NoSuchElementException {
        return this.addReferenceReturnRef(id, null);
    }

    private Reference addReferenceReturnRef(String id, XTransform[] transforms) throws NoSuchAlgorithmException, NoSuchElementException {
        SignedInfo signedInfo = this.signature.getSignedInfo();
        Reference ref = signedInfo.addReference(id, transforms);
        ref.setTarget(this.element);
        return ref;
    }

    public void addReference(URL url) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Not implemented");
    }

    public void addReference(String id) throws NoSuchAlgorithmException, NoSuchElementException {
        this.addReference(id, (XTransform[])null);
    }

    public void addReference(String id, Element target) throws NoSuchAlgorithmException, NoSuchElementException {
        this.addReference(id, null, target);
    }

    public void addReference(String id, XTransform[] transforms) throws NoSuchAlgorithmException, NoSuchElementException {
        SignedInfo signedInfo = this.signature.getSignedInfo();
        Reference ref = signedInfo.addReference(id, transforms);
        ref.setTarget(this.element);
    }

    public void addReference(String id, XTransform[] transforms, Element target) throws NoSuchAlgorithmException, NoSuchElementException {
        SignedInfo signedInfo = this.signature.getSignedInfo();
        Reference ref = signedInfo.addReference(id, transforms);
        ref.setTarget(target);
    }

    public void addSigTarget(Element elem) throws IdRequiredException, NoSuchAlgorithmException {
        String id = elem.getAttribute("Id");
        if (id == null || id.length() == 0) {
            throw new IdRequiredException("Id required for referencing elements for signature");
        }
        this.objects.addElement(elem);
        Reference ref = this.addReferenceReturnRef(id);
        ref.setTarget(elem);
    }

    static {
        DEBUG = false;
        COMPAT_NAMESPACE_URIs = new String[]{"http://www.w3.org/TR/2000/WD-xmldsig-core-20000601/"};
    }
}

