/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.digsig.keys;

import com.nanobiz.xpath.XPathAPI;
import com.verisign.digsig.encode.EncodingDefinitions;
import com.verisign.digsig.encode.EncodingHelper;
import com.verisign.digsig.keys.XKeyValue;
import com.verisign.digsig.util.DOMHelper;
import com.verisign.xmlsig.util.Helper;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XRSAKeyValue
extends XKeyValue
implements EncodingDefinitions {
    private static boolean DEBUG = false;
    private static DOMHelper ops = DOMHelper.getInstance();
    public static final String TAG_SIG_NAMESPACE_URI = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String TAG_RSAKEYVALUE = "RSAKeyValue";
    public static final String TAG_EXPONENT = "Exponent";
    public static final String TAG_MODULUS = "Modulus";
    public static final String ATTR_ENCODING = "encoding";
    public static final String RSA = "rsa";
    private Document doc = null;
    private RSAKey key = null;
    private Element topKeyValue = null;
    private Element keyValue = null;
    private int encoding = 1;

    public XRSAKeyValue(Document doc) {
        this.doc = doc;
    }

    public XRSAKeyValue(Document doc, RSAKey key) {
        this.doc = doc;
        this.setRSAKey(key);
    }

    public XRSAKeyValue(Element keyValue) {
        if (ops.getLocalName(keyValue).equals("KeyValue")) {
            keyValue = ops.firstElementChild(keyValue);
        }
        this.keyValue = keyValue;
        this.topKeyValue = (Element)keyValue.getParentNode();
        this.doc = keyValue.getOwnerDocument();
        this.encoding = EncodingHelper.getEncodingId(keyValue.getAttribute(ATTR_ENCODING));
    }

    public String getSignatureMethodURI() {
        return TAG_SIG_NAMESPACE_URI;
    }

    public byte[] signData(byte[] data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidKeySpecException {
        Signature sig = Signature.getInstance("SHA1withRSA");
        if (this.key == null) {
            this.key = this.getAsRSAPrivateKey();
        }
        if (this.key instanceof RSAPublicKey) {
            throw new InvalidKeyException("Cannot sign data with your public key..  Who would verify it?");
        }
        sig.initSign((RSAPrivateKey)this.key);
        sig.update(data);
        return sig.sign();
    }

    public boolean verifySignature(byte[] data, byte[] sigd) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidKeySpecException {
        Signature sig = Signature.getInstance("SHA1withRSA");
        if (this.key == null) {
            this.key = this.getAsRSAPublicKey();
        }
        if (this.key instanceof RSAPrivateKey) {
            throw new InvalidKeyException("Cannot verify a signature with your private key..  What is the value of a public-key signature?");
        }
        sig.initVerify((RSAPublicKey)this.key);
        sig.update(data);
        return sig.verify(sigd);
    }

    public Element getElement() {
        if (this.keyValue == null) {
            this.makeElement();
        }
        return this.topKeyValue;
    }

    private synchronized void makeElement() {
        if (this.key == null) {
            return;
        }
        this.topKeyValue = ops.createElem(this.doc, "KeyValue");
        this.keyValue = ops.appendElem(this.topKeyValue, TAG_RSAKEYVALUE);
        Element modulus = ops.appendElem(this.keyValue, TAG_MODULUS);
        byte[] a = this.key.getModulus().toByteArray();
        a = this.fix2Complement(a);
        modulus.appendChild(this.doc.createTextNode(EncodingHelper.encode(a, this.encoding)));
        Element exp = ops.createElem(this.doc, TAG_EXPONENT);
        if (this.key instanceof RSAPublicKey) {
            a = ((RSAPublicKey)this.key).getPublicExponent().toByteArray();
            a = this.fix2Complement(a);
            exp.appendChild(this.doc.createTextNode(EncodingHelper.encode(a, this.encoding)));
        } else {
            a = ((RSAPrivateKey)this.key).getPrivateExponent().toByteArray();
            a = this.fix2Complement(a);
            exp.appendChild(this.doc.createTextNode(EncodingHelper.encode(a, this.encoding)));
        }
        this.keyValue.appendChild(exp);
    }

    private byte[] fix2Complement(byte[] a) {
        if (a[0] == 0) {
            byte[] b = new byte[a.length - 1];
            System.arraycopy(a, 1, b, 0, a.length - 1);
            return b;
        }
        return a;
    }

    private BigInteger[] getKeyData() {
        int enc = 1;
        Element xPathScope = this.doc.createElementNS(null, "x");
        ops.setNamespace(xPathScope, "dsig", "http://www.w3.org/2000/09/xmldsig#");
        NodeList nlmod = (NodeList)XPathAPI.evaluate(".//dsig:Modulus", this.keyValue, xPathScope);
        if (DEBUG) {
            Helper.dump((Object)this, "Modulus from XML", nlmod.item(0));
        }
        if (nlmod.getLength() < 1) {
            return null;
        }
        NodeList nlexp = (NodeList)XPathAPI.evaluate(".//dsig:Exponent", this.keyValue, xPathScope);
        if (DEBUG) {
            Helper.dump((Object)this, "Exponent from XML", nlexp.item(0));
        }
        if (nlexp.getLength() < 1) {
            return null;
        }
        Element mod = (Element)nlmod.item(0);
        Element exp = (Element)nlexp.item(0);
        Text modt = null;
        Text expt = null;
        NodeList nl = mod.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeType() == 3) {
                modt = (Text)nl.item(i);
                break;
            }
            ++i;
        }
        if (modt == null) {
            return null;
        }
        nl = exp.getChildNodes();
        int i2 = 0;
        while (i2 < nl.getLength()) {
            if (nl.item(i2).getNodeType() == 3) {
                expt = (Text)nl.item(i2);
                break;
            }
            ++i2;
        }
        if (expt == null) {
            return null;
        }
        BigInteger[] ret = new BigInteger[2];
        byte[] a = EncodingHelper.decode(modt.getNodeValue(), enc);
        ret[0] = new BigInteger(1, this.fix2Complement(a));
        a = EncodingHelper.decode(expt.getNodeValue(), enc);
        ret[1] = new BigInteger(1, this.fix2Complement(a));
        return ret;
    }

    public RSAPublicKey getAsRSAPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (this.key != null && this.key instanceof RSAPublicKey) {
            return (RSAPublicKey)this.key;
        }
        if (this.keyValue == null) {
            return null;
        }
        BigInteger[] mod_exp = this.getKeyData();
        KeyFactory rsaKeyFactory = KeyFactory.getInstance(RSA);
        RSAPublicKeySpec kspec = new RSAPublicKeySpec(mod_exp[0], mod_exp[1]);
        return (RSAPublicKey)rsaKeyFactory.generatePublic(kspec);
    }

    public RSAPrivateKey getAsRSAPrivateKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (this.key != null && this.key instanceof RSAPrivateKey) {
            return (RSAPrivateKey)this.key;
        }
        if (this.keyValue == null) {
            return null;
        }
        BigInteger[] mod_exp = this.getKeyData();
        KeyFactory rsaKeyFactory = KeyFactory.getInstance(RSA);
        RSAPrivateKeySpec kspec = new RSAPrivateKeySpec(mod_exp[0], mod_exp[1]);
        return (RSAPrivateKey)rsaKeyFactory.generatePrivate(kspec);
    }

    public synchronized void setRSAKey(RSAKey rpk) {
        if (this.key == rpk) {
            return;
        }
        this.key = rpk;
        this.keyValue = null;
        this.topKeyValue = null;
    }

    public synchronized void setEncoding(int encoding) {
        if (this.encoding == encoding) {
            return;
        }
        this.encoding = encoding;
        this.keyValue = null;
        this.topKeyValue = null;
    }

    public synchronized PublicKey getAsPublicKey() throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        if (this.key == null) {
            this.key = this.getAsRSAPublicKey();
        }
        return (PublicKey)((Object)this.key);
    }

    public synchronized PrivateKey getAsPrivateKey() throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        if (this.key == null) {
            this.key = this.getAsRSAPrivateKey();
        }
        return (PrivateKey)((Object)this.key);
    }

    static {
        TAG_SIG_NAMESPACE_URI = TAG_SIG_NAMESPACE_URI;
        TAG_RSAKEYVALUE = TAG_RSAKEYVALUE;
        TAG_EXPONENT = TAG_EXPONENT;
        TAG_MODULUS = TAG_MODULUS;
        ATTR_ENCODING = ATTR_ENCODING;
        RSA = RSA;
    }
}

