/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.digsig.keys;

import com.verisign.digsig.encode.EncodingDefinitions;
import com.verisign.digsig.keys.X509Data;
import com.verisign.digsig.keys.XHMACKeyValue;
import com.verisign.digsig.keys.XHWKeyValue;
import com.verisign.digsig.keys.XKeyValue;
import com.verisign.digsig.keys.XRSAKeyValue;
import com.verisign.digsig.keys.XRetrievalMethod;
import com.verisign.digsig.util.DOMHelper;
import com.verisign.resource.ResourceFactory;
import com.verisign.resource.XMLResource;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XKeyInfo
implements EncodingDefinitions {
    public static String TAG_KEYINFO = "KeyInfo";
    private String TAG_KEYNAME = "KeyName";
    private String TAG_RETRIEVALMETHOD = "RetrievalMethod";
    private String TAG_KEYVALUE = "KeyValue";
    private static DOMHelper ops = DOMHelper.getInstance();
    private Hashtable handlers = new Hashtable();
    Document doc = null;
    XKeyValue keyValue = null;
    XRetrievalMethod retrievalMethod = null;
    Element keyInfo = null;
    String keyName = null;
    Vector x509datas = null;

    public XKeyInfo(Document doc) {
        this.doc = doc;
        this.init();
    }

    public XKeyInfo(Element keyInfo) {
        this.keyInfo = keyInfo;
        this.doc = keyInfo.getOwnerDocument();
        this.init();
        NodeList nl = keyInfo.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeType() == 1) {
                this.dispatch((Element)nl.item(i));
            }
            ++i;
        }
    }

    private void init() {
        this.handlers.put(this.TAG_KEYNAME, new KeyNameHandler());
        this.handlers.put(this.TAG_KEYVALUE, new KeyValueHandler());
        this.handlers.put("SigningHardware", new KeyValueHandler());
        this.handlers.put(this.TAG_RETRIEVALMETHOD, new RetrievalMethodHandler());
        this.handlers.put("RSAKeyValue", new RSAKeyValueHandler());
        this.handlers.put("X509Data", new X509DataHandler());
        this.handlers.put("HMACKeyValue", new HMACKeyValueHandler());
        this.handlers.put("HardwareSigningKey", new HWKeyValueHandler());
    }

    private void dispatch(Element el) {
        String nodeName = ops.getLocalName(el);
        KeyInfoHandler h = (KeyInfoHandler)this.handlers.get(nodeName);
        if (h != null) {
            h.handle(el);
        }
    }

    public Element getElement() {
        if (this.keyInfo == null) {
            this.makeElement();
        }
        return this.keyInfo;
    }

    private synchronized void makeElement() {
        this.keyInfo = ops.createElem(this.doc, TAG_KEYINFO);
        if (this.retrievalMethod != null) {
            Element e = this.retrievalMethod.getElement();
            this.keyInfo.appendChild(e);
        }
        if (this.keyName != null) {
            Element nmEl = ops.appendElem(this.keyInfo, this.TAG_KEYNAME);
            Text txt = this.doc.createTextNode(this.keyName);
            nmEl.appendChild(txt);
        }
        if (this.keyValue != null) {
            Element kvEl = this.keyValue.getElement();
            this.keyInfo.appendChild(kvEl);
        }
        if (this.x509datas != null) {
            XMLResource xmlres = ResourceFactory.getXMLResource();
            int i = 0;
            while (i < this.x509datas.size()) {
                Element x509 = ((X509Data)this.x509datas.elementAt(i)).getElement();
                this.keyInfo.appendChild(xmlres.cloneWithOwner(this.keyInfo.getOwnerDocument(), x509, true));
                ++i;
            }
        }
    }

    public synchronized XKeyValue getKeyValue() {
        return this.keyValue;
    }

    public synchronized XKeyValue getXKeyValue() {
        return this.keyValue;
    }

    public synchronized PublicKey getAsPublicKey() throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        return this.keyValue.getAsPublicKey();
    }

    public synchronized PrivateKey getAsPrivateKey() throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        return this.keyValue.getAsPrivateKey();
    }

    public synchronized void setKeyValue(XKeyValue keyv) {
        this.keyValue = keyv;
        this.keyInfo = null;
    }

    public synchronized void setKeyName(String name) {
        this.keyName = name;
        this.keyInfo = null;
    }

    public void setRetrievalMethod(XRetrievalMethod retrievalMethod) {
        this.retrievalMethod = retrievalMethod;
    }

    public synchronized String getKeyName() {
        return this.keyName;
    }

    public synchronized void addX509(X509Certificate x509) throws CertificateException {
        if (this.x509datas == null) {
            this.x509datas = new Vector();
        }
        this.x509datas.addElement(new X509Data(x509));
        this.keyInfo = null;
    }

    public synchronized void addX509(X509Data x509) {
        if (this.x509datas == null) {
            this.x509datas = new Vector();
        }
        this.x509datas.addElement(x509);
        this.keyInfo = null;
    }

    public synchronized void clearX509s() {
        this.x509datas = null;
        this.keyInfo = null;
    }

    public synchronized Enumeration enumX509Data() {
        if (this.x509datas == null) {
            return new Enumeration(){

                public boolean hasMoreElements() {
                    return false;
                }

                public Object nextElement() throws NoSuchElementException {
                    throw new NoSuchElementException();
                }
            };
        }
        return this.x509datas.elements();
    }

    public String toString() {
        return "[" + this.getClass().getName() + ": " + this.keyName + "]";
    }

    class HWKeyValueHandler
    extends KeyInfoHandler {
        HWKeyValueHandler() {
        }

        void handle(Element elem) {
            XKeyInfo.this.keyValue = new XHWKeyValue(elem);
        }
    }

    class HMACKeyValueHandler
    extends KeyInfoHandler {
        HMACKeyValueHandler() {
        }

        void handle(Element elem) {
            XKeyInfo.this.keyValue = new XHMACKeyValue(elem);
        }
    }

    class X509DataHandler
    extends KeyInfoHandler {
        X509DataHandler() {
        }

        void handle(Element elem) {
            try {
                if (XKeyInfo.this.x509datas == null) {
                    XKeyInfo.this.x509datas = new Vector();
                }
                XKeyInfo.this.x509datas.addElement(new X509Data(elem));
            }
            catch (CertificateException ce) {
                ce.printStackTrace();
            }
        }
    }

    class RSAKeyValueHandler
    extends KeyInfoHandler {
        RSAKeyValueHandler() {
        }

        void handle(Element elem) {
            XKeyInfo.this.keyValue = new XRSAKeyValue(elem);
        }
    }

    class RetrievalMethodHandler
    extends KeyInfoHandler {
        RetrievalMethodHandler() {
        }

        void handle(Element elem) {
            Element e = null;
            NodeList nl = elem.getChildNodes();
            int n = nl.getLength();
            int i = 0;
            while (i < n) {
                if (nl.item(i).getNodeType() == 1) {
                    e = (Element)nl.item(i);
                    break;
                }
                ++i;
            }
            if (e != null) {
                XKeyInfo.this.retrievalMethod = new XRetrievalMethod(elem);
            }
        }
    }

    class KeyValueHandler
    extends KeyInfoHandler {
        KeyValueHandler() {
        }

        void handle(Element elem) {
            Element elNode = null;
            NodeList nl = elem.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                if (nl.item(i).getNodeType() == 1) {
                    elNode = (Element)nl.item(i);
                    break;
                }
                ++i;
            }
            if (elNode != null) {
                XKeyInfo.this.dispatch(elNode);
            }
        }
    }

    class KeyNameHandler
    extends KeyInfoHandler {
        KeyNameHandler() {
        }

        void handle(Element elem) {
            Node nmNode = null;
            NodeList nl = elem.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                if (nl.item(i).getNodeType() == 3) {
                    nmNode = (Text)nl.item(i);
                    break;
                }
                ++i;
            }
            if (nmNode != null) {
                XKeyInfo.this.keyName = nmNode.getNodeValue();
            }
        }
    }

    abstract class KeyInfoHandler {
        KeyInfoHandler() {
        }

        abstract void handle(Element var1);
    }
}

