/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.digsig.keys;

import com.verisign.digsig.encode.EncodingDefinitions;
import com.verisign.digsig.encode.EncodingHelper;
import com.verisign.digsig.keys.SigningClient;
import com.verisign.digsig.keys.XKeyValue;
import com.verisign.digsig.util.DOMHelper;
import com.verisign.xmlsig.HardwarePrivateKey;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XHWKeyValue
extends XKeyValue
implements EncodingDefinitions {
    private static DOMHelper ops = DOMHelper.getInstance();
    private static final String TAG_SIG_NAMESPACE_URI = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String TAG_HWKEYVALUE = "HardwareSigningKey";
    public static final String TAG_KEYVALUE = "SigningHardware";
    private Document doc = null;
    private Element keyValue = null;
    private Element topKeyValue = null;
    private String hardwareName = null;
    private byte[] keyBytes = null;
    private int encoding = 1;
    private HardwarePrivateKey key = null;

    public XHWKeyValue(Document doc) {
        this.doc = doc;
    }

    public XHWKeyValue(Document doc, byte[] keyBytes) {
        this.doc = doc;
        this.keyBytes = keyBytes;
    }

    public XHWKeyValue(Element keyValue) {
        Node node = keyValue.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 3) {
                this.hardwareName = node.getNodeValue().trim();
                if (this.hardwareName != null) {
                    this.hardwareName = this.hardwareName.trim();
                    break;
                }
            }
            node = node.getNextSibling();
        }
    }

    public XHWKeyValue(URL hardwareName) {
        this.hardwareName = hardwareName.toString().trim();
    }

    public String getSignatureMethodURI() {
        return TAG_SIG_NAMESPACE_URI;
    }

    public byte[] signData(byte[] data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidKeySpecException {
        MessageDigest sha1 = MessageDigest.getInstance("SHA1");
        try {
            return SigningClient.encryptReq(this.hardwareName, sha1.digest(data));
        }
        catch (IOException ioex) {
            throw new SignatureException(ioex + "");
        }
    }

    public boolean verifySignature(byte[] data, byte[] sigd) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidKeySpecException {
        throw new InvalidKeyException("Hardware Keys do not verify!");
    }

    public Element getElement() {
        if (this.keyValue == null) {
            this.makeElement();
        }
        return this.topKeyValue;
    }

    private synchronized void makeElement() {
        if (this.keyBytes == null) {
            return;
        }
        this.topKeyValue = ops.createElem(this.doc, TAG_KEYVALUE);
        this.keyValue = ops.appendElem(this.topKeyValue, TAG_HWKEYVALUE);
        this.keyValue.appendChild(this.doc.createTextNode(EncodingHelper.encode(this.keyBytes, this.encoding)));
    }

    public synchronized void setEncoding(int encoding) {
        if (this.encoding == encoding) {
            return;
        }
        this.encoding = encoding;
        this.keyValue = null;
        this.topKeyValue = null;
    }

    public synchronized PublicKey getAsPublicKey() throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        throw new InvalidKeySpecException("Error, Hardware Keys are always Private");
    }

    public synchronized PrivateKey getAsPrivateKey() throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        if (this.key == null) {
            try {
                this.key = new HardwarePrivateKey(new URL(this.hardwareName));
            }
            catch (MalformedURLException murlex) {
                throw new InvalidKeySpecException(murlex.toString());
            }
        }
        return this.key;
    }

    static {
        TAG_SIG_NAMESPACE_URI = TAG_SIG_NAMESPACE_URI;
        TAG_HWKEYVALUE = TAG_HWKEYVALUE;
        TAG_KEYVALUE = TAG_KEYVALUE;
    }
}

