/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.digsig.keys;

import com.verisign.digsig.encode.EncodingDefinitions;
import com.verisign.digsig.encode.EncodingHelper;
import com.verisign.digsig.keys.XKeyValue;
import com.verisign.digsig.ops.XHMAC_SHA1;
import com.verisign.digsig.ops.XMac;
import com.verisign.digsig.util.DOMHelper;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XHMACKeyValue
extends XKeyValue
implements EncodingDefinitions {
    private static DOMHelper ops = DOMHelper.getInstance();
    public static final String TAG_SIG_NAMESPACE_URI = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    static final boolean MASSIVE_DEBUG = false;
    public static final String TAG_HMACKEYVALUE = "HMACKeyValue";
    public static final String TAG_KEYVALUE = "KeyValue";
    private Document doc = null;
    private Element keyValue = null;
    private Element topKeyValue = null;
    private byte[] keyBytes = null;
    private int encoding = 1;
    private XMac xmac = new XHMAC_SHA1();

    public XHMACKeyValue(Document doc) {
        this.doc = doc;
    }

    public XHMACKeyValue(Document doc, byte[] keyBytes) {
        this.doc = doc;
        this.keyBytes = keyBytes;
    }

    public XHMACKeyValue(Element keyValue) {
        if (ops.getLocalName(keyValue).equals(TAG_KEYVALUE)) {
            this.topKeyValue = keyValue;
            keyValue = ops.firstElementChild(keyValue);
        }
        this.keyValue = keyValue;
        this.doc = keyValue.getOwnerDocument();
        Node n = keyValue.getFirstChild();
        if (n != null && n.getNodeType() == 3) {
            this.keyBytes = EncodingHelper.decode(n.getNodeValue(), this.encoding);
        }
    }

    public String getSignatureMethodURI() {
        return TAG_SIG_NAMESPACE_URI;
    }

    public byte[] signData(byte[] data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidKeySpecException {
        return this.xmac.getMac(data, this.keyBytes);
    }

    public boolean verifySignature(byte[] data, byte[] sigd) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidKeySpecException {
        byte[] goodData = this.signData(data);
        if (goodData.length != sigd.length) {
            return false;
        }
        int i = 0;
        while (i < goodData.length) {
            if (goodData[i] != sigd[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Element getElement() {
        if (this.keyValue == null) {
            this.makeElement();
        }
        return this.topKeyValue;
    }

    private synchronized void makeElement() {
        if (this.keyBytes == null) {
            return;
        }
        this.topKeyValue = ops.createElem(this.doc, TAG_KEYVALUE);
        this.keyValue = ops.appendElem(this.topKeyValue, TAG_HMACKEYVALUE);
        this.keyValue.appendChild(this.doc.createTextNode(EncodingHelper.encode(this.keyBytes, this.encoding)));
    }

    public synchronized void setEncoding(int encoding) {
        if (this.encoding == encoding) {
            return;
        }
        this.encoding = encoding;
        this.keyValue = null;
        this.topKeyValue = null;
    }

    public synchronized PublicKey getAsPublicKey() throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        throw new InvalidKeySpecException("Error, This is a HMACKey");
    }

    public synchronized PrivateKey getAsPrivateKey() throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        throw new InvalidKeySpecException("Error, This is a HMACKey");
    }

    static {
        TAG_SIG_NAMESPACE_URI = TAG_SIG_NAMESPACE_URI;
        MASSIVE_DEBUG = false;
        TAG_HMACKEYVALUE = TAG_HMACKEYVALUE;
        TAG_KEYVALUE = TAG_KEYVALUE;
    }
}

