/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.digsig.keys;

import com.verisign.digsig.encode.EncodingDefinitions;
import com.verisign.digsig.encode.EncodingHelper;
import com.verisign.digsig.keys.XKeyInfo;
import com.verisign.digsig.keys.XRSAKeyValue;
import com.verisign.digsig.util.DOMHelper;
import com.verisign.resource.ResourceFactory;
import com.verisign.resource.XMLResource;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class X509Data
implements EncodingDefinitions {
    private static DOMHelper ops = DOMHelper.getInstance();
    public static final String TAG_X509Data = "X509Data";
    public static final String TAG_X509ISSUERSERIAL = "X509IssuerSerial";
    public static final String TAG_X509ISSUERNAME = "X509IssuerName";
    public static final String TAG_X509SERIALNUMBER = "X509SerialNumber";
    public static final String TAG_X509SUBJECTNAME = "X509SubjectName";
    public static final String TAG_X509SKI = "X509SKI";
    public static final String TAG_X509CERTIFICATE = "X509Certificate";
    public static final short FLAG_USE_X509ISSUERSERIAL = 1;
    public static final short FLAG_USE_X509SUBJECTNAME = 2;
    public static final short FLAG_USE_X509SKI = 4;
    public static final short FLAG_USE_X509CERTIFICATE = 8;
    public static final short ALL_USAGE_FLAGS = 15;
    public static final short DEFAULT_USAGE_FLAGS = 15;
    private short creationFlags = (short)15;
    private X509Certificate x509 = null;
    private X509Certificate[] certchain = null;
    private X509CRL crl = null;
    private Element x509Data = null;
    private boolean certIncluded = false;

    public X509Data(X509Certificate cert) throws CertificateException {
        this.x509 = cert;
        this.parseCert();
    }

    public X509Data(X509Certificate cert, short flags) throws CertificateException {
        this.x509 = cert;
        this.creationFlags = flags;
        if ((flags & 0xF) == 0) {
            throw new CertificateException("NO USAGES SPECIFIED (e.g. X509IssuerSerial)");
        }
        this.parseCert();
    }

    public X509Data(byte[] pkcs7) throws CertificateException {
        this(pkcs7, 15);
    }

    public X509Data(byte[] pkcs7, short flags) throws CertificateException {
        this.creationFlags = flags;
        ByteArrayInputStream bais = new ByteArrayInputStream(pkcs7);
        CertificateFactory cf = null;
        cf = CertificateFactory.getInstance("X.509");
        try {
            cf = CertificateFactory.getInstance("X.509", "SUN");
        }
        catch (NoSuchProviderException nspe) {
            throw new CertificateException("Need Default Provider=SUN for error free X509 parsing");
        }
        Collection<? extends Certificate> c = cf.generateCertificates(bais);
        this.certchain = new X509Certificate[c.size()];
        Iterator<? extends Certificate> i = c.iterator();
        boolean first = true;
        int num = 0;
        while (i.hasNext()) {
            X509Certificate cert = (X509Certificate)i.next();
            this.certchain[num++] = cert;
            if (first) {
                this.x509 = cert;
                this.parseCert();
                first = false;
                continue;
            }
            this.addCertificate(cert, flags);
        }
    }

    public X509Data(X509CRL crl) throws CertificateException {
        this.crl = crl;
        this.parseCRL();
    }

    public X509Data(Element x509data) throws CertificateException {
        this.x509Data = x509data;
        this.parseElem();
    }

    public Element getElement() {
        return this.x509Data;
    }

    public XKeyInfo makeKeyInfo(String keyname) throws CertificateException {
        XMLResource xmlres = ResourceFactory.getXMLResource();
        Document doc = xmlres.createDocument();
        XKeyInfo xkinfo = new XKeyInfo(doc);
        if (this.certchain == null) {
            xkinfo.addX509(this.x509);
        } else {
            int i = 0;
            while (i < this.certchain.length) {
                xkinfo.addX509(this.certchain[i]);
                ++i;
            }
        }
        xkinfo.setKeyName(keyname);
        PublicKey pk = this.x509.getPublicKey();
        if (!(pk instanceof RSAPublicKey)) {
            throw new CertificateException("No handler for " + pk.getClass());
        }
        RSAPublicKey rpk = (RSAPublicKey)pk;
        xkinfo.setKeyValue(new XRSAKeyValue(doc, rpk));
        return xkinfo;
    }

    public X509Certificate getCertificate() {
        return this.x509;
    }

    public X509Certificate[] getCertChain() {
        return this.certchain;
    }

    private void parseCert() throws CertificateException {
        if (this.x509Data != null) {
            throw new CertificateException("CERTIFICATE ALREADY PARSED");
        }
        XMLResource xmlres = ResourceFactory.getXMLResource();
        Document doc = xmlres.createDocument();
        this.x509Data = ops.appendElem(doc, TAG_X509Data);
        this.addCert(this.x509, this.x509Data, this.creationFlags);
    }

    private void addCert(X509Certificate cert, Element x509delem, short flags) throws CertificateException {
        Text tx;
        Document doc = x509delem.getOwnerDocument();
        if ((flags & 1) != 0) {
            Element is = ops.appendElem(x509delem, TAG_X509ISSUERSERIAL);
            Element in = ops.appendElem(is, TAG_X509ISSUERNAME);
            Principal pr = cert.getIssuerDN();
            tx = doc.createTextNode(pr.getName());
            in.appendChild(tx);
            Element isn = ops.appendElem(is, TAG_X509SERIALNUMBER);
            BigInteger bi = cert.getSerialNumber();
            tx = doc.createTextNode(bi.toString(10));
            Text hex = doc.createTextNode(bi.toString(16));
            isn.appendChild(tx);
        }
        if ((flags & 2) != 0) {
            Element sn = ops.appendElem(x509delem, TAG_X509SUBJECTNAME);
            Principal pr = cert.getSubjectDN();
            Text tx2 = doc.createTextNode(pr.getName());
            sn.appendChild(tx2);
        }
        if ((flags & 4) != 0) {
            Element ski = ops.appendElem(x509delem, TAG_X509SKI);
            PublicKey pk = cert.getPublicKey();
            byte[] data = pk.getEncoded();
            String b64 = EncodingHelper.encode(data, 1);
            Text tx3 = doc.createTextNode(b64);
            ski.appendChild(tx3);
        }
        if ((flags & 8) != 0) {
            Element ct = ops.appendElem(x509delem, TAG_X509CERTIFICATE);
            byte[] data = cert.getEncoded();
            String b64 = EncodingHelper.encode(data, 1);
            tx = doc.createTextNode(b64);
            ct.appendChild(tx);
            this.certIncluded = true;
        }
    }

    private void parseElem() throws CertificateException {
        NodeList nl = this.x509Data.getChildNodes();
        Vector<X509Certificate> certvector = new Vector<X509Certificate>();
        int i = 0;
        while (i < nl.getLength()) {
            Node nd = nl.item(i);
            if (nd.getNodeType() == 1) {
                Element el = (Element)nd;
                if (ops.getLocalName(el).equals(TAG_X509CERTIFICATE)) {
                    NodeList tnl = el.getChildNodes();
                    Node tx = null;
                    int n = 0;
                    while (n < tnl.getLength()) {
                        Node tnd = tnl.item(n);
                        if (tnd.getNodeType() == 3) {
                            tx = (Text)tnd;
                            break;
                        }
                        ++n;
                    }
                    if (tx == null) {
                        throw new CertificateException("NO BASE64 ENCODED CERTIFICATE DATA");
                    }
                    X509Certificate cert = null;
                    byte[] x509enc = EncodingHelper.decode(tx.getNodeValue(), 1);
                    ByteArrayInputStream bais = new ByteArrayInputStream(x509enc);
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    cert = (X509Certificate)cf.generateCertificate(bais);
                    if (this.x509 == null) {
                        this.x509 = cert;
                        this.certIncluded = true;
                    }
                    certvector.addElement(cert);
                } else if (ops.getLocalName(el).equals(TAG_X509ISSUERSERIAL) || ops.getLocalName(el).equals(TAG_X509SUBJECTNAME) || ops.getLocalName(el).equals(TAG_X509SKI)) {
                    // empty if block
                }
            }
            ++i;
        }
        if (certvector.size() > 0) {
            this.certchain = new X509Certificate[certvector.size()];
            certvector.copyInto(this.certchain);
        }
    }

    private void parseCRL() {
    }

    public void addCertificate(X509Certificate cert, short flags) throws CertificateException {
        if ((flags & 8) != 0 && !this.certIncluded) {
            Document doc = this.x509Data.getOwnerDocument();
            Element ct = ops.appendElem(doc, TAG_X509CERTIFICATE);
            byte[] data = cert.getEncoded();
            String b64 = EncodingHelper.encode(data, 1);
            Text tx = doc.createTextNode(b64);
            ct.appendChild(tx);
            this.certIncluded = true;
        }
        this.addCert(cert, this.x509Data, flags);
    }

    static {
        TAG_X509Data = TAG_X509Data;
        TAG_X509ISSUERSERIAL = TAG_X509ISSUERSERIAL;
        TAG_X509ISSUERNAME = TAG_X509ISSUERNAME;
        TAG_X509SERIALNUMBER = TAG_X509SERIALNUMBER;
        TAG_X509SUBJECTNAME = TAG_X509SUBJECTNAME;
        TAG_X509SKI = TAG_X509SKI;
        TAG_X509CERTIFICATE = TAG_X509CERTIFICATE;
        FLAG_USE_X509ISSUERSERIAL = 1;
        FLAG_USE_X509SUBJECTNAME = (short)2;
        FLAG_USE_X509SKI = (short)4;
        FLAG_USE_X509CERTIFICATE = (short)8;
        ALL_USAGE_FLAGS = (short)15;
        DEFAULT_USAGE_FLAGS = (short)15;
    }
}

