/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.digsig.keys;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.StringTokenizer;

public class SigningClient {
    public static final int BBN_ENCRBLOCK_REQ = 1;
    public static final int BBN_SIGNCERT_REQ = 2;
    public static final int BBN_SIGNCRL_REQ = 3;
    public static final int BBN_GETNAME_REQ = 11;
    public static final int BBN_GETCAKEY_REQ = 12;
    public static final int BBN_TRACE_REQ = 101;
    public static final int BBN_ENCRBLOCK_RSP = 1;
    public static final int BBN_SIGNCERT_RSP = 2;
    public static final int BBN_SIGNCRL_RSP = 3;
    public static final int BBN_GETNAME_RSP = 11;
    public static final int BBN_GETCAKEY_RSP = 12;
    public static final int BBN_TRACE_RSP = 101;
    public static final int BBN_TRACE_MSG = 1001;
    public static final int OKSUCCESS = 0;
    public static final int REQ_HEADER_LENGTH = 8;
    public static final int REQ_ENCRYPT_LENGTH = 16;
    public static final int REQ_GETNAME_LENGTH = 12;
    static final String urlDelims = "/=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encryptReq(String serverReference, byte[] data) throws IOException, MalformedURLException {
        byte[] byArray;
        URL keyURL = new URL(serverReference);
        String host = keyURL.getHost();
        int port = keyURL.getPort();
        String fileName = keyURL.getFile();
        StringTokenizer items = new StringTokenizer(fileName, urlDelims);
        int boxIndex = Integer.parseInt(items.nextToken());
        int keyIndex = Integer.parseInt(items.nextToken());
        byte[] ai = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
        byte[] aidata = new byte[ai.length + data.length];
        System.arraycopy(ai, 0, aidata, 0, ai.length);
        System.arraycopy(data, 0, aidata, ai.length, data.length);
        Socket sock = new Socket(host, port);
        try {
            byArray = SigningClient.encryptReq(sock, boxIndex, keyIndex, aidata);
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            sock.close();
            throw throwable;
        }
        sock.close();
        return byArray;
    }

    public static byte[] encryptReq(Socket sock, int boxIndex, int keyIndex, byte[] data) throws IOException {
        int encryptFlag = 0;
        DataOutputStream out = new DataOutputStream(sock.getOutputStream());
        int reqLen = 16 + data.length;
        out.writeInt(reqLen);
        out.writeShort(1);
        out.writeShort(boxIndex);
        out.writeShort(keyIndex);
        out.writeShort(0);
        out.writeInt(encryptFlag);
        out.writeInt(data.length);
        out.write(data);
        out.flush();
        DataInputStream in = new DataInputStream(sock.getInputStream());
        int rspLen = in.readInt();
        short rspType = in.readShort();
        int retCode = in.readInt();
        short discard2 = in.readShort();
        if (retCode != 0) {
            throw new IOException("Got error code " + retCode + " from server");
        }
        int msgLen = in.readInt();
        byte[] message = null;
        byte discard = in.readByte();
        if (msgLen > 0) {
            message = new byte[msgLen - 1];
            in.readFully(message);
        }
        return message;
    }

    public static int getIndexesByName(Socket sock, byte[] name) throws IOException {
        boolean encryptFlag = false;
        DataOutputStream out = new DataOutputStream(sock.getOutputStream());
        int reqLen = 12 + name.length;
        out.writeInt(reqLen);
        out.writeShort(12);
        out.writeShort(0);
        out.writeShort(0);
        out.writeShort(0);
        out.writeInt(name.length);
        out.write(name);
        out.flush();
        DataInputStream in = new DataInputStream(sock.getInputStream());
        int rspLen = in.readInt();
        short rspType = in.readShort();
        int retCode = in.readInt();
        short discard = in.readShort();
        if (retCode != 0) {
            throw new IOException("Got error code from signing server " + retCode + " from server");
        }
        short boxIndex = in.readShort();
        short keyIndex = in.readShort();
        return boxIndex << 16 | keyIndex;
    }

    public static void main(String[] args) {
        System.out.println("");
        System.out.println("running SigningClient.main() ...");
        Socket signServer = null;
        try {
            String what = args[0];
            String hostName = args[1];
            int port = Integer.parseInt(args[2]);
            System.out.println("open Connection: " + hostName + ":" + port);
            signServer = new Socket(hostName, port);
            if (what.equals("encrypt")) {
                int boxIndex = Integer.parseInt(args[3]);
                int keyIndex = Integer.parseInt(args[4]);
                byte[] digest = new byte[32];
                int i = 0;
                while (i < digest.length) {
                    digest[i] = (byte)(i + 1);
                    ++i;
                }
                System.out.print("digest: ");
                System.out.println(new BigInteger(digest).toString(16));
                byte[] encrypted = SigningClient.encryptReq(signServer, boxIndex, keyIndex, digest);
                System.out.print("encrypted: ");
                System.out.println(new BigInteger(encrypted).toString(16));
            } else if (what.equals("get")) {
                String keyName = args[3];
                BigInteger keyBig = new BigInteger(keyName, 16);
                byte[] keyBytes = keyBig.toByteArray();
                System.out.println("keyName: " + keyName);
                System.out.println("keyBytes: (" + keyBytes.length + ") " + new String(keyBytes));
                int indexes = SigningClient.getIndexesByName(signServer, keyBytes);
                System.out.println("indexes: " + indexes + " Box index: " + (indexes >> 16) + " Key index: " + (indexes & 0xFF));
            }
            signServer.close();
            signServer = null;
        }
        catch (Throwable thro) {
            thro.printStackTrace(System.out);
            try {
                if (signServer != null) {
                    signServer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
        }
        System.out.println("done.");
    }

    static {
        BBN_ENCRBLOCK_REQ = 1;
        BBN_SIGNCERT_REQ = 2;
        BBN_SIGNCRL_REQ = 3;
        BBN_GETNAME_REQ = 11;
        BBN_GETCAKEY_REQ = 12;
        BBN_TRACE_REQ = 101;
        BBN_ENCRBLOCK_RSP = 1;
        BBN_SIGNCERT_RSP = 2;
        BBN_SIGNCRL_RSP = 3;
        BBN_GETNAME_RSP = 11;
        BBN_GETCAKEY_RSP = 12;
        BBN_TRACE_RSP = 101;
        BBN_TRACE_MSG = 1001;
        OKSUCCESS = 0;
        REQ_HEADER_LENGTH = 8;
        REQ_ENCRYPT_LENGTH = 16;
        REQ_GETNAME_LENGTH = 12;
        urlDelims = urlDelims;
    }
}

