/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.digsig.encode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class UtfDataOutputStream
extends DataOutputStream {
    public UtfDataOutputStream(OutputStream out) {
        super(out);
    }

    public static int UTFBytes(char unicode) {
        if (unicode <= '\u007f') {
            return 1;
        }
        if (unicode <= '\u07ff') {
            return 2;
        }
        return 3;
    }

    public static int UTFBytes(String str) {
        int result = 0;
        int i = 0;
        while (i < str.length()) {
            result += UtfDataOutputStream.UTFBytes(str.charAt(i));
            ++i;
        }
        return result;
    }

    public int writeUTFOnly(char unicode) throws IOException {
        if (unicode <= '\u007f') {
            this.write(unicode);
            return 1;
        }
        if (unicode <= '\u07ff') {
            this.write(0xC0 | unicode >> 6);
            this.write(0x80 | 0x3F & unicode);
            return 2;
        }
        this.write(0xE0 | unicode >> 12);
        this.write(0x80 | 0x3F & unicode >> 6);
        this.write(0x80 | 0x3F & unicode);
        return 3;
    }

    public int writeUTFOnly(String str) throws IOException {
        StringBuffer buff = new StringBuffer();
        buff.setLength(0);
        int result = 0;
        int i = 0;
        while (i < str.length()) {
            result += this.writeUTFOnly(str.charAt(i));
            ++i;
        }
        return result;
    }
}

