/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.digsig.encode;

import com.verisign.digsig.encode.UtfDataOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class UtfDataInputStream
extends DataInputStream {
    public UtfDataInputStream(InputStream in) {
        super(in);
    }

    public int readUTFChar() throws IOException {
        int first = this.read();
        if (first < 128) {
            return first;
        }
        switch (first & 0xF0) {
            case 0: 
            case 16: 
            case 32: 
            case 48: 
            case 64: 
            case 80: 
            case 96: 
            case 112: {
                return first;
            }
            case 128: 
            case 144: 
            case 160: 
            case 176: {
                throw new UTFDataFormatException("continuation byte encountered first.");
            }
            case 192: 
            case 208: {
                int second = this.read();
                if (second < 0) {
                    throw new UTFDataFormatException("EOF mid character.");
                }
                return (first & 0x1F) << 6 | second & 0x3F;
            }
            case 224: {
                int second = this.read();
                if (second < 0) {
                    throw new UTFDataFormatException("EOF mid character.");
                }
                int third = this.read();
                if (third < 0) {
                    throw new UTFDataFormatException("EOF mid character.");
                }
                return (first & 0x1F) << 12 | (second & 0x3F) << 6 | third & 0x3F;
            }
            case 240: {
                throw new UTFDataFormatException("More than three bytes not supoorted.");
            }
        }
        throw new UTFDataFormatException("Should not get here");
    }

    /*
     * WARNING - void declaration
     */
    public String readUTFLine() throws IOException {
        int ch;
        StringBuffer buff = new StringBuffer();
        buff.setLength(0);
        while ((ch = this.readUTFChar()) >= 0) {
            void var2_2;
            switch (var2_2) {
                case 13: {
                    break;
                }
                case 10: {
                    return buff.toString();
                }
                default: {
                    buff.append((char)var2_2);
                }
            }
        }
        if (buff.length() < 0) {
            return null;
        }
        return buff.toString();
    }

    public String readUTFString(int byteLimit) throws IOException {
        StringBuffer buff = new StringBuffer();
        buff.setLength(0);
        while (byteLimit > 0) {
            int ch = this.readUTFChar();
            if (ch < 0) break;
            buff.append((char)ch);
            byteLimit -= UtfDataOutputStream.UTFBytes((char)ch);
        }
        if (byteLimit < 0) {
            throw new UTFDataFormatException("Byte Limit does not match data.");
        }
        if (buff.length() < 0) {
            return null;
        }
        return buff.toString();
    }
}

