/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.digsig.encode;

import com.verisign.digsig.encode.EncodingDefinitions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class EncodingHelper
implements EncodingDefinitions {
    public static final String BASE64_NAMESPACE_URI = "http://www.w3.org/2000/09/xmldsig#base64";
    public static final String BINHEX_NAMESPACE_URI = "http://www.w3.org/2000/09/xmldsig#binhex";

    public static final String getEncoderNamespaceURI(int encoding) {
        switch (encoding) {
            case 2: {
                return BINHEX_NAMESPACE_URI;
            }
        }
        return BASE64_NAMESPACE_URI;
    }

    public static final String getEncoderName(int encoding) {
        switch (encoding) {
            case 2: {
                return "binhex";
            }
        }
        return "Base64";
    }

    public static final int getEncodingId(String encoding) {
        if (encoding.equals("binhex")) {
            return 2;
        }
        return 1;
    }

    public static final byte[] decode(String encoded, int encoding) {
        switch (encoding) {
            case 2: {
                return EncodingHelper.hexbin(encoded);
            }
        }
        try {
            BASE64Decoder decoder64 = new BASE64Decoder();
            encoded = EncodingHelper.removeWhiteSpace(encoded);
            StringBufferInputStream is = new StringBufferInputStream(encoded);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            decoder64.decodeBuffer((InputStream)is, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return new byte[0];
        }
    }

    private static String removeWhiteSpace(String input) {
        int inputLen = input.length();
        StringBuffer buf = new StringBuffer(inputLen);
        int i = 0;
        while (i < inputLen) {
            char c = input.charAt(i);
            if (c != ' ' && c != '\n' && c != '\r' && c != '\t') {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    public static final String encode(byte[] data, int encoding) {
        switch (encoding) {
            case 2: {
                return EncodingHelper.binhex(data);
            }
        }
        BASE64Encoder encoder64 = new BASE64Encoder();
        String encoded = encoder64.encode(data);
        encoded = EncodingHelper.removeWhiteSpace(encoded);
        return encoded;
    }

    public static final String binhex(byte[] data) {
        char[] cbuffer = new char[data.length * 2];
        int i = 0;
        while (i < data.length) {
            byte b1 = (byte)(data[i] & 0xF);
            byte b2 = (byte)(data[i] >> 4 & 0xF);
            cbuffer[i * 2] = b1 < 10 ? (char)(b1 + 48) : (char)(b1 - 10 + 65);
            cbuffer[i * 2 + 1] = b2 < 10 ? (char)(b2 + 48) : (char)(b2 - 10 + 65);
            ++i;
        }
        return new String(cbuffer);
    }

    public static final byte[] hexbin(String hexstr) {
        byte[] ret = new byte[hexstr.length() / 2];
        int i = 0;
        while (i < hexstr.length()) {
            char c1 = hexstr.charAt(i);
            char c2 = hexstr.charAt(i + 1);
            byte b1 = c1 >= 'A' ? (byte)(c1 - 65 + 10) : (byte)(c1 - 48);
            byte b2 = (byte)((c2 >= 'A' ? (byte)(c2 - 65 + 10) : (byte)(c2 - 48)) << 4);
            ret[i / 2] = (byte)(b1 | b2);
            i += 2;
        }
        return ret;
    }

    public static final boolean equalBlobs(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        int i = 0;
        while (i < b1.length) {
            if (b1[i] != b2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static {
        BASE64_NAMESPACE_URI = BASE64_NAMESPACE_URI;
        BINHEX_NAMESPACE_URI = BINHEX_NAMESPACE_URI;
    }
}

