/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.digsig.encode;

import com.verisign.digsig.encode.EncodingDefinitions;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class Base64
implements EncodingDefinitions {
    public static final String base64String = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    public static final char[] base64Digits;
    public static final byte[] base64Values;
    int MAX_LINE_LENGTH = 72;
    static final byte[] TEST_DATA;
    static /* synthetic */ Class class$com$verisign$digsig$encode$Base64;

    public static byte[] getBase64Values() {
        byte[] result = new byte[125];
        Arrays.fill(result, (byte)-1);
        int i = 0;
        while (i < base64Digits.length) {
            result[Base64.base64Digits[i]] = i;
            i = (byte)(i + 1);
        }
        return result;
    }

    private static ByteArrayOutputStream getBAOS(int initialLength) {
        return new ByteArrayOutputStream(initialLength);
    }

    private static void releaseBAOS(ByteArrayOutputStream baos) {
        try {
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static StringBuffer getStringBuffer(int initialLength) {
        return new StringBuffer(initialLength);
    }

    private static void releaseStringBuffer(StringBuffer baos) {
    }

    public static byte[] decode(String encoded) {
        ByteArrayOutputStream baos = Base64.getBAOS(encoded.length() * 6 / 8 + 3);
        int buffer = 0;
        int goodBits = 0;
        int i = 0;
        while (i < encoded.length()) {
            byte value;
            char ch = encoded.charAt(i);
            if (ch < base64Values.length && (value = base64Values[ch]) >= 0) {
                if (value >= 64) break;
                buffer <<= 6;
                buffer |= value;
                if ((goodBits += 6) >= 8) {
                    baos.write(buffer >> goodBits - 8 & 0xFF);
                    goodBits -= 8;
                }
            }
            ++i;
        }
        byte[] result = baos.toByteArray();
        Base64.releaseBAOS(baos);
        return result;
    }

    public static String encode(byte[] data) {
        return Base64.encode(data, 72, "\r\n");
    }

    public static String encode(byte[] data, int maxLineLength, String lineSeparator) {
        int value;
        if (lineSeparator == null) {
            lineSeparator = "";
        }
        StringBuffer result = new StringBuffer();
        int buffer = 0;
        int goodBits = 0;
        int lineLen = 0;
        int i = 0;
        while (i < data.length) {
            buffer = buffer << 8 | data[i] & 0xFF;
            goodBits += 8;
            while (goodBits >= 6) {
                value = buffer >> goodBits - 6 & 0x3F;
                result.append(base64Digits[value]);
                goodBits -= 6;
                if (++lineLen < maxLineLength) continue;
                lineLen = 0;
                result.append(lineSeparator);
            }
            ++i;
        }
        if (goodBits > 0) {
            value = buffer << 6 - goodBits & 0x3F;
            result.append(base64Digits[value]);
            ++lineLen;
        }
        switch (lineLen % 4) {
            case 0: {
                break;
            }
            case 1: {
                result.append("===");
                break;
            }
            case 2: {
                result.append("==");
                break;
            }
            case 3: {
                result.append("=");
            }
        }
        return result.toString();
    }

    private static byte[] slurpBinary(String fileName) throws IOException {
        File file = new File(fileName);
        byte[] result = new byte[(int)file.length()];
        FileInputStream is = new FileInputStream(fileName);
        ((InputStream)is).read(result);
        return result;
    }

    public static void main(String[] args) {
        try {
            System.out.println("running " + (class$com$verisign$digsig$encode$Base64 == null ? (class$com$verisign$digsig$encode$Base64 = Base64.class$("com.verisign.digsig.encode.Base64")) : class$com$verisign$digsig$encode$Base64) + ".main()");
            System.out.println("argc=" + args.length);
            int i = 0;
            while (i < args.length) {
                System.out.println("   [" + i + "] " + args[i]);
                byte[] data = Base64.slurpBinary(args[i]);
                String base64String = Base64.encode(data);
                System.out.println(base64String);
                byte[] tData = Base64.decode(base64String);
                if (Arrays.equals(tData, data)) {
                    System.out.println("\nPASS!!");
                } else {
                    System.out.println("\n### FAIL: testData != TEST_DATA!!");
                }
                System.out.println("\n\n");
                ++i;
            }
            System.out.println("\n\nTEST_DATA");
            String encodedTestData = Base64.encode(TEST_DATA);
            System.out.println(encodedTestData);
            byte[] testData = Base64.decode(encodedTestData);
            System.out.println("\n\n");
            if (Arrays.equals(testData, TEST_DATA)) {
                System.out.println("PASS!!");
            } else {
                System.out.println("### FAIL: testData != TEST_DATA!!");
            }
        }
        catch (Throwable thro) {
            thro.printStackTrace(System.out);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        base64String = base64String;
        base64Digits = base64String.toCharArray();
        base64Values = Base64.getBase64Values();
        TEST_DATA = new byte[]{1, 2, 3, 0, 0, 0, -1, -1, -1, -1};
    }
}

