/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.digsig.elements;

import com.verisign.digsig.elements.Element;
import com.verisign.digsig.ops.XAlgorithm;
import com.verisign.digsig.ops.XCanonicalize;
import com.verisign.digsig.ops.XTransform;
import com.verisign.digsig.util.DOMHelper;
import com.verisign.resource.ResourceFactory;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Transforms
implements Element {
    private Vector transforms = new Vector();
    private byte[] result;

    Transforms() {
    }

    void appendTransform(XAlgorithm transform) {
        this.transforms.addElement(transform);
    }

    void applyTransforms(Node node) {
        int size = this.transforms.size();
        Node tmp = node;
        int i = 0;
        while (i < size) {
            XAlgorithm a = (XAlgorithm)this.transforms.elementAt(i);
            if (a instanceof XCanonicalize) {
                this.result = ((XCanonicalize)a).getCanonicalForm(tmp);
            } else if (a instanceof XTransform) {
                tmp = ((XTransform)a).transform(tmp);
            }
            ++i;
        }
    }

    static Transforms fromDOM(Node n) {
        DOMHelper ops = DOMHelper.getInstance();
        if (!"Transforms".equals(ops.getLocalName(n))) {
            throw new Error("This is not a Transforms node " + n);
        }
        Transforms tfms = new Transforms();
        org.w3c.dom.Element m = ops.firstElementChild(n);
        while (m != null) {
            String uri = m.getAttribute("Algorithm");
            try {
                XAlgorithm transform = XAlgorithm.getXAlgorithm(uri);
                tfms.appendTransform(transform);
            }
            catch (NoSuchAlgorithmException e) {
                throw new Error(e.toString());
            }
            m = ops.nextElementSibling(m);
        }
        return tfms;
    }

    public Document toDOM() {
        Document doc = ResourceFactory.getXMLResource().createDocument();
        DOMHelper ops = DOMHelper.getInstance();
        org.w3c.dom.Element tfms = ops.appendElem(doc, "Transforms");
        int size = this.transforms.size();
        int i = 0;
        while (i < size) {
            org.w3c.dom.Element tfm;
            XAlgorithm a = (XAlgorithm)this.transforms.elementAt(i);
            if (a instanceof XCanonicalize) {
                tfm = ops.appendElem(tfms, "Transform");
                ops.appendAttr(tfm, "Algorithm", ((XCanonicalize)a).getNamespaceURI());
            } else if (a instanceof XTransform) {
                tfm = ((XTransform)a).makeElement(doc);
                tfms.appendChild(tfm);
            }
            ++i;
        }
        return doc;
    }

    byte[] getResult() {
        return this.result;
    }
}

