/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.digsig.elements;

import com.verisign.digsig.elements.Element;
import com.verisign.digsig.elements.Reference;
import com.verisign.digsig.elements.Transforms;
import com.verisign.digsig.ops.XCanonicalize;
import com.verisign.digsig.ops.XDigest;
import com.verisign.digsig.ops.XTransform;
import com.verisign.digsig.ops.Xw3cCanonicalizer;
import com.verisign.digsig.util.DOMHelper;
import com.verisign.digsig.util.Helper;
import com.verisign.resource.ResourceFactory;
import java.security.NoSuchAlgorithmException;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SignedInfo
implements Element {
    private XCanonicalize c14nMethod;
    private Vector references;
    private String Id;
    private String signatureMethodURI;
    private XDigest xdigest = null;
    private static boolean DEBUG = false;

    SignedInfo() {
        this.references = new Vector();
        this.c14nMethod = new Xw3cCanonicalizer();
    }

    private SignedInfo(Vector references, XCanonicalize c14nMethod) {
        this.references = references;
        this.c14nMethod = c14nMethod;
    }

    void setC14nMethod(XCanonicalize c14nMethod) {
        this.c14nMethod = c14nMethod;
    }

    public XCanonicalize getC14nMethod() {
        return this.c14nMethod;
    }

    void setSignatureMethodURI(String signatureMethodURI) {
        this.signatureMethodURI = signatureMethodURI;
    }

    static SignedInfo fromDOM(Node n) {
        NodeList nl = Helper.findNodeList(n, "Reference");
        Vector<Reference> references = new Vector<Reference>();
        int i = 0;
        while (i < nl.getLength()) {
            Reference ref = Reference.fromDOM(nl.item(i));
            references.addElement(ref);
            ++i;
        }
        Xw3cCanonicalizer c14nMethod = new Xw3cCanonicalizer();
        return new SignedInfo(references, c14nMethod);
    }

    public Document toDOM() {
        Document doc = ResourceFactory.getXMLResource().createDocument();
        DOMHelper ops = DOMHelper.getInstance();
        org.w3c.dom.Element signedInfo = ops.appendElem(doc, "SignedInfo");
        org.w3c.dom.Element canon = ops.appendElem(signedInfo, "CanonicalizationMethod");
        ops.appendAttr(canon, "Algorithm", this.c14nMethod.getNamespaceURI());
        org.w3c.dom.Element sigMethod = ops.createElem(doc, "SignatureMethod");
        sigMethod.setAttribute("Algorithm", this.signatureMethodURI);
        signedInfo.appendChild(sigMethod);
        if (DEBUG) {
            Helper.dump("toDOM signedInfo before tfms", signedInfo);
        }
        int size = this.references.size();
        int i = 0;
        while (i < size) {
            Reference ref = (Reference)this.references.elementAt(i);
            Node refNode = ref.applyXPath();
            Transforms tfms = ref.getTransforms();
            tfms.applyTransforms(refNode);
            org.w3c.dom.Element e = ref.toDOM().getDocumentElement();
            Node n = ResourceFactory.getXMLResource().cloneWithOwner(doc, e, true);
            signedInfo.appendChild(n);
            ++i;
        }
        return doc;
    }

    public void setDigestAlgorithm(String uri) throws NoSuchAlgorithmException {
        this.xdigest = XDigest.getXDigest(uri);
    }

    public Reference addReference(String id, XTransform[] transforms) throws NoSuchAlgorithmException, NoSuchElementException {
        String DIGEST_ALGORITHM_NOT_SET = "Digest algorithm has not been set";
        if (this.xdigest == null) {
            throw new NoSuchAlgorithmException(DIGEST_ALGORITHM_NOT_SET);
        }
        id = "#" + id;
        Reference ref = new Reference(id);
        Transforms tfms = new Transforms();
        ref.setTransforms(tfms);
        if (transforms != null) {
            int i = 0;
            while (i < transforms.length) {
                XTransform transform = transforms[i];
                tfms.appendTransform(transform);
                ++i;
            }
        }
        tfms.appendTransform(this.c14nMethod);
        ref.setDigestMethod(this.xdigest);
        this.references.addElement(ref);
        return ref;
    }

    public byte[] getCanonicalForm(Node pos) {
        if (pos == null) {
            return this.getCanonicalForm();
        }
        Document tempDoc = ResourceFactory.getXMLResource().createDocument();
        Node tempNode = tempDoc.importNode(pos.getOwnerDocument().getDocumentElement(), true);
        tempDoc.appendChild(tempNode);
        Document doc = this.toDOM();
        Node foo = tempDoc.importNode(doc.getDocumentElement(), true);
        tempNode.appendChild(foo);
        return this.c14nMethod.getCanonicalForm(foo);
    }

    public byte[] getCanonicalForm() {
        Document doc = this.toDOM();
        return this.c14nMethod.getCanonicalForm(doc.getDocumentElement());
    }
}

