/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.digsig.elements;

import com.verisign.digsig.elements.Element;
import com.verisign.digsig.elements.KeyInfo;
import com.verisign.digsig.elements.SignatureValue;
import com.verisign.digsig.elements.SignedInfo;
import com.verisign.digsig.keys.XKeyInfo;
import com.verisign.digsig.util.DOMHelper;
import com.verisign.digsig.util.Helper;
import com.verisign.resource.ResourceFactory;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Signature
implements Element {
    private static DOMHelper ops = DOMHelper.getInstance();
    private SignedInfo signedInfo;
    private SignatureValue signatureValue;
    private KeyInfo keyInfo = null;
    private Vector objects = null;
    private XKeyInfo signingKey = null;
    private static boolean DEBUG = false;

    public Signature() {
        this.signedInfo = new SignedInfo();
        this.signatureValue = new SignatureValue();
        this.keyInfo = new KeyInfo();
    }

    private Signature(SignedInfo si, SignatureValue sv, KeyInfo ki) {
        this.signedInfo = si;
        this.signatureValue = sv;
        this.keyInfo = ki;
    }

    public static Signature fromDOM(Node n) {
        SignedInfo si = SignedInfo.fromDOM(n);
        SignatureValue sv = SignatureValue.fromDOM(n);
        KeyInfo ki = KeyInfo.fromDOM(n);
        return new Signature(si, sv, ki);
    }

    public void addObjects(Vector objects) {
        this.objects = objects;
    }

    public SignedInfo getSignedInfo() {
        return this.signedInfo;
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public static boolean canHandle(Node n) {
        return "Signature".equals(ops.getLocalName(n));
    }

    public XKeyInfo getSigningKey() {
        return this.signingKey;
    }

    public void setSigningKey(XKeyInfo signingKey) {
        this.signingKey = signingKey;
        this.signedInfo.setSignatureMethodURI(signingKey.getKeyValue().getSignatureMethodURI());
    }

    public void setSigningKey(org.w3c.dom.Element sigKey) {
        this.signingKey = new XKeyInfo(sigKey);
        this.signedInfo.setSignatureMethodURI(this.signingKey.getKeyValue().getSignatureMethodURI());
    }

    public void setSignatureValue(byte[] bsig) {
        this.signatureValue.setValue(bsig);
    }

    public Document toDOM() {
        Document doc = ResourceFactory.getXMLResource().createDocument();
        DOMHelper ops = DOMHelper.getInstance();
        org.w3c.dom.Element sig = ops.appendElem(doc, "Signature");
        org.w3c.dom.Element e = this.signedInfo.toDOM().getDocumentElement();
        Node n = ResourceFactory.getXMLResource().cloneWithOwner(doc, e, true);
        sig.appendChild(n);
        e = this.signatureValue.toDOM().getDocumentElement();
        n = ResourceFactory.getXMLResource().cloneWithOwner(doc, e, true);
        sig.appendChild(n);
        e = this.keyInfo.toDOM().getDocumentElement();
        n = ResourceFactory.getXMLResource().cloneWithOwner(doc, e, true);
        sig.appendChild(n);
        Node object = null;
        int size = this.objects.size();
        int i = 0;
        while (i < size) {
            org.w3c.dom.Element elem = (org.w3c.dom.Element)this.objects.elementAt(i);
            n = ResourceFactory.getXMLResource().cloneWithOwner(doc, elem, true);
            if (object == null) {
                object = ops.appendElem(sig, "Object");
            }
            object.appendChild(n);
            ++i;
        }
        if (DEBUG) {
            Helper.dump("toDOM Signature", doc);
        }
        return doc;
    }

    SignatureValue getSignatureValue() {
        return this.signatureValue;
    }
}

