/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.digsig.elements;

import com.verisign.digsig.elements.Element;
import com.verisign.digsig.elements.Transforms;
import com.verisign.digsig.encode.EncodingHelper;
import com.verisign.digsig.ops.XDigest;
import com.verisign.digsig.ops.XPathTransform;
import com.verisign.digsig.util.DOMHelper;
import com.verisign.digsig.util.Helper;
import com.verisign.resource.ResourceFactory;
import java.util.NoSuchElementException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Reference
implements Element {
    private Transforms transforms;
    private XDigest digestMethod;
    private String id;
    private String digestValue;
    private org.w3c.dom.Element target;
    private static boolean DEBUG = false;

    Reference(String id) {
        this.id = id;
    }

    void setTransforms(Transforms transforms) {
        this.transforms = transforms;
    }

    void setDigestMethod(XDigest xdigest) {
        this.digestMethod = xdigest;
    }

    Transforms getTransforms() {
        return this.transforms;
    }

    String getDigestValue() {
        if (this.digestValue == null) {
            byte[] digest = this.digestMethod.getDigest(this.transforms.getResult());
            this.digestValue = EncodingHelper.encode(digest, 1);
        }
        return this.digestValue;
    }

    public void setTarget(org.w3c.dom.Element target) {
        this.target = target;
    }

    Node applyXPath() throws NoSuchElementException {
        if (DEBUG) {
            Helper.dump("applyXPath", this.target);
        }
        try {
            return XPathTransform.evalXPointer(this.target, this.id);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NoSuchElementException(e.getMessage());
        }
    }

    static Reference fromDOM(Node n) {
        DOMHelper ops = DOMHelper.getInstance();
        if (!"Reference".equals(ops.getLocalName(n))) {
            throw new Error("This is not a Reference node " + n);
        }
        Transforms transforms = Transforms.fromDOM(n);
        Reference ref = new Reference(((org.w3c.dom.Element)n).getAttribute("Id"));
        ref.setTransforms(transforms);
        return ref;
    }

    public Document toDOM() {
        Document doc = ResourceFactory.getXMLResource().createDocument();
        DOMHelper ops = DOMHelper.getInstance();
        org.w3c.dom.Element ref = ops.appendElem(doc, "Reference");
        ref.setAttribute("URI", this.id);
        org.w3c.dom.Element e = this.transforms.toDOM().getDocumentElement();
        Node n = ResourceFactory.getXMLResource().cloneWithOwner(doc, e, true);
        ref.appendChild(n);
        org.w3c.dom.Element dm = ops.appendElem(ref, "DigestMethod");
        ops.appendAttr(dm, "Algorithm", this.digestMethod.getNamespaceURI());
        org.w3c.dom.Element dv = ops.appendElem(ref, "DigestValue");
        Text txt = doc.createTextNode(this.getDigestValue());
        dv.appendChild(txt);
        return doc;
    }
}

