/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.datatypes;

import java.util.Map;

public final class QName {
    private String uri;
    private String prefix;
    private String name;

    public QName(String uri, String prefix, String name) {
        this.uri = uri;
        this.prefix = prefix;
        this.name = name;
    }

    public QName(String val, Map namespaces) throws IllegalArgumentException {
        int i = val.indexOf(58);
        if (i == 0 || i == val.length() - 1) {
            throw new IllegalArgumentException("Misplaced colon in QName: " + val);
        }
        if (i > 0) {
            this.prefix = val.substring(0, i);
            this.name = val.substring(i + 1);
            this.uri = (String)namespaces.get(this.prefix);
            if (this.uri == null) {
                throw new IllegalArgumentException("unknown prefix in QName: " + val);
            }
        } else {
            this.name = val;
        }
    }

    public String getNamespaceURI() {
        return this.uri;
    }

    public String getNamespacePrefix() {
        return this.prefix;
    }

    public String getLocalName() {
        return this.name;
    }

    public boolean equals(Object o) {
        try {
            QName other = (QName)o;
            if (!this.name.equals(other.name)) {
                return false;
            }
            if (this.uri == null) {
                return other.uri == null;
            }
            return this.uri.equals(other.uri);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        if (this.prefix != null) {
            return this.prefix + ':' + this.name;
        }
        return this.name;
    }
}

