/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.crl;

import com.verisign.util.CertInfo;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.xmltrustcenter.verifier.TrustVerificationException;
import org.xmltrustcenter.verifier.TrustVerifier;

public class CRLTrustVerifier
implements TrustVerifier {
    public static String DEBUG_PROPERTY = "crltrustverifier.debug";
    static boolean _debug;
    static String VERISIGN_PRODUCTION_DIRECTORY;
    static String VERISIGN_PILOT_DIRECTORY;
    private Map cdpMap = Collections.synchronizedMap(new HashMap());
    private Map caMap = Collections.synchronizedMap(new HashMap());
    private CertificateFactory cf;
    static String TESTPCA1_CER;
    static String TESTPCA2_CER;
    static String TESTPCA3_CER;

    public CRLTrustVerifier() throws TrustVerificationException {
        try {
            this.cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ce) {
            throw new TrustVerificationException(ce);
        }
        this.addVeriSignTestRoots();
    }

    public void verifyTrust() throws TrustVerificationException {
        throw new TrustVerificationException();
    }

    public void verifyTrust(PublicKey key) throws TrustVerificationException {
        throw new TrustVerificationException();
    }

    public void verifyTrust(PublicKey key, String keyName) throws TrustVerificationException {
        throw new TrustVerificationException();
    }

    public void verifyTrust(X509Certificate[] chain) throws TrustVerificationException {
        CertInfo certinfo;
        String cdp;
        X509CRL crl;
        X509Certificate cert = chain[0];
        boolean refreshCRL = true;
        String certName = cert.getSubjectDN().getName();
        if (_debug) {
            System.out.println("CRLTrustVerifier --- verifying " + certName);
        }
        if ((crl = (X509CRL)this.cdpMap.get(cdp = (certinfo = new CertInfo(cert)).getFullNameCDP())) != null) {
            if (this.isCRLexpired(crl)) {
                this.cdpMap.remove(cdp);
                refreshCRL = true;
            } else {
                refreshCRL = false;
            }
        }
        if (refreshCRL) {
            if (certinfo.isHttpCDP()) {
                if (_debug) {
                    System.out.println("CRLTrustVerifier --- httpCDP = " + cdp);
                }
                try {
                    if (cdp.endsWith("LatestCRL")) {
                        cdp = cdp + ".crl";
                    }
                    URL url = new URL(cdp);
                    InputStream is = null;
                    is = url.openStream();
                    DataInputStream dis = new DataInputStream(is);
                    crl = (X509CRL)this.cf.generateCRL(is);
                    is.close();
                }
                catch (Exception e) {
                    throw new TrustVerificationException("cdp = " + cdp + "error - ", e);
                }
            } else if (certinfo.isLdapCDP()) {
                if (_debug) {
                    System.out.println("CRLTrustVerifier --- ldapCDP = " + cdp);
                }
                String ldapHost = new String(cdp.getBytes(), 0, cdp.lastIndexOf(47));
                String baseDN = cert.getIssuerDN().toString();
                if (_debug) {
                    System.out.println("CRLTrustVerifier --- ldap baseDN = " + baseDN);
                }
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                env.put("java.naming.provider.url", ldapHost);
                try {
                    InitialDirContext ctx = new InitialDirContext(env);
                    Attributes attrs = ctx.getAttributes(baseDN);
                    ByteArrayInputStream is = new ByteArrayInputStream((byte[])attrs.get("certificateRevocationList;binary").get());
                    crl = (X509CRL)this.cf.generateCRL(is);
                    is.close();
                }
                catch (Exception e) {
                    throw new TrustVerificationException("cdp = " + cdp + "error - ", e);
                }
            } else {
                throw new TrustVerificationException(cdp + " type cdp's are not spported.");
            }
            X509Certificate ca = this.getCrlSigner(chain, certinfo);
            if (ca == null) {
                throw new TrustVerificationException("Could not verify CRL signature");
            }
            if (!ca.getSubjectDN().toString().equals(ca.getIssuerDN().toString())) {
                X509Certificate[] cachain = new X509Certificate[]{ca};
                this.verifyTrust(cachain);
            }
            if (this.isCRLvalid(crl, ca)) {
                this.cdpMap.put(cdp, crl);
            } else {
                throw new TrustVerificationException(cdp + " CRL found for " + certName + " is not valid");
            }
        }
        if (crl.isRevoked(cert)) {
            throw new TrustVerificationException(certName + "is revoked according to CRL found at " + cdp);
        }
    }

    public void addCRLsigners(Collection certs) {
        Iterator iter = certs.iterator();
        while (iter.hasNext()) {
            X509Certificate cert = (X509Certificate)iter.next();
            this.caMap.put(cert.getSubjectDN().toString(), cert);
        }
    }

    private boolean isCRLexpired(X509CRL crl) {
        Calendar today = Calendar.getInstance();
        try {
            if (_debug) {
                System.out.println("CRLTrustVerifier --- crl.getNextUpdate() = " + crl.getNextUpdate());
            }
            if (today.getTime().after(crl.getNextUpdate())) {
                return true;
            }
        }
        catch (Exception e) {
            if (_debug) {
                System.out.println("CRLTrustVerifier --- crl expiration check failed = " + e);
            }
            return true;
        }
        return false;
    }

    private boolean isCRLvalid(X509CRL crl, X509Certificate ca) {
        try {
            crl.verify(ca.getPublicKey());
        }
        catch (Exception e) {
            if (_debug) {
                System.out.println("CRLTrustVerifier --- crl.verify failed = " + e);
            }
            return false;
        }
        return true;
    }

    private X509Certificate getCrlSigner(X509Certificate[] chain, CertInfo certinfo) throws TrustVerificationException {
        X509Certificate cert = chain[0];
        String caDN = cert.getIssuerDN().toString();
        if (chain.length > 1 && chain[1] != null) {
            if (_debug) {
                System.out.println("CRLTrustVerifier --- CA is passed in");
            }
            this.caMap.put(caDN, chain[1]);
            return chain[1];
        }
        X509Certificate ca = (X509Certificate)this.caMap.get(caDN);
        if (ca != null) {
            if (_debug) {
                System.out.println("CRLTrustVerifier --- CA from map is available");
            }
            return ca;
        }
        String aia = certinfo.getAIALocation();
        if (aia != null) {
            if (certinfo.isHttpAIA()) {
                if (_debug) {
                    System.out.println("CRLTrustVerifier --- httpAIA = " + aia);
                }
                InputStream is = null;
                try {
                    URL url = new URL(aia);
                    is = url.openStream();
                    DataInputStream dis = new DataInputStream(is);
                    ca = (X509Certificate)this.cf.generateCertificate(is);
                    is.close();
                    if (_debug) {
                        System.out.println("CRLTrustVerifier --- CA is available");
                    }
                    this.caMap.put(caDN, ca);
                    return ca;
                }
                catch (Exception e) {
                    throw new TrustVerificationException(aia + " aia is not valid error - ", e);
                }
            }
            if (certinfo.isLdapAIA()) {
                String ldapHost;
                if (_debug) {
                    System.out.println("CRLTrustVerifier --- ldapAIA = " + aia);
                }
                if ((ca = this.queryLdapForCert(ldapHost = new String(aia.getBytes(), 0, aia.lastIndexOf(47)), caDN)) != null) {
                    this.caMap.put(caDN, ca);
                }
                return ca;
            }
        }
        try {
            URL xkmsUrl = certinfo.getXkmsUrl();
            if (xkmsUrl != null) {
                if (xkmsUrl == CertInfo.XKMS_PRODUCTION_URL) {
                    ca = this.queryLdapForCert(VERISIGN_PRODUCTION_DIRECTORY, caDN);
                    if (ca != null) {
                        this.caMap.put(caDN, ca);
                        if (_debug) {
                            System.out.println("CRLTrustVerifier --- CA from = " + VERISIGN_PRODUCTION_DIRECTORY);
                        }
                    }
                    return ca;
                }
                if (xkmsUrl == CertInfo.XKMS_PILOT_URL) {
                    ca = this.queryLdapForCert(VERISIGN_PILOT_DIRECTORY, caDN);
                    if (ca != null) {
                        this.caMap.put(caDN, ca);
                        if (_debug) {
                            System.out.println("CRLTrustVerifier --- CA from = " + VERISIGN_PILOT_DIRECTORY);
                        }
                    }
                    return ca;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (_debug) {
            System.out.println("CRLTrustVerifier --- CA is NOT available");
        }
        return null;
    }

    private X509Certificate queryLdapForCert(String ldapHost, String dn) {
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", ldapHost);
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes attrs = ctx.getAttributes(dn);
            ByteArrayInputStream is = new ByteArrayInputStream((byte[])attrs.get("cacertificate;binary").get());
            X509Certificate ca = (X509Certificate)this.cf.generateCertificate(is);
            is.close();
            return ca;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void addVeriSignTestRoots() {
        ArrayList<X509Certificate> testRoots = new ArrayList<X509Certificate>();
        try {
            X509Certificate cert = (X509Certificate)this.cf.generateCertificate(new ByteArrayInputStream(TESTPCA1_CER.getBytes()));
            testRoots.add(cert);
            cert = (X509Certificate)this.cf.generateCertificate(new ByteArrayInputStream(TESTPCA2_CER.getBytes()));
            testRoots.add(cert);
            cert = (X509Certificate)this.cf.generateCertificate(new ByteArrayInputStream(TESTPCA3_CER.getBytes()));
            testRoots.add(cert);
        }
        catch (Exception e) {
            System.out.println("Exception = " + e);
        }
        this.addCRLsigners(testRoots);
    }

    static {
        String p = System.getProperty(DEBUG_PROPERTY);
        _debug = p != null && p.equalsIgnoreCase("true");
        VERISIGN_PRODUCTION_DIRECTORY = "ldap://directory.verisign.com";
        VERISIGN_PILOT_DIRECTORY = "ldap://pilotldap.verisign.com";
        TESTPCA1_CER = "-----BEGIN CERTIFICATE-----\nMIIDYDCCAskCEEZ+CGcrgxtfQ9sTmDM3gswwDQYJKoZIhvcNAQEFBQAwgfAxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjFBMD8GA1UECxM4Q2xhc3MgMSBURVNUIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzIxQzBBBgNVBAsTOlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20vY3BzL3Rlc3RjYS8gKGMpMDIxHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsxHzAdBgNVBAsTFkZvciBUZXN0IFB1cnBvc2VzIE9ubHkwHhcNMDIwNDIwMDAwMDAwWhcNMjgwODAxMjM1OTU5WjCB8DELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMUEwPwYDVQQLEzhDbGFzcyAxIFRFU1QgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgLSBHMjFDMEEGA1UECxM6VGVybXMgb2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNvbS9jcHMvdGVzdGNhLyAoYykwMjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazEfMB0GA1UECxMWRm9yIFRlc3QgUHVycG9zZXMgT25seTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA4ErpYEV9Pn/nY5wHuHsDjWNxpixT9FRPTK8WxcbY7Zp+E1f0HWMN6lrA3CQQM/WWUzjxoQx79fX6pBqaOrZsdYDqH1PSaCDu/ZhOGgxOuAIHoCzKzP6xy9KFNmtJ1bC+YDQM1JIo4/aAJU20Btax+5yQ4moDH36vBKd1ZwlT+e8CAwEAATANBgkqhkiG9w0BAQUFAAOBgQB2qWKmCufBKbHSCGRcyOTIsSGbZZJkTtpILwQkCRGmJK1BRMT5lzuD3bUyXRsbbQVLsl6w/m6p9WY9TJj8Ir0efrn6H0V8XZ+K/R0fISi7eGAdkm48wGscODnnIv2Jk4fiwW6FB+FPbSjQnwx9mJGlpWy10culvx0F/7daabU+sw==\n-----END CERTIFICATE-----";
        TESTPCA2_CER = "-----BEGIN CERTIFICATE-----\nMIIDYDCCAskCEFGPHJ5mo1ju2GI/3a+Lzj0wDQYJKoZIhvcNAQEFBQAwgfAxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjFBMD8GA1UECxM4Q2xhc3MgMiBURVNUIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzIxQzBBBgNVBAsTOlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20vY3BzL3Rlc3RjYS8gKGMpMDIxHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsxHzAdBgNVBAsTFkZvciBUZXN0IFB1cnBvc2VzIE9ubHkwHhcNMDIwNDIwMDAwMDAwWhcNMjgwODAxMjM1OTU5WjCB8DELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMUEwPwYDVQQLEzhDbGFzcyAyIFRFU1QgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgLSBHMjFDMEEGA1UECxM6VGVybXMgb2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNvbS9jcHMvdGVzdGNhLyAoYykwMjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazEfMB0GA1UECxMWRm9yIFRlc3QgUHVycG9zZXMgT25seTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA60eHRXpO0VTdqWroeajDYMta9SDVIOGvUOGSN81/O1TYjzjHGgHQvWC00J79dY+U2ksjGxNosXbHZz0jsWVcDgrGImdf0Hxq/6XAkNt0sWoS7HS/5a0P7kR0ktfjeuOEgZniWyIjuQrUn/oKYFxPPxg1DR5XRCkGQQVgJPtUfQ8CAwEAATANBgkqhkiG9w0BAQUFAAOBgQDRT+AD1HFFCeo/xz2Y2az7ytNqoRh0B4sO5VPDreSy25vrWhU9q79bu7txxQHZ+m+xvnX+rBwyMKBgwF3VPdUmzhN7kire6m9nI4s/+kW7wtbWrZduCH8JMeiJRe2xYS1EFda7o7WyQ93DMepZHqt+AO+kuYnW1MiORflWcxSg+Q==\n-----END CERTIFICATE-----";
        TESTPCA3_CER = "-----BEGIN CERTIFICATE-----\nMIIDYDCCAskCEE7AAy8i52UxbSDBnU1yPOYwDQYJKoZIhvcNAQEFBQAwgfAxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjFBMD8GA1UECxM4Q2xhc3MgMyBURVNUIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzIxQzBBBgNVBAsTOlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20vY3BzL3Rlc3RjYS8gKGMpMDIxHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsxHzAdBgNVBAsTFkZvciBUZXN0IFB1cnBvc2VzIE9ubHkwHhcNMDIwNDIwMDAwMDAwWhcNMjgwODAxMjM1OTU5WjCB8DELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMUEwPwYDVQQLEzhDbGFzcyAzIFRFU1QgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgLSBHMjFDMEEGA1UECxM6VGVybXMgb2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNvbS9jcHMvdGVzdGNhLyAoYykwMjEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazEfMB0GA1UECxMWRm9yIFRlc3QgUHVycG9zZXMgT25seTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA1LckyPH44lNpEK+fu5Fx316ok0Z3ToZCm9WJTEgM5XZSO0KYonRCh2qaa/UQarc8AJpyGNXyTd1bJMyR8o/ETZWKxmYN/cM1cIf8f27U+Fg4rChXMe2e8rgaLiOIQXvsNqJfGeZVnpW9ieqspZnUduWGm3eBnAAO5w41WN4+xLkCAwEAATANBgkqhkiG9w0BAQUFAAOBgQBXyPWRwGUbjWWyIgcwrVa/P9of8HKoAh/RIM8c0SfuIpWPtBTrDWLoOYsRn7uE2p+FZNS95rqehwbgXQGes2W5xaCFj7amu/+gajiewXI3+XONSXkE1SPa9KfYj0pC8cQQ10wxwa87gS9hGwRKR4mMNG6d4UdVnLo+mUzWKxdZaA==\n-----END CERTIFICATE-----";
    }
}

