/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.c14n;

import com.verisign.c14n.AbstractCanonicalizer;
import com.verisign.c14n.AttributeComparator;
import com.verisign.c14n.Canonicalizer;
import com.verisign.c14n.SAXHandler;
import com.verisign.resource.DOMOperations;
import com.verisign.resource.ResourceFactory;
import com.verisign.resource.XMLResource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

class StreamCanonicalizer
implements Canonicalizer {
    private static final String NS_XMLNS = "http://www.w3.org/2000/xmlns/";
    private static final String UTF8 = "UTF8";
    private static final String PI_PREFIX = "<?";
    private static final String PI_SUFFIX = "?>";
    private static final String ELEM_PREFIX = "<";
    private static final String ELEM_SUFFIX = ">";
    private static final String ELEM_END_PREFIX = "</";
    private static final char SPACE = ' ';
    private static final char QUOTE = '\"';
    private static final String EQUAL_QUOTE = "=\"";
    private static final String COMMENT_PREFIX = "<!--";
    private static final String COMMENT_SUFFIX = "-->";
    private static final XMLResource xml;
    private static final Document staticDoc;
    private static final AttributeComparator attributeComparator;
    private DOMOperations ops;
    private boolean exclusive;
    private boolean includeComments;
    private List includePrefixes;
    private NamespaceSupport inScopeNamespaces;
    private NamespaceSupport renderedNamespaces;
    private boolean atTopElement;
    private ByteArrayOutputStream baos;
    private OutputStreamWriter writer;

    StreamCanonicalizer(boolean exclusive, boolean includeComments) {
        this.exclusive = exclusive;
        this.includeComments = includeComments;
        this.ops = DOMOperations.getInstance();
        this.baos = new ByteArrayOutputStream(8192);
        try {
            this.writer = new OutputStreamWriter((OutputStream)this.baos, UTF8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setInclusivePrefixList(List list) {
        this.includePrefixes = list;
    }

    public byte[] canonicalize(Node node, Map parentNamespaces) {
        Element elem;
        this.ops = new DOMOperations(node);
        this.inScopeNamespaces = new NamespaceSupport();
        NamespaceSupport namespaceSupport = this.renderedNamespaces = this.exclusive ? new NamespaceSupport() : null;
        if (parentNamespaces != null) {
            this.addToNamespaceContext(this.inScopeNamespaces, parentNamespaces);
        }
        if (node.getNodeType() == 1 && (elem = (Element)node) != elem.getOwnerDocument().getDocumentElement()) {
            elem = (Element)elem.getParentNode();
            this.addToNamespaceContext(this.inScopeNamespaces, this.ops.getInScopeNamespaces(elem));
        }
        this.baos.reset();
        this.atTopElement = true;
        try {
            this.processNode(node);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.baos.toByteArray();
    }

    public SAXHandler getSAXHandler(Map parentNamespaces) throws UnsupportedOperationException {
        this.inScopeNamespaces = new NamespaceSupport();
        NamespaceSupport namespaceSupport = this.renderedNamespaces = this.exclusive ? new NamespaceSupport() : null;
        if (parentNamespaces != null) {
            this.addToNamespaceContext(this.inScopeNamespaces, parentNamespaces);
        }
        this.baos.reset();
        this.atTopElement = true;
        return new Handler();
    }

    private void addToNamespaceContext(NamespaceSupport context, Map add) {
        Iterator i = add.keySet().iterator();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            String uri = (String)add.get(prefix);
            if (prefix == null) {
                prefix = "";
            }
            if (uri == null) {
                uri = "";
            }
            this.inScopeNamespaces.declarePrefix(prefix, uri);
        }
    }

    public byte[] getSAXResult() throws UnsupportedOperationException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.baos.toByteArray();
    }

    private void processNode(Node node) throws IOException {
        this.processNodeStart(node);
        Node child = node.getFirstChild();
        while (child != null) {
            this.processNode(child);
            child = child.getNextSibling();
        }
        this.processNodeEnd(node);
    }

    private void processNodeStart(Node node) throws IOException {
        short type = node.getNodeType();
        switch (type) {
            case 8: {
                this.processComment(node.getNodeValue());
                break;
            }
            case 1: {
                int len;
                ArrayList<Node> attrs = null;
                NamedNodeMap attrMap = node.getAttributes();
                if (attrMap != null && (len = attrMap.getLength()) > 0) {
                    attrs = new ArrayList<Node>(len);
                    int i = 0;
                    while (i < len) {
                        attrs.add(attrMap.item(i));
                        ++i;
                    }
                }
                this.processElemStart(node.getNodeName(), this.ops.getPrefix(node), this.ops.getNamespaceURI(node), attrs);
                break;
            }
            case 3: 
            case 4: {
                this.processChars(node.getNodeValue());
                break;
            }
            case 7: {
                String data = node.getNodeValue();
                this.processPI(node.getNodeName(), data);
            }
        }
    }

    private void processNodeEnd(Node node) throws IOException {
        short type = node.getNodeType();
        switch (type) {
            case 1: {
                this.processElemEnd(node.getNodeName());
            }
        }
    }

    private void processPI(String name, String data) throws IOException {
        this.writer.write(PI_PREFIX);
        this.writer.write(name);
        if (data != null && data.length() > 0) {
            this.writer.write(32);
            this.writer.write(data);
        }
        this.writer.write(PI_SUFFIX);
    }

    private void processPI(String name, char[] chars, int off, int len) throws IOException {
        this.writer.write(PI_PREFIX);
        this.writer.write(name);
        if (chars != null && len > 0) {
            this.writer.write(32);
            this.writer.write(chars, off, len);
        }
        this.writer.write(PI_SUFFIX);
    }

    private void processComment(String text) throws IOException {
        if (this.includeComments) {
            this.writer.write(COMMENT_PREFIX);
            this.writer.write(text);
            this.writer.write(COMMENT_SUFFIX);
        }
    }

    private void processComment(char[] chars, int off, int len) throws IOException {
        if (this.includeComments) {
            this.writer.write(COMMENT_PREFIX);
            this.writer.write(chars, off, len);
            this.writer.write(COMMENT_SUFFIX);
        }
    }

    private void processChars(String text) throws IOException {
        text = AbstractCanonicalizer.escape(false, text);
        this.writer.write(text);
    }

    private void processChars(char[] chars, int off, int len) throws IOException {
        String s = AbstractCanonicalizer.escape(false, chars, off, len);
        if (s != null) {
            this.writer.write(s);
        } else {
            this.writer.write(chars, off, len);
        }
    }

    private void processElemStart(String qname, String prefix, String uri, List attrs) throws IOException {
        if (attrs == null) {
            attrs = new ArrayList();
        }
        this.writer.write(ELEM_PREFIX);
        this.writer.write(qname);
        this.inScopeNamespaces.pushContext();
        if (this.renderedNamespaces != null) {
            this.renderedNamespaces.pushContext();
        }
        if (this.exclusive) {
            this.processAttrsExclusive(qname, prefix, uri, attrs);
        } else {
            this.processAttrsNormal(attrs);
        }
        this.writer.write(ELEM_SUFFIX);
        this.atTopElement = false;
    }

    private void processAttrsNormal(List attrs) throws IOException {
        if (this.atTopElement) {
            AllPrefixes prefixes = new AllPrefixes(this.inScopeNamespaces);
            while (prefixes.hasNext()) {
                String prefix = (String)prefixes.next();
                String val = this.inScopeNamespaces.getURI(prefix);
                boolean found = false;
                int i = 0;
                while (i < attrs.size() && !found) {
                    Attr attr = (Attr)attrs.get(i);
                    if (AttributeComparator.isNamespaceAttr(attr) && prefix.equals(this.getNamespaceAttrPrefix(attr))) {
                        found = true;
                    }
                    ++i;
                }
                if (found) continue;
                attrs.add(this.createNamespaceAttr(prefix, val));
            }
            if (attrs.size() > 1) {
                Collections.sort(attrs, attributeComparator);
            }
            int i = 0;
            while (i < attrs.size()) {
                Attr attr = (Attr)attrs.get(i);
                this.renderAttr(attr);
                if (AttributeComparator.isNamespaceAttr(attr)) {
                    String prefix = this.getNamespaceAttrPrefix(attr);
                    String val = attr.getNodeValue();
                    this.inScopeNamespaces.declarePrefix(prefix, val);
                }
                ++i;
            }
        } else {
            if (attrs.size() > 1) {
                Collections.sort(attrs, attributeComparator);
            }
            int i = 0;
            while (i < attrs.size()) {
                Attr attr = (Attr)attrs.get(i);
                if (AttributeComparator.isNamespaceAttr(attr)) {
                    String prefix = this.getNamespaceAttrPrefix(attr);
                    String val = attr.getNodeValue();
                    String uri = this.inScopeNamespaces.getURI(prefix);
                    if (!this.uriEqual(uri, val)) {
                        this.renderAttr(attr);
                        this.inScopeNamespaces.declarePrefix(prefix, val);
                    }
                } else {
                    this.renderAttr(attr);
                }
                ++i;
            }
        }
    }

    private void processAttrsExclusive(String elemQName, String elemPrefix, String elemUri, List attrs) throws IOException {
        String val;
        String prefix;
        String uri;
        String prefix2;
        int i = 0;
        while (i < attrs.size()) {
            Attr attr = (Attr)attrs.get(i);
            if (AttributeComparator.isNamespaceAttr(attr)) {
                boolean mustInclude;
                String val2;
                prefix2 = this.getNamespaceAttrPrefix(attr);
                uri = this.inScopeNamespaces.getURI(prefix2);
                boolean inScope = this.uriEqual(uri, val2 = attr.getNodeValue());
                boolean bl = mustInclude = !inScope && this.includePrefixes != null && this.includePrefixes.contains(prefix2);
                if (!inScope) {
                    this.inScopeNamespaces.declarePrefix(prefix2, val2);
                }
                if (mustInclude) {
                    this.renderedNamespaces.declarePrefix(prefix2, val2);
                } else {
                    attrs.remove(i);
                    --i;
                }
            }
            ++i;
        }
        if (this.atTopElement) {
            AllPrefixes prefixes = new AllPrefixes(this.inScopeNamespaces);
            while (prefixes.hasNext()) {
                prefix2 = (String)prefixes.next();
                if (prefix2.equals("xml") || this.includePrefixes == null || !this.includePrefixes.contains(prefix2) || this.renderedNamespaces.getURI(prefix2) != null) continue;
                String val3 = this.inScopeNamespaces.getURI(prefix2);
                attrs.add(this.createNamespaceAttr(prefix2, val3));
                this.inScopeNamespaces.declarePrefix(prefix2, val3);
                this.renderedNamespaces.declarePrefix(prefix2, val3);
            }
        }
        if ((prefix = elemPrefix) == null) {
            prefix = "";
        }
        if ((val = elemUri) == null) {
            val = "";
        }
        if (!this.uriEqual(uri = this.renderedNamespaces.getURI(prefix), val)) {
            attrs.add(this.createNamespaceAttr(prefix, val));
            this.renderedNamespaces.declarePrefix(prefix, val);
        }
        int i2 = 0;
        while (i2 < attrs.size()) {
            Attr attr = (Attr)attrs.get(i2);
            if (!AttributeComparator.isNamespaceAttr(attr) && (prefix = this.ops.getPrefix(attr)) != null) {
                val = this.ops.getNamespaceURI(attr);
                if (val == null) {
                    val = "";
                }
                if (!this.uriEqual(uri = this.renderedNamespaces.getURI(prefix), val)) {
                    String qname = "xmlns:" + prefix;
                    attrs.add(this.createNamespaceAttr(prefix, val));
                    this.renderedNamespaces.declarePrefix(prefix, val);
                }
            }
            ++i2;
        }
        if (attrs.size() > 1) {
            Collections.sort(attrs, attributeComparator);
        }
        int i3 = 0;
        while (i3 < attrs.size()) {
            Attr attr = (Attr)attrs.get(i3);
            this.renderAttr(attr);
            ++i3;
        }
    }

    private void renderAttr(Attr attr) throws IOException {
        String val = attr.getNodeValue();
        if (AttributeComparator.isNamespaceAttr(attr)) {
            String prefix = this.getNamespaceAttrPrefix(attr);
            if (prefix.equals("xml")) {
                return;
            }
            if (this.atTopElement && prefix.length() == 0 && val.length() == 0) {
                return;
            }
        }
        this.writer.write(32);
        this.writer.write(attr.getNodeName());
        this.writer.write(EQUAL_QUOTE);
        this.writer.write(AbstractCanonicalizer.escape(true, val));
        this.writer.write(34);
    }

    private void processElemEnd(String qname) throws IOException {
        this.writer.write(ELEM_END_PREFIX);
        this.writer.write(qname);
        this.writer.write(ELEM_SUFFIX);
        this.inScopeNamespaces.popContext();
        if (this.renderedNamespaces != null) {
            this.renderedNamespaces.popContext();
        }
    }

    private boolean uriEqual(String uri1, String uri2) {
        if (uri1 == null) {
            uri1 = "";
        }
        if (uri2 == null) {
            uri2 = "";
        }
        return uri1.equals(uri2);
    }

    private String getNamespaceAttrPrefix(Attr attr) {
        String name = this.ops.getLocalName(attr);
        if ("xmlns".equals(name)) {
            name = "";
        }
        return name;
    }

    private Attr createNamespaceAttr(String prefix, String uri) {
        String qname = prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix;
        Attr nsAttr = staticDoc.createAttributeNS(NS_XMLNS, qname);
        nsAttr.setValue(uri);
        return nsAttr;
    }

    static {
        NS_XMLNS = NS_XMLNS;
        UTF8 = UTF8;
        PI_PREFIX = PI_PREFIX;
        PI_SUFFIX = PI_SUFFIX;
        ELEM_PREFIX = ELEM_PREFIX;
        ELEM_SUFFIX = ELEM_SUFFIX;
        ELEM_END_PREFIX = ELEM_END_PREFIX;
        SPACE = (char)32;
        QUOTE = (char)34;
        EQUAL_QUOTE = EQUAL_QUOTE;
        COMMENT_PREFIX = COMMENT_PREFIX;
        COMMENT_SUFFIX = COMMENT_SUFFIX;
        xml = ResourceFactory.getXMLResource();
        staticDoc = xml.createDocument();
        attributeComparator = new AttributeComparator();
    }

    private static class AllPrefixes
    implements Iterator {
        private NamespaceSupport namespaces;
        private Enumeration prefixes;

        AllPrefixes(NamespaceSupport namespaces) {
            this.namespaces = namespaces;
            this.prefixes = namespaces.getPrefixes();
            this.hasNext();
        }

        public boolean hasNext() {
            if (this.prefixes != null) {
                if (this.prefixes.hasMoreElements()) {
                    return true;
                }
                this.prefixes = null;
            }
            return this.namespaces != null && this.namespaces.getURI("") != null;
        }

        public Object next() {
            if (this.prefixes != null) {
                if (this.prefixes.hasMoreElements()) {
                    return this.prefixes.nextElement();
                }
                this.prefixes = null;
            }
            if (this.namespaces != null && this.namespaces.getURI("") != null) {
                this.namespaces = null;
                return "";
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class Handler
    implements SAXHandler {
        private Handler() {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void startElement(String uri, String localName, String qname, Attributes saxAttrs) throws SAXException {
            int len = saxAttrs.getLength();
            ArrayList<Attr> attrs = null;
            if (len > 0) {
                attrs = new ArrayList<Attr>(len);
                int i = 0;
                while (i < len) {
                    Attr attr = staticDoc.createAttributeNS(saxAttrs.getURI(i), saxAttrs.getQName(i));
                    attr.setValue(saxAttrs.getValue(i));
                    attrs.add(attr);
                    ++i;
                }
            }
            String prefix = null;
            int qnameLen = qname.length();
            int localNameLen = localName.length();
            if (localNameLen != qnameLen) {
                prefix = qname.substring(0, qnameLen - localNameLen - 1);
            }
            try {
                StreamCanonicalizer.this.processElemStart(qname, prefix, uri, attrs);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        public void endElement(String uri, String localName, String qname) throws SAXException {
            try {
                StreamCanonicalizer.this.processElemEnd(qname);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                StreamCanonicalizer.this.processChars(ch, start, length);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            try {
                StreamCanonicalizer.this.processChars(ch, start, length);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        public void processingInstruction(String target, String data) throws SAXException {
            try {
                StreamCanonicalizer.this.processPI(target, data);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        public void endDTD() throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void endCDATA() throws SAXException {
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            try {
                StreamCanonicalizer.this.processComment(ch, start, length);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }
}

