/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.c14n;

import com.verisign.c14n.AbstractCanonicalizer;
import com.verisign.c14n.AttributeComparator;
import com.verisign.util.Debug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class ExclusiveCanonicalizer
extends AbstractCanonicalizer {
    private List prefixList = new ArrayList();
    private HashMap ancestralNamespaces = new HashMap();
    private List namespaceStack = new ArrayList();

    ExclusiveCanonicalizer(boolean useComments) {
        super(useComments);
    }

    void handleAncestralNamespaces(Node node, Map namespaces) {
        this.ancestralNamespaces.putAll(namespaces);
    }

    boolean shouldAncestralAttributeBeAdded(Attr attribute, Node node) {
        String s = AbstractCanonicalizer.ops.getLocalName(attribute);
        if ("xmlns".equals(s)) {
            return true;
        }
        return this.prefixList.contains(s);
    }

    public void setInclusivePrefixList(List list) {
        if (list == null) {
            throw new IllegalArgumentException("prefix cannot be null");
        }
        this.prefixList = list;
    }

    void beforeElement(Node node) {
        Attr attr;
        int i;
        int len;
        this.dbg(Debug.ALL, "Add visibly used namespaces for node" + node);
        ArrayList<String> visiblePrefixes = new ArrayList<String>();
        String elemPrefix = AbstractCanonicalizer.ops.getPrefix(node);
        if (elemPrefix == null) {
            elemPrefix = "xmlns";
        }
        this.dbg(Debug.ALL, "Add " + elemPrefix + " to list");
        visiblePrefixes.add(elemPrefix);
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            len = attrs.getLength();
            i = 0;
            while (i < len) {
                String attrPrefix;
                attr = (Attr)attrs.item(i);
                if (!AttributeComparator.isNamespaceAttr(attr) && (attrPrefix = AbstractCanonicalizer.ops.getPrefix(attr)) != null) {
                    this.dbg(Debug.ALL, "Add " + attrPrefix + " to list");
                    visiblePrefixes.add(attrPrefix);
                }
                ++i;
            }
        }
        this.namespaceStack.add(this.ancestralNamespaces);
        this.ancestralNamespaces = (HashMap)this.ancestralNamespaces.clone();
        if (attrs != null) {
            len = attrs.getLength();
            i = 0;
            while (i < len) {
                attr = (Attr)attrs.item(i);
                if (attr != null && AttributeComparator.isNamespaceAttr(attr)) {
                    String nsPrefix = AbstractCanonicalizer.ops.getLocalName(attr);
                    this.ancestralNamespaces.put(nsPrefix, attr);
                    if (!this.prefixList.contains(nsPrefix) && !visiblePrefixes.contains(nsPrefix)) {
                        this.dbg(Debug.ALL, "Removing namespace " + nsPrefix);
                        ((Element)node).removeAttributeNode(attr);
                        --i;
                    }
                }
                ++i;
            }
        }
        Iterator iter = this.ancestralNamespaces.values().iterator();
        while (iter.hasNext()) {
            Attr attr2 = (Attr)iter.next();
            String nsPrefix = AbstractCanonicalizer.ops.getLocalName(attr2);
            if (!this.prefixList.contains(nsPrefix) && !visiblePrefixes.contains(nsPrefix)) continue;
            this.dbg(Debug.ALL, "Adding namespace " + nsPrefix);
            ((Element)node).setAttributeNS(AbstractCanonicalizer.ops.getNamespaceURI(attr2), attr2.getName(), attr2.getValue());
        }
    }

    void afterElement(Node node) {
        this.ancestralNamespaces = (HashMap)this.namespaceStack.remove(this.namespaceStack.size() - 1);
    }

    protected Node removeExtraNamespaces(Node node, Node topNode) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return node;
        }
        int len = attrs.getLength();
        int i = 0;
        while (i < len) {
            Attr attr = (Attr)attrs.item(i);
            if (attr != null) {
                String value = attr.getValue();
                if (AttributeComparator.isNamespaceAttr(attr)) {
                    Node parent = node.getParentNode();
                    while (parent != null) {
                        Attr parentAttr = ((Element)parent).getAttributeNode(attr.getName());
                        if (parentAttr != null) {
                            if (parentAttr.getValue().equals(value)) {
                                ((Element)node).removeAttributeNode(attr);
                                --i;
                            }
                            parent = null;
                            continue;
                        }
                        parent = parent == topNode ? null : parent.getParentNode();
                    }
                }
            }
            ++i;
        }
        return node;
    }
}

